/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.ai;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.easing.EasingType;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class MountAnimationManager {
    private final MountEntity mountEntity;
    protected AnimationController<MountEntity> animationController;
    protected AnimationController<MountEntity> blinkAnimationController;
    protected AnimationController<MountEntity> idleAnimationController;
    private double currentTick;
    private double moveAnimationLength;
    private double moveAnimationTimer;
    private AnimationPhase currentMoveState;
    private float animationTick = 0.0f;

    public MountAnimationManager(MountEntity entity) {
        this.mountEntity = entity;
    }

    public void registerControllers(AnimationData animationData) {
        this.animationController = new AnimationController((IAnimatable)this.mountEntity, "moveController", 0.0f, this::moveAnimationPredicate);
        this.blinkAnimationController = new AnimationController((IAnimatable)this.mountEntity, "blinkController", 0.0f, this::blinkAnimationPredicate);
        this.idleAnimationController = new AnimationController((IAnimatable)this.mountEntity, "idleController", 0.0f, this::idleAnimationPredicate);
        animationData.setResetSpeedInTicks(10.0);
        animationData.addAnimationController(this.animationController);
        animationData.addAnimationController(this.blinkAnimationController);
        animationData.addAnimationController(this.idleAnimationController);
    }

    protected <P extends IAnimatable> PlayState moveAnimationPredicate(AnimationEvent<P> event) {
        this.animationController.transitionLengthTicks = 0.0;
        this.animationController.easingType = EasingType.Linear;
        String guiBookClass = "class vazkii.patchouli.client.book.gui.GuiBookEntry";
        if (this.mountEntity.m_20318_(0.0f).equals((Object)Vec3.f_82478_)) {
            if (this.animationController.getCurrentAnimation() == null) {
                event.getController().setAnimation(this.mountEntity.getNeutralAnimation());
            }
            return PlayState.CONTINUE;
        }
        if (this.animationController.getCurrentAnimation() != null) {
            this.moveAnimationLength = this.animationController.getCurrentAnimation().animationLength;
        }
        double lastTick = this.currentTick;
        this.currentTick = event.animationTick;
        double tickDelta = this.currentTick - lastTick;
        this.moveAnimationTimer += tickDelta;
        AnimationPhase lastMoveState = this.currentMoveState;
        this.currentMoveState = this.mountEntity.getIsSleeping() ? AnimationPhase.SLEEP : (event.isMoving() ? AnimationPhase.WALK : (this.mountEntity.getIsSitting() ? AnimationPhase.SIT : AnimationPhase.IDLE));
        if (this.moveAnimationTimer >= this.moveAnimationLength || lastMoveState != this.currentMoveState || this.mountEntity.m_217005_() || this.mountEntity.m_5842_()) {
            this.moveAnimationTimer = 0.0;
        }
        if (this.mountEntity.m_5842_() && this.mountEntity.m_20184_().m_82553_() > 0.01) {
            event.getController().setAnimation(this.mountEntity.getSwimAnimation());
        } else if (this.mountEntity.getIsClimbing()) {
            this.animationController.transitionLengthTicks = 10.0;
            event.getController().setAnimation(this.mountEntity.getClimbAnimation());
        } else if (lastMoveState == AnimationPhase.IDLE && this.currentMoveState == AnimationPhase.SIT) {
            this.animationController.transitionLengthTicks = 0.0;
            event.getController().setAnimation(this.mountEntity.getSitDownAnimation());
        } else if (lastMoveState == AnimationPhase.SIT && this.currentMoveState == AnimationPhase.IDLE) {
            this.animationController.transitionLengthTicks = 0.0;
            event.getController().setAnimation(this.mountEntity.getStandupAnimation());
        } else if (lastMoveState == AnimationPhase.SIT && this.currentMoveState == AnimationPhase.SLEEP) {
            this.animationController.transitionLengthTicks = 0.0;
            event.getController().setAnimation(this.mountEntity.getGoToSleepAnimation());
        } else if (lastMoveState == AnimationPhase.SLEEP && this.currentMoveState == AnimationPhase.SIT) {
            this.animationController.transitionLengthTicks = 0.0;
            event.getController().setAnimation(this.mountEntity.getWakeUpAnimation());
        } else if (this.mountEntity.getIsFlying()) {
            this.animationController.transitionLengthTicks = 10.0;
            event.getController().setAnimation(this.mountEntity.getFlyAnimation());
        } else if (this.mountEntity.getIsSleeping()) {
            event.getController().setAnimation(this.mountEntity.getSleepingAnimation());
        } else if (this.mountEntity.getIsSitting()) {
            event.getController().setAnimation(this.mountEntity.getSittingAnimation());
        } else if (event.isMoving() || this.mountEntity.m_20184_().m_82553_() > 0.1) {
            this.animationController.transitionLengthTicks = 10.0;
            if (this.mountEntity.getTrackedAttacking()) {
                event.getController().setAnimation(this.mountEntity.getSprintAnimation());
            } else if (this.mountEntity.m_20142_()) {
                event.getController().setAnimation(this.mountEntity.getSprintAnimation());
            } else {
                event.getController().setAnimation(this.mountEntity.getWalkAnimation());
            }
        } else {
            this.animationController.transitionLengthTicks = 10.0;
            event.getController().setAnimation(this.mountEntity.getNeutralAnimation());
        }
        return PlayState.CONTINUE;
    }

    protected <P extends IAnimatable> PlayState blinkAnimationPredicate(AnimationEvent<P> event) {
        this.blinkAnimationController.transitionLengthTicks = 0.0;
        if (!this.mountEntity.getIsSleeping()) {
            this.blinkAnimationController.setAnimation(this.mountEntity.getBlinkAnimation());
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    protected <P extends IAnimatable> PlayState idleAnimationPredicate(AnimationEvent<P> event) {
        this.idleAnimationController.transitionLengthTicks = 5.0;
        if (!this.mountEntity.getIsFlying()) {
            boolean switchAnimation;
            boolean bl = switchAnimation = event.getController().getCurrentAnimation() == null || (double)this.animationTick >= event.getController().getCurrentAnimation().animationLength;
            if (switchAnimation) {
                this.animationTick = 0.0f;
                if (this.mountEntity.getIsSleeping()) {
                    event.getController().setAnimation(this.mountEntity.getSleepingIdleAnimation());
                } else if (this.mountEntity.getIsSitting()) {
                    event.getController().setAnimation(this.mountEntity.getSittingIdleAnimation());
                } else if (this.mountEntity.getTrackedAttacking()) {
                    event.getController().setAnimation(this.mountEntity.getAttackAnimation());
                } else {
                    event.getController().setAnimation(this.mountEntity.getIdleAnimation());
                }
            }
            this.animationTick += event.getPartialTick();
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void tick() {
    }

    private static enum AnimationPhase {
        WALK,
        IDLE,
        SIT,
        SLEEP;

    }
}

