/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountGoals;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.SwimmingMountMoveControl;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.SwimmingMountNavigation;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class SwimmingMountEntity
extends MountEntity {
    protected boolean shouldSlowOutsideWater = false;

    public SwimmingMountEntity(EntityType<? extends Horse> type, Level worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn, mountKey, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SwimmingMountMoveControl(this);
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new MountGoals.WanderInWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new MountGoals.SwimRandomlyGoal(this, 1.0));
    }

    @Override
    public void m_7023_(Vec3 movementInput) {
        boolean isBeingRidden;
        boolean bl = isBeingRidden = this.m_217005_() && this.m_30614_() && this.m_6254_();
        if (!(isBeingRidden && isBeingRidden && this.m_20069_())) {
            // empty if block
        }
        if (isBeingRidden) {
            LivingEntity passengerEntity = this.m_6688_();
            this.m_146922_(passengerEntity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passengerEntity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float passengerSidewaysSpeed = passengerEntity.f_20900_ * 0.5f;
            float passengerForwardSpeed = passengerEntity.f_20902_;
            if (passengerForwardSpeed <= 0.0f) {
                passengerForwardSpeed *= 0.25f;
                this.f_30524_ = 0;
            }
            double maxFlightSpeed = (double)this.m_6113_() * this.m_218811_(this.f_19796_) * 200.0;
            double upwardsVelocity = 0.3;
            if (this.f_30522_ > 0.0f && this.m_20096_()) {
                velocity = this.m_20184_();
                upwardsVelocity = (double)this.m_6118_() * (double)this.f_30522_ * this.m_182332_();
                if (this.m_21023_(MobEffects.f_19603_)) {
                    upwardsVelocity += (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f);
                }
                this.m_20334_(velocity.f_82479_, upwardsVelocity, velocity.f_82481_);
                this.f_19812_ = true;
                if (passengerForwardSpeed > 0.0f) {
                    float i = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float j = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * i * this.f_30522_), 0.0, (double)(0.4f * j * this.f_30522_)));
                }
                this.f_30522_ = 0.0f;
            } else if (this.f_30522_ > 0.0f && this.m_20069_()) {
                velocity = this.m_20184_();
                upwardsVelocity = (double)this.m_6118_() * (double)this.f_30522_ * this.m_182332_();
                this.m_20256_(velocity.m_82541_().m_82542_(1.0, 2.0 * upwardsVelocity, 1.0));
                this.f_19812_ = true;
                this.f_30522_ = 0.0f;
            }
            if (this.m_6109_()) {
                if (this.m_20077_()) {
                    this.m_19920_(0.02f, movementInput);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
                }
                if (this.m_20069_() && (Mth.m_14154_((float)passengerForwardSpeed) > 0.0f || Mth.m_14154_((float)passengerSidewaysSpeed) > 0.0f)) {
                    if (this.m_20069_() && this.shouldSlowOutsideWater) {
                        this.m_19920_(0.02f, movementInput);
                        this.m_6478_(MoverType.SELF, this.m_20184_().m_82541_().m_82542_(1.0, 0.5, 1.0));
                        this.m_20256_(this.m_20184_());
                    } else {
                        this.m_19920_(0.02f, movementInput);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        this.m_20256_(this.m_20184_());
                    }
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 6.0f);
                double upDown = 0.0;
                if (passengerEntity.m_146909_() < -10.0f) {
                    upDown = (double)(passengerEntity.m_146909_() / 90.0f) * -maxFlightSpeed * (double)passengerForwardSpeed;
                    if (passengerEntity.m_146909_() < -30.0f) {
                        passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                    }
                } else if (passengerEntity.m_146909_() > 20.0f) {
                    upDown = 0.05 * -maxFlightSpeed * (double)passengerForwardSpeed;
                    passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                }
                Vec3 flightVector = new Vec3((double)passengerSidewaysSpeed, upDown, (double)passengerForwardSpeed);
                super.m_7023_(flightVector);
            } else if (passengerEntity instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (!isBeingRidden && !this.m_20069_()) {
                super.m_7023_(movementInput);
            } else if (!isBeingRidden && this.m_20069_()) {
                this.turtleTravel(movementInput);
            }
        }
        this.m_21043_((LivingEntity)this, false);
    }

    protected float m_6108_() {
        return 0.8f;
    }

    public void turtleTravel(Vec3 movementInput) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.75));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(movementInput);
        }
    }

    protected PathNavigation m_6037_(Level world) {
        return new SwimmingMountNavigation(this, world);
    }
}

