/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.model;

import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.AnimatedLivingEntityModel;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class HeadRotationAdjustments {
    public static void getHeadAdjustment(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        switch (entity.mountKey) {
            default: {
                HeadRotationAdjustments.getDefaultHeadRotation(model, entity, customPredicate);
                break;
            }
            case COURIER_BIRD: {
                HeadRotationAdjustments.getCourierBirdHeadRotation(model, entity, customPredicate);
                break;
            }
            case DRAGON: {
                HeadRotationAdjustments.getDragonHeadRotation(model, entity, customPredicate);
                break;
            }
            case NIGHTMARE: {
                HeadRotationAdjustments.getNightmareHeadRotation(model, entity, customPredicate);
                break;
            }
            case RIDING_LIZARD: {
                HeadRotationAdjustments.getRidingLizardHeadRotation(model, entity, customPredicate);
            }
        }
    }

    public static void getDefaultHeadRotation(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        IBone head = model.getBone("head");
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (head != null) {
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        }
    }

    public static void getRidingLizardHeadRotation(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        IBone neck;
        IBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        float yawAngle = 0.25f * extraData.netHeadYaw * ((float)Math.PI / 180);
        float pitchAngle = 0.25f * extraData.headPitch * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = model.getBone("head")) != null) {
            head.setRotationY(3.0f * yawAngle);
            head.setRotationX(4.0f * pitchAngle);
        }
        if ((neck = model.getBone("neck")) != null) {
            neck.setRotationY(yawAngle);
            neck.setRotationX(pitchAngle);
        }
        if ((neck = model.getBone("neck2")) != null) {
            neck.setRotationX(pitchAngle);
        }
        if ((neck = model.getBone("neck3")) != null) {
            neck.setRotationX(pitchAngle);
        }
    }

    public static void getNightmareHeadRotation(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        IBone neck;
        IBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        float yawAngle = 0.25f * extraData.netHeadYaw * ((float)Math.PI / 180);
        float pitchAngle = extraData.headPitch * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = model.getBone("noggin")) != null) {
            head.setRotationY(2.0f * yawAngle);
            if (entity.m_6162_()) {
                head.setRotationX(pitchAngle * 1.25f);
            } else {
                head.setRotationX(pitchAngle);
            }
        }
        if ((neck = model.getBone("head")) != null) {
            neck.setRotationY(2.0f * yawAngle);
            neck.setRotationX(pitchAngle + 0.15f);
        }
    }

    public static void getCourierBirdHeadRotation(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        IBone neck;
        IBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        float yawAngle = 0.125f * extraData.netHeadYaw * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = model.getBone("head")) != null) {
            head.setRotationY(7.0f * yawAngle);
            head.setRotationX(7.0f * pitchAngle);
        }
        if ((neck = model.getBone("neck")) != null) {
            neck.setRotationY(yawAngle);
            neck.setRotationX(pitchAngle);
        }
        if ((neck = model.getBone("neck2")) != null) {
            neck.setRotationX(pitchAngle);
        }
        if ((neck = model.getBone("neck3")) != null) {
            neck.setRotationX(pitchAngle);
        }
    }

    public static void getDragonHeadRotation(AnimatedLivingEntityModel model, MountEntity entity, AnimationEvent customPredicate) {
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        float yawAngle = 0.25f * extraData.netHeadYaw * ((float)Math.PI / 180);
        float pitchAngle = 0.25f * extraData.headPitch * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if (!entity.m_6162_()) {
            pitchAngle = 0.0f;
        }
        if (!entity.getIsFlying()) {
            IBone neck;
            IBone head = model.getBone("head");
            if (head != null) {
                head.setRotationY(3.0f * yawAngle);
                if (entity.m_6162_()) {
                    head.setRotationX(pitchAngle + 0.15f);
                } else {
                    head.setRotationX(5.0f * pitchAngle);
                }
            }
            if ((neck = model.getBone("neck")) != null) {
                neck.setRotationY(yawAngle);
                neck.setRotationX(pitchAngle);
            }
            if ((neck = model.getBone("neck2")) != null) {
                neck.setRotationY(yawAngle);
                neck.setRotationX(pitchAngle);
            }
            if ((neck = model.getBone("neck3")) != null) {
                neck.setRotationY(0.5f * yawAngle);
                neck.setRotationX(pitchAngle);
            }
        }
    }
}

