/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;

public class UmvuthanaGrovePieces {
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.f_50198_).add((Object)Blocks.f_50081_).add((Object)Blocks.f_50082_).add((Object)Blocks.f_50132_).add((Object)Blocks.f_50479_).add((Object)Blocks.f_50483_).add((Object)Blocks.f_50482_).add((Object)Blocks.f_50480_).add((Object)Blocks.f_50481_).add((Object)Blocks.f_220852_).add((Object)Blocks.f_50155_).add((Object)Blocks.f_50310_).build();
    public static final ResourceLocation PLATFORM_1 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_platform_1");
    public static final ResourceLocation PLATFORM_2 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_platform_2");
    public static final ResourceLocation[] PLATFORMS = new ResourceLocation[]{PLATFORM_1, PLATFORM_2};
    public static final ResourceLocation PLATFORM_EXTEND = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_platform_extend");
    public static final ResourceLocation FIREPIT = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_firepit");
    public static final ResourceLocation FIREPIT_SMALL_1 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_firepit_small_1");
    public static final ResourceLocation FIREPIT_SMALL_2 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_firepit_small_2");
    public static final ResourceLocation[] FIREPIT_SMALL = new ResourceLocation[]{FIREPIT_SMALL_1, FIREPIT_SMALL_2};
    public static final ResourceLocation TREE_1 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_tree_1");
    public static final ResourceLocation TREE_2 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_tree_2");
    public static final ResourceLocation TREE_3 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_tree_3");
    public static final ResourceLocation[] TREES = new ResourceLocation[]{TREE_1, TREE_2, TREE_3};
    public static final ResourceLocation SPIKE_1 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_spike_1");
    public static final ResourceLocation SPIKE_2 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_spike_2");
    public static final ResourceLocation SPIKE_3 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_spike_3");
    public static final ResourceLocation SPIKE_4 = new ResourceLocation("mowziesmobs", "umvuthana/umvuthana_spike_4");
    public static final ResourceLocation[] SPIKES = new ResourceLocation[]{SPIKE_1, SPIKE_2, SPIKE_3, SPIKE_4};
    public static final ResourceLocation THRONE = new ResourceLocation("mowziesmobs", "umvuthana/umvuthi_throne");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.builder().put((Object)PLATFORM_1, (Object)new BlockPos(-5, 0, -5)).put((Object)PLATFORM_2, (Object)new BlockPos(0, 0, -5)).put((Object)PLATFORM_EXTEND, (Object)new BlockPos(8, 1, -2)).put((Object)FIREPIT, (Object)new BlockPos(-3, -2, -3)).put((Object)FIREPIT_SMALL_1, (Object)new BlockPos(-1, 0, -1)).put((Object)FIREPIT_SMALL_2, (Object)new BlockPos(-1, 0, -1)).put((Object)TREE_1, (Object)new BlockPos(-5, 1, -3)).put((Object)TREE_2, (Object)new BlockPos(-3, 1, -3)).put((Object)TREE_3, (Object)new BlockPos(-3, 1, -3)).put((Object)SPIKE_1, (Object)new BlockPos(-1, 1, 0)).put((Object)SPIKE_2, (Object)new BlockPos(0, 1, 0)).put((Object)SPIKE_3, (Object)new BlockPos(0, 1, 0)).put((Object)SPIKE_4, (Object)new BlockPos(0, 1, 0)).put((Object)THRONE, (Object)new BlockPos(-9, 0, 0)).build();
    private static final Map<ResourceLocation, Pair<BlockPos, BlockPos>> BOUNDS_OFFSET = ImmutableMap.builder().put((Object)PLATFORM_1, (Object)new Pair((Object)new BlockPos(1, 0, 0), (Object)new BlockPos(-3, 0, -3))).put((Object)PLATFORM_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, -3))).put((Object)PLATFORM_EXTEND, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT_SMALL_1, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)FIREPIT_SMALL_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)TREE_1, (Object)new Pair((Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-3, 0, -3))).put((Object)TREE_2, (Object)new Pair((Object)new BlockPos(2, 0, 1), (Object)new BlockPos(-1, 0, -3))).put((Object)TREE_3, (Object)new Pair((Object)new BlockPos(2, 0, 2), (Object)new BlockPos(-2, 0, -2))).put((Object)SPIKE_1, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_2, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_3, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)SPIKE_4, (Object)new Pair((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 0))).put((Object)THRONE, (Object)new Pair((Object)new BlockPos(4, 0, 1), (Object)new BlockPos(-4, 0, -3))).build();

    public static StructurePiece addPiece(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        pieces.m_142679_((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand, List<StructurePiece> ignore) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        StructurePiece collisionPiece = pieces.m_141921_(newPiece.getCollisionBoundingBox());
        if (collisionPiece != null && !ignore.contains(collisionPiece)) {
            return null;
        }
        pieces.m_142679_((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPlatform(StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder builder, WorldgenRandom rand) {
        int whichPlatform = rand.m_188503_(PLATFORMS.length);
        Piece newPiece = new Piece(manager, PLATFORMS[whichPlatform], rot, pos);
        if (UmvuthanaGrovePieces.findCollisionPiece(builder.f_192778_, newPiece.getCollisionBoundingBox()) != null) {
            return null;
        }
        builder.m_142679_((StructurePiece)newPiece);
        if (whichPlatform == 1) {
            Piece extension = new Piece(manager, PLATFORM_EXTEND, rot, pos);
            if (UmvuthanaGrovePieces.findCollisionPiece(builder.f_192778_, extension.getCollisionBoundingBox(), (StructurePiece)newPiece) != null) {
                return newPiece;
            }
            builder.m_142679_((StructurePiece)extension);
        }
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureTemplateManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder pieces, WorldgenRandom rand) {
        return UmvuthanaGrovePieces.addPieceCheckBounds(resourceLocation, manager, pos, rot, (StructurePieceAccessor)pieces, rand, Collections.emptyList());
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> pieces, BoundingBox bounds, StructurePiece ignore) {
        for (StructurePiece structurePiece : pieces) {
            if (structurePiece == ignore) continue;
            if (structurePiece instanceof Piece && ((Piece)structurePiece).getCollisionBoundingBox().m_71049_(bounds)) {
                return structurePiece;
            }
            if (!structurePiece.m_73547_().m_71049_(bounds)) continue;
            return structurePiece;
        }
        return null;
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> pieces, BoundingBox bounds) {
        return UmvuthanaGrovePieces.findCollisionPiece(pieces, bounds, null);
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;
        public BoundingBox collisionBoundingBox;

        public Piece(StructurePieceType pieceType, StructureTemplateManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            super(pieceType, 0, manager, resourceLocationIn, resourceLocationIn.toString(), Piece.makeSettings(rotation, resourceLocationIn), Piece.makePosition(resourceLocationIn, pos, rotation));
            this.resourceLocation = resourceLocationIn;
            this.collisionBoundingBox = this.makeCollisionBoundingBox();
            if (this.resourceLocation == THRONE || this.resourceLocation == FIREPIT) {
                this.f_73383_ = this.m_73547_().m_71045_(0, 1, 0);
            }
        }

        public Piece(StructurePieceType pieceType, StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(pieceType, tagCompound, context.f_226956_(), resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot")), resourceLocation));
            this.collisionBoundingBox = this.makeCollisionBoundingBox();
            if (this.resourceLocation == THRONE || this.resourceLocation == FIREPIT) {
                this.f_73383_ = this.m_73547_().m_71045_(0, 1, 0);
            }
        }

        public Piece(StructureTemplateManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            this(FeatureHandler.UMVUTHANA_GROVE_PIECE, manager, resourceLocationIn, rotation, pos);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            this(FeatureHandler.UMVUTHANA_GROVE_PIECE, context, tagCompound);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, ResourceLocation resourceLocation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        private static BlockPos makePosition(ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
            return pos.m_121955_((Vec3i)OFFSET.get(resourceLocation).m_7954_(rotation));
        }

        public BoundingBox makeCollisionBoundingBox() {
            BlockPos boundsMaxOffset;
            StructureTemplate structuretemplate = this.f_73656_;
            BlockPos boundsMinOffset = boundsMaxOffset = new BlockPos(0, 0, 0);
            Pair<BlockPos, BlockPos> boundsOffset = BOUNDS_OFFSET.get(this.resourceLocation);
            if (boundsOffset != null) {
                boundsMinOffset = (BlockPos)boundsOffset.getFirst();
                boundsMaxOffset = (BlockPos)boundsOffset.getSecond();
            }
            Vec3i sizeVec = structuretemplate.m_163801_().m_7918_(-1, -1, -1);
            BlockPos blockpos = StructureTemplate.m_74593_((BlockPos)BlockPos.f_121853_.m_121955_((Vec3i)boundsMinOffset), (Mirror)this.f_73657_.m_74401_(), (Rotation)this.f_73657_.m_74404_(), (BlockPos)this.f_73657_.m_74407_());
            BlockPos blockpos1 = StructureTemplate.m_74593_((BlockPos)BlockPos.f_121853_.m_121955_(sizeVec).m_121955_((Vec3i)boundsMaxOffset), (Mirror)this.f_73657_.m_74401_(), (Rotation)this.f_73657_.m_74404_(), (BlockPos)this.f_73657_.m_74407_());
            return BoundingBox.m_162375_((Vec3i)blockpos, (Vec3i)blockpos1).m_162373_((Vec3i)this.f_73658_);
        }

        public BoundingBox getCollisionBoundingBox() {
            return this.collisionBoundingBox;
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        public void m_213694_(WorldGenLevel p_192682_, StructureManager p_192683_, ChunkGenerator p_192684_, RandomSource p_192685_, BoundingBox p_192686_, ChunkPos p_192687_, BlockPos p_192688_) {
            super.m_213694_(p_192682_, p_192683_, p_192684_, p_192685_, p_192686_, p_192687_, p_192688_);
        }

        protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
            Rotation rotation = this.f_73657_.m_74404_();
            if (function.equals("support")) {
                worldIn.m_7731_(pos, Blocks.f_50132_.m_49966_(), 3);
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.f_50132_.m_49966_(), pos.m_7495_());
            } else if (function.equals("trunk")) {
                this.fillAirLiquidDownTrunk((LevelAccessor)worldIn, pos, rand);
            } else if (function.equals("leg")) {
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.f_220835_.m_49966_(), pos);
            } else if (function.equals("base")) {
                this.fillAirLiquidDownBase((LevelAccessor)worldIn, pos, rand);
            } else if (function.equals("umvuthi")) {
                this.setBlockState((LevelAccessor)worldIn, pos, Blocks.f_50016_.m_49966_());
                EntityUmvuthi barako = new EntityUmvuthi((EntityType<? extends EntityUmvuthi>)((EntityType)EntityHandler.UMVUTHI.get()), (Level)worldIn.m_6018_());
                barako.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                int i = rotation.m_55949_(3, 4);
                barako.setDirection(i);
                barako.m_6518_(worldIn, worldIn.m_6436_(barako.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                BlockPos offset = new BlockPos(0, 0, -18);
                offset = offset.m_7954_(rotation);
                BlockPos firePitPos = pos.m_121955_((Vec3i)offset);
                firePitPos = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, firePitPos);
                barako.m_21446_(firePitPos, -1);
                worldIn.m_7967_((Entity)barako);
            } else if ("chest".equals(function)) {
                Direction facing = Direction.NORTH;
                facing = rotation.m_55954_(facing);
                this.m_226762_(worldIn, sbb, rand, pos, LootTableHandler.UMVUTHANA_GROVE_CHEST, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
            } else if ("skull".equals(function)) {
                BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                this.setBlockState((LevelAccessor)worldIn, groundPos.m_7494_(), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rand.m_188503_(16))));
            } else if ("campfire".equals(function)) {
                BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                this.setBlockState((LevelAccessor)worldIn, groundPos.m_7494_(), Blocks.f_50683_.m_49966_());
            } else if (function.length() > 5 && "spike".equals(function.substring(0, 5))) {
                String[] split = function.split("_");
                int logCount = 2;
                int fenceCount = 1;
                int barCount = 1;
                int skullCount = 0;
                if (split.length > 1) {
                    logCount = Integer.parseInt(split[1]);
                }
                if (split.length > 2) {
                    fenceCount = Integer.parseInt(split[2]);
                }
                if (split.length > 3) {
                    barCount = Integer.parseInt(split[3]);
                }
                if (split.length > 4) {
                    skullCount = Integer.parseInt(split[4]);
                }
                this.genSpike((LevelAccessor)worldIn, pos, rand, logCount, fenceCount, barCount, skullCount);
            } else if (function.length() > 6 && "stairs".equals(function.substring(0, 6))) {
                String[] split = function.split("_");
                Direction stairDirection = Direction.EAST;
                Direction newDirection = null;
                if (split.length > 1) {
                    newDirection = Direction.m_122402_((String)split[1]);
                }
                if (newDirection != null) {
                    stairDirection = newDirection;
                }
                stairDirection = rotation.m_55954_(stairDirection);
                this.genStairs((LevelAccessor)worldIn, pos, rand, stairDirection);
            } else if ("chest_under".equals(function)) {
                if ((double)rand.m_188501_() < 0.5) {
                    worldIn.m_7471_(pos, false);
                } else {
                    BlockPos groundPos = this.getGroundPos((LevelAccessor)worldIn, pos);
                    Direction facing = (double)rand.m_188501_() < 0.5 ? Direction.NORTH : Direction.EAST;
                    facing = rotation.m_55954_(facing);
                    this.m_226762_(worldIn, sbb, rand, groundPos.m_7494_(), LootTableHandler.UMVUTHANA_GROVE_CHEST, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
                }
            } else if (function.length() > 4 && "mask".equals(function.substring(0, 4))) {
                worldIn.m_7471_(pos, false);
                String[] split = function.split("_");
                Direction direction = Direction.NORTH;
                if (split.length > 1) {
                    direction = Direction.m_122402_((String)split[1]);
                }
                ItemFrame itemFrame = new ItemFrame((Level)worldIn.m_6018_(), pos, rotation.m_55954_(direction));
                int i = rand.m_188503_(MaskType.values().length);
                MaskType type = MaskType.values()[i];
                ItemUmvuthanaMask mask = ItemHandler.UMVUTHANA_MASK_FURY;
                switch (type) {
                    case BLISS: {
                        mask = ItemHandler.UMVUTHANA_MASK_BLISS;
                        break;
                    }
                    case FEAR: {
                        mask = ItemHandler.UMVUTHANA_MASK_FEAR;
                        break;
                    }
                    case FURY: {
                        mask = ItemHandler.UMVUTHANA_MASK_FURY;
                        break;
                    }
                    case MISERY: {
                        mask = ItemHandler.UMVUTHANA_MASK_MISERY;
                        break;
                    }
                    case RAGE: {
                        mask = ItemHandler.UMVUTHANA_MASK_RAGE;
                        break;
                    }
                    case FAITH: {
                        mask = ItemHandler.UMVUTHANA_MASK_FAITH;
                    }
                }
                ItemStack stack = new ItemStack((ItemLike)mask);
                itemFrame.m_31789_(stack, false);
                worldIn.m_7967_((Entity)itemFrame);
            } else {
                worldIn.m_7471_(pos, false);
            }
        }

        protected void setBlockState(LevelAccessor worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.m_6425_(pos);
            if (!ifluidstate.m_76178_()) {
                worldIn.m_183324_().m_183588_(pos, (Object)ifluidstate.m_76152_());
                if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.m_7731_(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.m_60734_())) {
                worldIn.m_46865_(pos).m_8113_(pos);
            }
        }

        public BlockPos getGroundPos(LevelAccessor worldIn, BlockPos startPos) {
            while (!Block.m_49936_((BlockGetter)worldIn, (BlockPos)startPos) && startPos.m_123342_() > worldIn.m_141937_()) {
                startPos = startPos.m_7495_();
            }
            return startPos;
        }

        public void fillAirLiquidDown(LevelAccessor worldIn, BlockState state, BlockPos startPos) {
            int i = startPos.m_123341_();
            int k = startPos.m_123343_();
            for (int j = startPos.m_123342_(); !Block.m_49936_((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, state);
            }
        }

        public void fillAirLiquidDownTrunk(LevelAccessor worldIn, BlockPos startPos, RandomSource rand) {
            int i = startPos.m_123341_();
            int k = startPos.m_123343_();
            for (int j = startPos.m_123342_(); !Block.m_49936_((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, (double)rand.m_188501_() < 0.2 ? ((Block)BlockHandler.CLAWED_LOG.get()).m_49966_() : Blocks.f_50047_.m_49966_());
            }
        }

        public void fillAirLiquidDownBase(LevelAccessor worldIn, BlockPos startPos, RandomSource rand) {
            int i = startPos.m_123341_();
            int k = startPos.m_123343_();
            for (int j = startPos.m_123342_(); !Block.m_49936_((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, (double)rand.m_188501_() < 0.5 ? Blocks.f_220835_.m_49966_() : Blocks.f_50301_.m_49966_());
            }
        }

        public void genStairs(LevelAccessor worldIn, BlockPos pos, RandomSource rand, Direction direction) {
            for (int i = 1; i < 5; ++i) {
                if (!Block.m_49936_((BlockGetter)worldIn, (BlockPos)pos)) {
                    BlockState state;
                    BlockState blockState = state = (double)rand.m_188501_() > 0.5 ? Blocks.f_50402_.m_49966_() : Blocks.f_50644_.m_49966_();
                    if (i % 2 == 1) {
                        state = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
                    }
                    this.setBlockState(worldIn, pos, state);
                    pos = pos.m_121945_(direction);
                    if (i % 2 != 0) continue;
                    pos = pos.m_121945_(Direction.DOWN);
                    continue;
                }
                return;
            }
            pos = pos.m_121945_(direction.m_122424_());
            this.fillAirLiquidDown(worldIn, Blocks.f_220835_.m_49966_(), pos);
            this.fillAirLiquidDown(worldIn, (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)direction), pos.m_121945_(direction));
        }

        public void genSpike(LevelAccessor worldIn, BlockPos startPos, RandomSource rand, int numLogs, int numFence, int numBars, int numSkulls) {
            int i;
            int groundPos = worldIn.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, startPos.m_123341_(), startPos.m_123343_());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.m_123341_(), groundPos - 1, startPos.m_123343_());
            for (i = 0; i < numLogs; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.f_220835_.m_49966_());
                pos.m_122173_(Direction.UP);
            }
            for (i = 0; i < numFence; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.f_220852_.m_49966_());
                pos.m_122173_(Direction.UP);
            }
            for (i = 0; i < numBars; ++i) {
                this.setBlockState(worldIn, (BlockPos)pos, Blocks.f_50183_.m_49966_());
                pos.m_122173_(Direction.UP);
            }
            if ((double)rand.m_188501_() < 0.1 && numSkulls > 0) {
                this.setBlockState(worldIn, (BlockPos)pos, (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rand.m_188503_(16))));
            }
        }
    }

    public static class FirepitPiece
    extends Piece {
        public FirepitPiece(StructureTemplateManager manager, Rotation rotation, BlockPos pos) {
            super(FeatureHandler.UMVUTHANA_FIREPIT, manager, FIREPIT, rotation, pos);
        }

        public FirepitPiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(FeatureHandler.UMVUTHANA_FIREPIT, context, tagCompound);
        }

        public BlockPos findGround(LevelAccessor worldIn, int x, int z) {
            int i = this.m_73392_(x, z);
            int k = this.m_73525_(x, z);
            int j = worldIn.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, i, k);
            return new BlockPos(i, j, k);
        }

        @Override
        public void m_213694_(WorldGenLevel worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomIn, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            super.m_213694_(worldIn, structureManager, chunkGenerator, randomIn, p_230383_5_, p_230383_6_, p_230383_7_);
            BlockPos centerPos = this.findGround((LevelAccessor)worldIn, 4, 4);
            int numUmvuthana = randomIn.m_188503_(5) + 5;
            block0: for (int i = 1; i <= numUmvuthana; ++i) {
                EntityUmvuthanaMinion umvuthana = new EntityUmvuthanaMinion((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_MINION.get()), (Level)worldIn.m_6018_());
                for (int j = 1; j <= 20; ++j) {
                    int distance = randomIn.m_188503_(10) + 2;
                    int angle = randomIn.m_188503_(360);
                    int x = (int)((double)distance * Math.sin(Math.toRadians(angle))) + 4;
                    int z = (int)((double)distance * Math.cos(Math.toRadians(angle))) + 4;
                    BlockPos bPos = this.findGround((LevelAccessor)worldIn, x, z);
                    umvuthana.m_6034_(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_());
                    if (bPos.m_123342_() <= 0 || !umvuthana.m_5545_((LevelAccessor)worldIn, MobSpawnType.STRUCTURE) || !worldIn.m_45772_(umvuthana.m_20191_())) continue;
                    umvuthana.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(umvuthana.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    umvuthana.m_21446_(centerPos, 25);
                    worldIn.m_7967_((Entity)umvuthana);
                    continue block0;
                }
            }
        }
    }
}

