/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.gui;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomBossBar {
    public static Map<ResourceLocation, CustomBossBar> customBossBars = new HashMap<ResourceLocation, CustomBossBar>();
    private final ResourceLocation baseTexture;
    private final ResourceLocation overlayTexture;
    private final boolean hasOverlay;
    private final int baseHeight;
    private final int baseTextureHeight;
    private final int baseOffsetY;
    private final int overlayOffsetX;
    private final int overlayOffsetY;
    private final int overlayWidth;
    private final int overlayHeight;
    private final int verticalIncrement;
    private final ChatFormatting textColor;

    public CustomBossBar(ResourceLocation baseTexture, ResourceLocation overlayTexture, int baseHeight, int baseTextureHeight, int baseOffsetY, int overlayOffsetX, int overlayOffsetY, int overlayWidth, int overlayHeight, int verticalIncrement, ChatFormatting textColor) {
        this.baseTexture = baseTexture;
        this.overlayTexture = overlayTexture;
        this.hasOverlay = overlayTexture != null;
        this.baseHeight = baseHeight;
        this.baseTextureHeight = baseTextureHeight;
        this.baseOffsetY = baseOffsetY;
        this.overlayOffsetX = overlayOffsetX;
        this.overlayOffsetY = overlayOffsetY;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.verticalIncrement = verticalIncrement;
        this.textColor = textColor;
    }

    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public int getBaseTextureHeight() {
        return this.baseTextureHeight;
    }

    public int getBaseOffsetY() {
        return this.baseOffsetY;
    }

    public int getOverlayOffsetX() {
        return this.overlayOffsetX;
    }

    public int getOverlayOffsetY() {
        return this.overlayOffsetY;
    }

    public int getOverlayWidth() {
        return this.overlayWidth;
    }

    public int getOverlayHeight() {
        return this.overlayHeight;
    }

    public int getVerticalIncrement() {
        return this.verticalIncrement;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        PoseStack stack = event.getPoseStack();
        int y = event.getY();
        int i = Minecraft.m_91087_().m_91268_().m_85445_();
        int j = y - 9;
        int k = i / 2 - 91;
        Minecraft.m_91087_().m_91307_().m_6180_("customBossBarBase");
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBaseTexture());
        this.drawBar(stack, event.getX() + 1, y + this.getBaseOffsetY(), (BossEvent)event.getBossEvent());
        MutableComponent component = event.getBossEvent().m_18861_().m_6881_().m_130940_(this.getTextColor());
        Minecraft.m_91087_().m_91307_().m_7238_();
        int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        int i1 = i / 2 - l / 2;
        int j1 = j;
        Minecraft.m_91087_().f_91062_.m_92763_(stack, (Component)component, (float)i1, (float)j1, 0xFFFFFF);
        if (this.hasOverlay()) {
            Minecraft.m_91087_().m_91307_().m_6180_("customBossBarOverlay");
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getOverlayTexture());
            Gui.m_93133_((PoseStack)stack, (int)(event.getX() + 1 + this.getOverlayOffsetX()), (int)(y + this.getOverlayOffsetY() + this.getBaseOffsetY()), (float)0.0f, (float)0.0f, (int)this.getOverlayWidth(), (int)this.getOverlayHeight(), (int)this.getOverlayWidth(), (int)this.getOverlayHeight());
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        event.setIncrement(this.getVerticalIncrement());
    }

    private void drawBar(PoseStack stack, int x, int y, BossEvent event) {
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)182, (int)this.getBaseHeight(), (int)256, (int)this.getBaseTextureHeight());
        int i = (int)(event.m_142717_() * 183.0f);
        if (i > 0) {
            GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)this.getBaseHeight(), (int)i, (int)this.getBaseHeight(), (int)256, (int)this.getBaseTextureHeight());
        }
    }

    static {
        customBossBars.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)EntityHandler.UMVUTHI.get())), new CustomBossBar(new ResourceLocation("mowziesmobs", "textures/gui/boss_bar/umvuthi_bar_base.png"), new ResourceLocation("mowziesmobs", "textures/gui/boss_bar/umvuthi_bar_overlay.png"), 4, 8, 2, -12, -6, 256, 16, 21, ChatFormatting.GOLD));
        customBossBars.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)EntityHandler.FROSTMAW.get())), new CustomBossBar(new ResourceLocation("mowziesmobs", "textures/gui/boss_bar/frostmaw_bar_base.png"), new ResourceLocation("mowziesmobs", "textures/gui/boss_bar/frostmaw_bar_overlay.png"), 10, 32, 2, -4, -3, 256, 32, 25, ChatFormatting.WHITE));
    }
}

