/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class MMModels {
    public static final String[] HAND_MODEL_ITEMS = new String[]{"wrought_axe", "spear", "earthbore_gauntlet", "sculptor_staff"};

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        Map map = event.getModels();
        for (String string : HAND_MODEL_ITEMS) {
            ModelResourceLocation modelInventory = new ModelResourceLocation("mowziesmobs:" + string, "inventory");
            ModelResourceLocation modelHand = new ModelResourceLocation("mowziesmobs:" + string + "_in_hand", "inventory");
            final BakedModel bakedModelDefault = (BakedModel)map.get(modelInventory);
            final BakedModel bakedModelHand = (BakedModel)map.get(modelHand);
            BakedModel modelWrapper = new BakedModel(){

                public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
                    return bakedModelDefault.m_213637_(state, side, rand);
                }

                public boolean m_7541_() {
                    return bakedModelDefault.m_7541_();
                }

                public boolean m_7539_() {
                    return bakedModelDefault.m_7539_();
                }

                public boolean m_7547_() {
                    return false;
                }

                public boolean m_7521_() {
                    return bakedModelDefault.m_7521_();
                }

                public TextureAtlasSprite m_6160_() {
                    return bakedModelDefault.m_6160_();
                }

                public ItemOverrides m_7343_() {
                    return bakedModelDefault.m_7343_();
                }

                public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack mat, boolean applyLeftHandTransform) {
                    BakedModel modelToUse = bakedModelDefault;
                    if (cameraTransformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                        modelToUse = bakedModelHand;
                    }
                    return ForgeHooksClient.handleCameraTransforms((PoseStack)mat, (BakedModel)modelToUse, (ItemTransforms.TransformType)cameraTransformType, (boolean)applyLeftHandTransform);
                }
            };
            map.put(modelInventory, modelWrapper);
        }
        for (MaskType maskType : MaskType.values()) {
            ModelResourceLocation maskModelInventory = new ModelResourceLocation("mowziesmobs:umvuthana_mask_" + maskType.name, "inventory");
            ModelResourceLocation maskModelFrame = new ModelResourceLocation("mowziesmobs:umvuthana_mask_" + maskType.name + "_frame", "inventory");
            MMModels.bakeMask(map, maskModelInventory, maskModelFrame);
        }
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("mowziesmobs:sol_visage", "inventory");
        ModelResourceLocation maskModelFrame = new ModelResourceLocation("mowziesmobs:sol_visage_frame", "inventory");
        MMModels.bakeMask(map, modelResourceLocation, maskModelFrame);
    }

    private static void bakeMask(Map<ResourceLocation, BakedModel> map, ModelResourceLocation maskModelInventory, ModelResourceLocation maskModelFrame) {
        final BakedModel maskBakedModelDefault = map.get(maskModelInventory);
        final BakedModel maskBakedModelFrame = map.get(maskModelFrame);
        BakedModel maskModelWrapper = new BakedModel(){

            public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
                return maskBakedModelDefault.m_213637_(state, side, rand);
            }

            public boolean m_7541_() {
                return maskBakedModelDefault.m_7541_();
            }

            public boolean m_7539_() {
                return maskBakedModelDefault.m_7539_();
            }

            public boolean m_7547_() {
                return false;
            }

            public boolean m_7521_() {
                return maskBakedModelDefault.m_7521_();
            }

            public TextureAtlasSprite m_6160_() {
                return maskBakedModelDefault.m_6160_();
            }

            public ItemOverrides m_7343_() {
                return maskBakedModelDefault.m_7343_();
            }

            public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack mat, boolean applyLeftHandTransform) {
                BakedModel modelToUse = maskBakedModelDefault;
                if (cameraTransformType == ItemTransforms.TransformType.FIXED) {
                    modelToUse = maskBakedModelFrame;
                }
                return ForgeHooksClient.handleCameraTransforms((PoseStack)mat, (BakedModel)modelToUse, (ItemTransforms.TransformType)cameraTransformType, (boolean)applyLeftHandTransform);
            }
        };
        map.put((ResourceLocation)maskModelInventory, maskModelWrapper);
    }
}

