/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate.providers.loot;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.sammy.minersdelight.repack.registrate.AbstractRegistrate;
import com.sammy.minersdelight.repack.registrate.providers.ProviderType;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateProvider;
import com.sammy.minersdelight.repack.registrate.providers.loot.RegistrateBlockLootTables;
import com.sammy.minersdelight.repack.registrate.providers.loot.RegistrateEntityLootTables;
import com.sammy.minersdelight.repack.registrate.providers.loot.RegistrateLootTables;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullBiFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class RegistrateLootTableProvider
extends LootTableProvider
implements RegistrateProvider {
    private static final Map<String, LootType<?>> LOOT_TYPES = new HashMap();
    private final AbstractRegistrate<?> parent;
    private final Multimap<LootType<?>, Consumer<? super RegistrateLootTables>> specialLootActions = HashMultimap.create();
    private final Multimap<LootContextParamSet, Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> lootActions = HashMultimap.create();
    private final Set<RegistrateLootTables> currentLootCreators = new HashSet<RegistrateLootTables>();
    private static final BiMap<ResourceLocation, LootContextParamSet> SET_REGISTRY = (BiMap)ObfuscationReflectionHelper.getPrivateValue(LootContextParamSets.class, null, (String)"REGISTRY");

    public RegistrateLootTableProvider(AbstractRegistrate<?> parent, DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.parent = parent;
    }

    public String m_6055_() {
        return "Loot tables";
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
        this.currentLootCreators.forEach(c -> c.validate(map, validationresults));
    }

    public <T extends RegistrateLootTables> void addLootAction(LootType<T> type, NonNullConsumer<T> action) {
        this.specialLootActions.put(type, action);
    }

    public void addLootAction(LootContextParamSet set, Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> action) {
        this.lootActions.put((Object)set, action);
    }

    private Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> getLootCreator(AbstractRegistrate<?> parent, LootType<?> type) {
        return () -> {
            RegistrateLootTables creator = type.getLootCreator(parent, (T cons) -> this.specialLootActions.get((Object)type).forEach(c -> c.accept(cons)));
            this.currentLootCreators.add(creator);
            return creator;
        };
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        this.parent.genData(ProviderType.LOOT, this);
        this.currentLootCreators.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LootType<?> type : LOOT_TYPES.values()) {
            builder.add((Object)Pair.of(this.getLootCreator(this.parent, type), (Object)type.getLootSet()));
        }
        for (LootContextParamSet set : SET_REGISTRY.values()) {
            builder.add((Object)Pair.of(() -> callback -> this.lootActions.get((Object)set).forEach(a -> a.accept(callback)), (Object)set));
        }
        return builder.build();
    }

    public static interface LootType<T extends RegistrateLootTables> {
        public static final LootType<RegistrateBlockLootTables> BLOCK = LootType.register("block", LootContextParamSets.f_81421_, RegistrateBlockLootTables::new);
        public static final LootType<RegistrateEntityLootTables> ENTITY = LootType.register("entity", LootContextParamSets.f_81415_, RegistrateEntityLootTables::new);

        public T getLootCreator(AbstractRegistrate<?> var1, Consumer<T> var2);

        public LootContextParamSet getLootSet();

        public static <T extends RegistrateLootTables> LootType<T> register(String name, final LootContextParamSet set, final NonNullBiFunction<AbstractRegistrate, Consumer<T>, T> factory) {
            LootType type = new LootType<T>(){

                @Override
                public T getLootCreator(AbstractRegistrate<?> parent, Consumer<T> callback) {
                    return (RegistrateLootTables)factory.apply(parent, callback);
                }

                @Override
                public LootContextParamSet getLootSet() {
                    return set;
                }
            };
            LOOT_TYPES.put(name, type);
            return type;
        }
    }
}

