/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate.builders;

import com.sammy.minersdelight.repack.registrate.AbstractRegistrate;
import com.sammy.minersdelight.repack.registrate.builders.AbstractBuilder;
import com.sammy.minersdelight.repack.registrate.builders.BuilderCallback;
import com.sammy.minersdelight.repack.registrate.providers.DataGenContext;
import com.sammy.minersdelight.repack.registrate.providers.ProviderType;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateItemModelProvider;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateRecipeProvider;
import com.sammy.minersdelight.repack.registrate.util.OneTimeEventReceiver;
import com.sammy.minersdelight.repack.registrate.util.entry.ItemEntry;
import com.sammy.minersdelight.repack.registrate.util.entry.RegistryEntry;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullBiConsumer;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemBuilder<T extends Item, P>
extends AbstractBuilder<Item, T, P, ItemBuilder<T, P>> {
    private final NonNullFunction<Item.Properties, T> factory;
    private NonNullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    @Nullable
    private NonNullSupplier<Supplier<ItemColor>> colorHandler;

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory, @Nullable NonNullSupplier<? extends CreativeModeTab> tab) {
        return new ItemBuilder<T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> tab == null ? ib : ib.tab(tab));
    }

    protected ItemBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ITEMS);
        this.factory = factory;
    }

    public ItemBuilder<T, P> properties(NonNullUnaryOperator<Item.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<T, P> initialProperties(NonNullSupplier<Item.Properties> properties) {
        this.initialProperties = properties;
        return this;
    }

    public ItemBuilder<T, P> tab(NonNullSupplier<? extends CreativeModeTab> tab) {
        return this.properties(p -> p.m_41491_((CreativeModeTab)tab.get()));
    }

    public ItemBuilder<T, P> color(NonNullSupplier<Supplier<ItemColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerItemColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerItemColor() {
        OneTimeEventReceiver.addModListener(RegisterColorHandlersEvent.Item.class, e -> {
            NonNullSupplier<Supplier<ItemColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.register(colorHandler.get().get(), new ItemLike[]{(ItemLike)this.getEntry()});
            }
        });
    }

    public ItemBuilder<T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<T, P> model(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<T, P> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<T, P> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final ItemBuilder<T, P> tag(TagKey<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        Item.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Item)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }
}

