/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.AddReloadListenerEvent;

public class CupConversionReloadListener
extends SimpleJsonResourceReloadListener {
    public static final HashMap<Item, Item> BOWL_TO_CUP = new HashMap();
    private static final Gson GSON = new GsonBuilder().create();

    public CupConversionReloadListener() {
        super(GSON, "cup_conversion");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CupConversionReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        BOWL_TO_CUP.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            JsonArray entries = object.getAsJsonArray("entries");
            for (JsonElement entry : entries) {
                JsonObject entryObject = entry.getAsJsonObject();
                Item bowlFood = CupConversionReloadListener.itemFromJson(entryObject.get("bowl"));
                Item cupFood = CupConversionReloadListener.itemFromJson(entryObject.get("cup"));
                BOWL_TO_CUP.put(bowlFood, cupFood);
            }
        }
    }

    public static Item itemFromJson(JsonElement pItemObject) {
        String s = pItemObject.getAsJsonPrimitive().getAsString();
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }
}

