/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.proxy;

import dev.micle.totemofreviving.data.DataGenerators;
import dev.micle.totemofreviving.network.NetworkManager;
import dev.micle.totemofreviving.proxy.IProxy;
import dev.micle.totemofreviving.setup.Config;
import dev.micle.totemofreviving.setup.Registration;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Proxy
implements IProxy {
    private static MinecraftServer server = null;

    public Proxy() {
        Registration.register();
        Config.init();
        NetworkManager.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(DataGenerators::gatherData);
        modEventBus.addListener(Proxy::setup);
        modEventBus.addListener(Proxy::imcEnqueue);
        modEventBus.addListener(Proxy::imcProcess);
        MinecraftForge.EVENT_BUS.addListener(Proxy::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(Proxy::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(Proxy::serverStopping);
    }

    private static void setup(FMLCommonSetupEvent event) {
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
    }

    private static void serverStarted(ServerStartedEvent event) {
        server = event.getServer();
    }

    private static void serverStopping(ServerStoppingEvent event) {
        server = null;
    }

    @Override
    public MinecraftServer getServer() {
        return server;
    }

    @Override
    public Player getClientPlayer() {
        return null;
    }

    @Override
    public Level getClientWorld() {
        return null;
    }

    public static class Server
    extends Proxy {
        public Server() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Server::setup);
        }

        private static void setup(FMLDedicatedServerSetupEvent event) {
        }
    }

    public static class Client
    extends Proxy {
        public Client() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Client::setup);
            modEventBus.addListener(Client::postSetup);
        }

        private static void setup(FMLClientSetupEvent event) {
        }

        private static void postSetup(FMLLoadCompleteEvent event) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Player getClientPlayer() {
            return Minecraft.m_91087_().f_91074_;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Level getClientWorld() {
            return Minecraft.m_91087_().f_91073_;
        }
    }
}

