/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.network.client;

import dev.micle.totemofreviving.item.totem.TotemItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ChargeTotemPacket {
    private final InteractionHand hand;

    public ChargeTotemPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void encode(ChargeTotemPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.hand);
    }

    public static ChargeTotemPacket decode(FriendlyByteBuf buffer) {
        return new ChargeTotemPacket((InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    public static void handle(ChargeTotemPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemStack chargeStack;
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ItemStack totemStack = packet.hand.equals((Object)InteractionHand.MAIN_HAND) ? sender.m_21205_() : sender.m_21206_();
            ItemStack itemStack = chargeStack = packet.hand.equals((Object)InteractionHand.MAIN_HAND) ? sender.m_21206_() : sender.m_21205_();
            if (TotemItem.isTotemFull(totemStack)) {
                return;
            }
            TotemItem.setCharge(totemStack, TotemItem.getCharge(totemStack) + 1);
            chargeStack.m_41764_(chargeStack.m_41613_() - 1);
        });
        context.setPacketHandled(true);
    }
}

