/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.network.client;

import dev.micle.totemofreviving.TotemOfReviving;
import dev.micle.totemofreviving.item.totem.TotemItem;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ChangeTargetPacket {
    private final InteractionHand hand;

    public ChangeTargetPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void encode(ChangeTargetPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.hand);
    }

    public static ChangeTargetPacket decode(FriendlyByteBuf buffer) {
        return new ChangeTargetPacket((InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    public static void handle(ChangeTargetPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ItemStack totemStack = sender.m_21120_(packet.hand);
            PlayerList playerList = TotemOfReviving.getProxy().getServer().m_6846_();
            int targetIndex = TotemItem.getTargetIndex(totemStack) + 1;
            if (targetIndex > playerList.m_11309_() - 1) {
                targetIndex = 0;
            }
            ServerPlayer target = (ServerPlayer)playerList.m_11314_().get(targetIndex);
            TotemItem.setTargetIndex(totemStack, targetIndex);
            TotemItem.setTargetUUID(totemStack, target.m_20148_());
            TotemItem.setTargetName(totemStack, target.m_5446_().getString());
            TotemItem.setTargetDeaths(totemStack, target);
            sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Now targetting " + ChatFormatting.GRAY + target.m_5446_().getString() + ".")));
        });
        context.setPacketHandled(true);
    }
}

