/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityHydraBreath;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityHydra
extends Monster
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes {
    public static final int HEADS = 9;
    public static final double HEAD_HEALTH_THRESHOLD = 20.0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityHydra.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEAD_COUNT = SynchedEntityData.m_135353_(EntityHydra.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEVERED_HEAD = SynchedEntityData.m_135353_(EntityHydra.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    public boolean[] isStriking = new boolean[9];
    public float[] strikingProgress = new float[9];
    public float[] prevStrikeProgress = new float[9];
    public boolean[] isBreathing = new boolean[9];
    public float[] speakingProgress = new float[9];
    public float[] prevSpeakingProgress = new float[9];
    public float[] breathProgress = new float[9];
    public float[] prevBreathProgress = new float[9];
    public int[] breathTicks = new int[9];
    public float[] headDamageTracker = new float[9];
    private int animationTick;
    private Animation currentAnimation;
    private EntityHydraHead[] headBoxes = new EntityHydraHead[81];
    private int strikeCooldown = 0;
    private int breathCooldown = 0;
    private int lastHitHead = 0;
    private int prevHeadCount = -1;
    private int regrowHeadCooldown = 0;
    private boolean onlyRegrowOneHeadNotTwo = false;
    private float headDamageThreshold = 20.0f;

    public EntityHydra(EntityType<EntityHydra> type, Level worldIn) {
        super(type, worldIn);
        this.resetParts();
        this.headDamageThreshold = Math.max(5.0f, (float)IafConfig.hydraMaxHealth * 0.08f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, IafConfig.hydraMaxHealth).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(IafConfig.hydraMaxHealth);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity) && !(entity instanceof EntityMutlipartPart) && !(entity instanceof Enemy) || entity instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)entity).canBeTurnedToStone();
            }
        }));
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        return false;
    }

    public void m_8107_() {
        int index;
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (attackTarget != null && this.m_142582_((Entity)attackTarget) && !this.isBreathing[index = this.f_19796_.m_188503_(this.getHeadCount())] && !this.isStriking[index]) {
            if (this.m_20270_((Entity)attackTarget) < 6.0f) {
                if (this.strikeCooldown == 0 && this.strikingProgress[index] == 0.0f) {
                    this.isBreathing[index] = false;
                    this.isStriking[index] = true;
                    this.f_19853_.m_7605_((Entity)this, (byte)(40 + index));
                    this.strikeCooldown = 3;
                }
            } else if (this.f_19796_.m_188499_() && this.breathCooldown == 0) {
                this.isBreathing[index] = true;
                this.isStriking[index] = false;
                this.f_19853_.m_7605_((Entity)this, (byte)(50 + index));
                this.breathCooldown = 15;
            }
        }
        for (int i = 0; i < 9; ++i) {
            boolean striking = this.isStriking[i];
            boolean breathing = this.isBreathing[i];
            this.prevStrikeProgress[i] = this.strikingProgress[i];
            if (striking && this.strikingProgress[i] > 9.0f) {
                this.isStriking[i] = false;
                if (attackTarget != null && this.m_20270_((Entity)attackTarget) < 6.0f) {
                    attackTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                    attackTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 3, false, false));
                    attackTarget.m_147240_(0.25, this.m_20185_() - attackTarget.m_20185_(), this.m_20189_() - attackTarget.m_20189_());
                }
            }
            if (breathing) {
                if (this.f_19797_ % 7 == 0 && attackTarget != null && i < this.getHeadCount()) {
                    Vec3 Vector3d = this.m_20252_(1.0f);
                    if (this.f_19796_.m_188501_() < 0.2f) {
                        this.m_5496_(IafSoundRegistry.HYDRA_SPIT, this.m_6121_(), this.m_6100_());
                    }
                    double headPosX = this.headBoxes[i].m_20185_() + Vector3d.f_82479_;
                    double headPosY = this.headBoxes[i].m_20186_() + (double)1.3f;
                    double headPosZ = this.headBoxes[i].m_20189_() + Vector3d.f_82481_;
                    double d2 = attackTarget.m_20185_() - headPosX + this.f_19796_.m_188583_() * 0.4;
                    double d3 = attackTarget.m_20186_() + (double)attackTarget.m_20192_() - headPosY + this.f_19796_.m_188583_() * 0.4;
                    double d4 = attackTarget.m_20189_() - headPosZ + this.f_19796_.m_188583_() * 0.4;
                    EntityHydraBreath entitylargefireball = new EntityHydraBreath((EntityType<? extends Fireball>)((EntityType)IafEntityRegistry.HYDRA_BREATH.get()), this.f_19853_, this, d2, d3, d4);
                    entitylargefireball.m_6034_(headPosX, headPosY, headPosZ);
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_7967_((Entity)entitylargefireball);
                    }
                }
                if (!(!this.isBreathing[i] || attackTarget != null && attackTarget.m_6084_() && this.breathTicks[i] <= 60 || this.f_19853_.f_46443_)) {
                    this.isBreathing[i] = false;
                    this.breathTicks[i] = 0;
                    this.breathCooldown = 15;
                    this.f_19853_.m_7605_((Entity)this, (byte)(60 + i));
                }
                int n = i;
                this.breathTicks[n] = this.breathTicks[n] + 1;
            } else {
                this.breathTicks[i] = 0;
            }
            if (striking && this.strikingProgress[i] < 10.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] + 2.5f;
            } else if (!striking && this.strikingProgress[i] > 0.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] - 2.5f;
            }
            this.prevSpeakingProgress[i] = this.speakingProgress[i];
            if (this.speakingProgress[i] > 0.0f) {
                int n = i;
                this.speakingProgress[n] = this.speakingProgress[n] - 0.1f;
            }
            this.prevBreathProgress[i] = this.breathProgress[i];
            if (breathing && this.breathProgress[i] < 10.0f) {
                int n = i;
                this.breathProgress[n] = this.breathProgress[n] + 1.0f;
                continue;
            }
            if (breathing || !(this.breathProgress[i] > 0.0f)) continue;
            int n = i;
            this.breathProgress[n] = this.breathProgress[n] - 1.0f;
        }
        if (this.strikeCooldown > 0) {
            --this.strikeCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.getHeadCount() == 1 && this.getSeveredHead() != -1) {
            this.setSeveredHead(-1);
        }
        if (this.getHeadCount() == 1 && !this.m_6060_()) {
            this.setHeadCount(2);
            this.setSeveredHead(1);
            this.onlyRegrowOneHeadNotTwo = true;
        }
        if (this.getSeveredHead() != -1 && this.getSeveredHead() < this.getHeadCount()) {
            this.setSeveredHead(Mth.m_14045_((int)this.getSeveredHead(), (int)0, (int)(this.getHeadCount() - 1)));
            ++this.regrowHeadCooldown;
            if (this.regrowHeadCooldown >= 100) {
                this.headDamageTracker[this.getSeveredHead()] = 0.0f;
                this.setSeveredHead(-1);
                if (this.m_6060_()) {
                    this.setHeadCount(this.getHeadCount() - 1);
                } else {
                    this.m_5496_(IafSoundRegistry.HYDRA_REGEN_HEAD, this.m_6121_(), this.m_6100_());
                    if (!this.onlyRegrowOneHeadNotTwo) {
                        this.setHeadCount(this.getHeadCount() + 1);
                    }
                }
                this.onlyRegrowOneHeadNotTwo = false;
                this.regrowHeadCooldown = 0;
            }
        } else {
            this.regrowHeadCooldown = 0;
        }
    }

    public void resetParts() {
        this.clearParts();
        this.headBoxes = new EntityHydraHead[18];
        for (int i = 0; i < this.getHeadCount(); ++i) {
            float maxAngle = 5.0f;
            this.headBoxes[i] = new EntityHydraHead(this, 3.2f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 1.75f, 1.0f, i, false);
            this.headBoxes[9 + i] = new EntityHydraHead(this, 2.1f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 0.75f, 1.0f, i, true);
            this.headBoxes[i].m_20359_((Entity)this);
            this.headBoxes[9 + i].m_20359_((Entity)this);
            this.headBoxes[i].setParent((Entity)this);
            this.headBoxes[9 + i].setParent((Entity)this);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.prevHeadCount != this.getHeadCount()) {
            this.resetParts();
        }
        this.onUpdateParts();
        float partY = 1.0f - this.f_20924_ * 0.5f;
        for (int i = 0; i < this.getHeadCount(); ++i) {
            this.headBoxes[i].m_6034_(this.headBoxes[i].m_20185_(), this.m_20186_() + (double)partY, this.headBoxes[i].m_20189_());
            this.headBoxes[i].setParent((Entity)this);
            if (!this.headBoxes[i].shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.headBoxes[i]);
            }
            this.headBoxes[9 + i].m_6034_(this.headBoxes[9 + i].m_20185_(), this.m_20186_() + (double)partY, this.headBoxes[9 + i].m_20189_());
            this.headBoxes[9 + i].setParent((Entity)this);
            if (this.headBoxes[9 + i].shouldContinuePersisting()) continue;
            this.f_19853_.m_7967_((Entity)this.headBoxes[9 + i]);
        }
        if (this.getHeadCount() > 1 && !this.m_6060_() && this.m_21223_() < this.m_21233_() && this.f_19797_ % 30 == 0) {
            int level = this.getHeadCount() - 1;
            if (this.getSeveredHead() != -1) {
                --level;
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 30, level, false, false));
        }
        if (this.m_6060_()) {
            this.m_21195_(MobEffects.f_19605_);
        }
        this.prevHeadCount = this.getHeadCount();
    }

    public void onUpdateParts() {
    }

    private void clearParts() {
        for (EntityHydraHead entity : this.headBoxes) {
            if (entity == null) continue;
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.clearParts();
        super.m_142687_(reason);
    }

    protected void m_6677_(@NotNull DamageSource source) {
        this.speakingProgress[this.f_19796_.m_188503_((int)this.getHeadCount())] = 1.0f;
        super.m_6677_(source);
    }

    public void m_8032_() {
        this.speakingProgress[this.f_19796_.m_188503_((int)this.getHeadCount())] = 1.0f;
        super.m_8032_();
    }

    public int m_8100_() {
        return 100 / this.getHeadCount();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("HeadCount", this.getHeadCount());
        compound.m_128405_("SeveredHead", this.getSeveredHead());
        for (int i = 0; i < 9; ++i) {
            compound.m_128350_("HeadDamage" + i, this.headDamageTracker[i]);
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setHeadCount(compound.m_128451_("HeadCount"));
        this.setSeveredHead(compound.m_128451_("SeveredHead"));
        for (int i = 0; i < 9; ++i) {
            this.headDamageTracker[i] = compound.m_128457_("HeadDamage" + i);
        }
        this.setConfigurableAttributes();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(HEAD_COUNT, (Object)3);
        this.f_19804_.m_135372_(SEVERED_HEAD, (Object)-1);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        int headIndex;
        if (this.lastHitHead > this.getHeadCount()) {
            this.lastHitHead = this.getHeadCount() - 1;
        }
        int n = headIndex = this.lastHitHead;
        this.headDamageTracker[n] = this.headDamageTracker[n] + amount;
        if (this.headDamageTracker[headIndex] > this.headDamageThreshold && (this.getSeveredHead() == -1 || this.getSeveredHead() >= this.getHeadCount())) {
            this.headDamageTracker[headIndex] = 0.0f;
            this.regrowHeadCooldown = 0;
            this.setSeveredHead(headIndex);
            this.m_5496_(SoundEvents.f_12004_, this.m_6121_(), this.m_6100_());
        }
        if (this.m_21223_() <= amount + 5.0f && this.getHeadCount() > 1 && !source.m_19378_()) {
            amount = 0.0f;
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.f_19796_.m_188503_(3));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getHeadCount() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(HEAD_COUNT)), (int)1, (int)9);
    }

    public void setHeadCount(int count) {
        this.f_19804_.m_135381_(HEAD_COUNT, (Object)Mth.m_14045_((int)count, (int)1, (int)9));
    }

    public int getSeveredHead() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SEVERED_HEAD)), (int)-1, (int)9);
    }

    public void setSeveredHead(int count) {
        this.f_19804_.m_135381_(SEVERED_HEAD, (Object)Mth.m_14045_((int)count, (int)-1, (int)9));
    }

    public void m_7822_(byte id) {
        if (id >= 40 && id <= 48) {
            int index = id - 40;
            this.isStriking[Mth.m_14045_((int)index, (int)0, (int)8)] = true;
        } else if (id >= 50 && id <= 58) {
            int index = id - 50;
            this.isBreathing[Mth.m_14045_((int)index, (int)0, (int)8)] = true;
        } else if (id >= 60 && id <= 68) {
            int index = id - 60;
            this.isBreathing[Mth.m_14045_((int)index, (int)0, (int)8)] = false;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potioneffectIn);
    }

    public void onHitHead(float damage, int headIndex) {
        this.lastHitHead = headIndex;
    }

    public void triggerHeadFlags(int index) {
        this.lastHitHead = index;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return IafSoundRegistry.HYDRA_IDLE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return IafSoundRegistry.HYDRA_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return IafSoundRegistry.HYDRA_DIE;
    }
}

