/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.datagen.tags.IafItemTags;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonArmor;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class IafRecipes
extends RecipeProvider {
    public IafRecipes(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.createShaped(consumer);
        this.createShapeless(consumer);
        this.smithing(consumer, (ItemLike)IafItemRegistry.DRAGONBONE_SWORD.get(), (ItemLike)IafItemRegistry.FIRE_DRAGON_BLOOD.get(), (Item)IafItemRegistry.DRAGONBONE_SWORD_FIRE.get());
        this.smithing(consumer, (ItemLike)IafItemRegistry.DRAGONBONE_SWORD.get(), (ItemLike)IafItemRegistry.ICE_DRAGON_BLOOD.get(), (Item)IafItemRegistry.DRAGONBONE_SWORD_ICE.get());
        this.smithing(consumer, (ItemLike)IafItemRegistry.DRAGONBONE_SWORD.get(), (ItemLike)IafItemRegistry.LIGHTNING_DRAGON_BLOOD.get(), (Item)IafItemRegistry.DRAGONBONE_SWORD_LIGHTNING.get());
        this.smithing(consumer, (ItemLike)IafItemRegistry.DRAGONBONE_SWORD.get(), (ItemLike)IafItemRegistry.GHOST_INGOT.get(), (Item)IafItemRegistry.GHOST_SWORD.get());
    }

    private void createShaped(@NotNull Consumer<FinishedRecipe> consumer) {
        CustomShaped.shaped((ItemLike)IafItemRegistry.AMPHITHERE_ARROW.get(), 4).pattern("X").pattern("#").pattern("Y").m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42484_).m_126127_(Character.valueOf('Y'), (ItemLike)IafItemRegistry.AMPHITHERE_FEATHER.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.AMPHITHERE_MACUAHUITL.get()).pattern("OXO").pattern("FXF").pattern("OSO").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('O'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('F'), (ItemLike)IafItemRegistry.AMPHITHERE_FEATHER.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.BLINDFOLD.get()).pattern("SLS").m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.CHAIN.get()).pattern("S").pattern("S").pattern("S").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42026_).m_176498_(consumer);
        this.armorSet(consumer, (ItemLike)Items.f_42026_, new ItemLike[]{Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_});
        CustomShaped.shaped((ItemLike)IafItemRegistry.ITEM_COCKATRICE_SCEPTER.get()).pattern("S").pattern("E").pattern("W").m_206416_(Character.valueOf('W'), IafItemTags.BONES_WITHER).m_126127_(Character.valueOf('S'), (ItemLike)IafItemRegistry.WITHER_SHARD.get()).m_126127_(Character.valueOf('E'), (ItemLike)IafItemRegistry.COCKATRICE_EYE.get()).m_176498_(consumer);
        this.armorSet(consumer, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)IafItemRegistry.COPPER_HELMET.get(), (ItemLike)IafItemRegistry.COPPER_CHESTPLATE.get(), (ItemLike)IafItemRegistry.COPPER_LEGGINGS.get(), (ItemLike)IafItemRegistry.COPPER_BOOTS.get());
        this.toolSet(consumer, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (TagKey<Item>)Tags.Items.RODS_WOODEN, (ItemLike)IafItemRegistry.COPPER_SWORD.get(), (ItemLike)IafItemRegistry.COPPER_PICKAXE.get(), (ItemLike)IafItemRegistry.COPPER_AXE.get(), (ItemLike)IafItemRegistry.COPPER_SHOVEL.get(), (ItemLike)IafItemRegistry.COPPER_HOE.get());
        CustomShaped.shaped((ItemLike)IafItemRegistry.DEATHWORM_GAUNTLET_RED.get()).pattern(" T ").pattern("CHC").pattern("CCC").m_126127_(Character.valueOf('C'), (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_RED.get()).m_126127_(Character.valueOf('H'), (ItemLike)IafItemRegistry.CHAIN.get()).m_126127_(Character.valueOf('T'), (ItemLike)IafItemRegistry.DEATHWORM_TOUNGE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DEATHWORM_GAUNTLET_WHITE.get()).pattern(" T ").pattern("CHC").pattern("CCC").m_126127_(Character.valueOf('C'), (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_WHITE.get()).m_126127_(Character.valueOf('H'), (ItemLike)IafItemRegistry.CHAIN.get()).m_126127_(Character.valueOf('T'), (ItemLike)IafItemRegistry.DEATHWORM_TOUNGE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DEATHWORM_GAUNTLET_YELLOW.get()).pattern(" T ").pattern("CHC").pattern("CCC").m_126127_(Character.valueOf('C'), (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_YELLOW.get()).m_126127_(Character.valueOf('H'), (ItemLike)IafItemRegistry.CHAIN.get()).m_126127_(Character.valueOf('T'), (ItemLike)IafItemRegistry.DEATHWORM_TOUNGE.get()).m_176498_(consumer);
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_RED.get(), (ItemLike)IafItemRegistry.DEATHWORM_RED_HELMET.get(), (ItemLike)IafItemRegistry.DEATHWORM_RED_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DEATHWORM_RED_LEGGINGS.get(), (ItemLike)IafItemRegistry.DEATHWORM_RED_BOOTS.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_WHITE.get(), (ItemLike)IafItemRegistry.DEATHWORM_WHITE_HELMET.get(), (ItemLike)IafItemRegistry.DEATHWORM_WHITE_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DEATHWORM_WHITE_LEGGINGS.get(), (ItemLike)IafItemRegistry.DEATHWORM_WHITE_BOOTS.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DEATH_WORM_CHITIN_YELLOW.get(), (ItemLike)IafItemRegistry.DEATHWORM_YELLOW_HELMET.get(), (ItemLike)IafItemRegistry.DEATHWORM_YELLOW_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DEATHWORM_YELLOW_LEGGINGS.get(), (ItemLike)IafItemRegistry.DEATHWORM_YELLOW_BOOTS.get());
        this.dragonArmorSet(consumer, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER, (ItemLike)IafItemRegistry.DRAGONARMOR_COPPER_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_COPPER_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_COPPER_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_COPPER_3.get());
        this.dragonArmorSet(consumer, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON, (ItemLike)IafItemRegistry.DRAGONARMOR_IRON_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_IRON_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_IRON_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_IRON_3.get());
        this.dragonArmorSet(consumer, IafItemTags.STORAGE_BLOCKS_SILVER, (ItemLike)IafItemRegistry.DRAGONARMOR_SILVER_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_SILVER_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_SILVER_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_SILVER_3.get());
        this.dragonArmorSet(consumer, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND, (ItemLike)IafItemRegistry.DRAGONARMOR_DIAMOND_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DIAMOND_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DIAMOND_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DIAMOND_3.get());
        CustomShaped.shaped((ItemLike)IafItemRegistry.IRON_HIPPOGRYPH_ARMOR.get()).pattern("FDF").m_206416_(Character.valueOf('F'), Tags.Items.FEATHERS).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42651_).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.GOLD_HIPPOGRYPH_ARMOR.get()).pattern("FDF").m_206416_(Character.valueOf('F'), Tags.Items.FEATHERS).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42652_).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DIAMOND_HIPPOGRYPH_ARMOR.get()).pattern("FDF").m_206416_(Character.valueOf('F'), Tags.Items.FEATHERS).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42653_).m_176498_(consumer);
        IafRecipes.m_176568_(consumer, (ItemLike)((ItemLike)IafItemRegistry.DRAGON_BONE.get()), (ItemLike)((ItemLike)IafBlockRegistry.DRAGON_BONE_BLOCK.get()), (String)IafRecipes.locationString("dragon_bone_block"), null, (String)IafRecipes.locationString("dragonbone"), null);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DRAGON_BONE_BLOCK_WALL.get()).pattern("BBB").pattern("BBB").m_126127_(Character.valueOf('B'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DRAGON_FLUTE.get()).pattern("B  ").pattern(" B ").pattern("  I").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('B'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DRAGON_HORN.get()).pattern("  B").pattern(" BB").pattern("IB ").m_206416_(Character.valueOf('I'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('B'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DRAGON_ICE_SPIKES.get(), 4).pattern("I I").pattern("I I").m_126127_(Character.valueOf('I'), (ItemLike)IafBlockRegistry.DRAGON_ICE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.NEST.get(), 8).pattern("HHH").pattern("HBH").pattern("HHH").m_126127_(Character.valueOf('H'), (ItemLike)Blocks.f_50335_).m_126127_(Character.valueOf('B'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.DRAGON_STAFF.get()).pattern("S").pattern("T").pattern("T").m_206416_(Character.valueOf('T'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('S'), IafItemTags.DRAGON_SKULLS).m_176498_(consumer);
        this.toolSet(consumer, (ItemLike)IafItemRegistry.DRAGON_BONE.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.DRAGONBONE_SWORD.get(), (ItemLike)IafItemRegistry.DRAGONBONE_PICKAXE.get(), (ItemLike)IafItemRegistry.DRAGONBONE_AXE.get(), (ItemLike)IafItemRegistry.DRAGONBONE_SHOVEL.get(), (ItemLike)IafItemRegistry.DRAGONBONE_HOE.get());
        CustomShaped.shaped((ItemLike)IafItemRegistry.DRAGON_BOW.get()).pattern(" DS").pattern("W S").pattern(" DS").m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_206416_(Character.valueOf('W'), IafItemTags.BONES_WITHER).m_126127_(Character.valueOf('D'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
        this.forgeBrick(consumer, (ItemLike)Items.f_42018_, IafItemTags.STORAGE_BLOCKS_SCALES_DRAGON_FIRE, (ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get());
        this.forgeCore(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get(), (ItemLike)IafItemRegistry.FIRE_DRAGON_HEART.get(), (ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED.get());
        this.forgeInput(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_BRICK.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_INPUT.get());
        this.forgeBrick(consumer, (ItemLike)Items.f_42018_, IafItemTags.STORAGE_BLOCKS_SCALES_DRAGON_ICE, (ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get());
        this.forgeCore(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get(), (ItemLike)IafItemRegistry.ICE_DRAGON_HEART.get(), (ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED.get());
        this.forgeInput(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_BRICK.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_INPUT.get());
        this.forgeBrick(consumer, (ItemLike)Items.f_42018_, IafItemTags.STORAGE_BLOCKS_SCALES_DRAGON_LIGHTNING, (ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get());
        this.forgeCore(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get(), (ItemLike)IafItemRegistry.LIGHTNING_DRAGON_HEART.get(), (ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get());
        this.forgeInput(consumer, (ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_INPUT.get());
        CustomShaped.shaped((ItemLike)IafItemRegistry.DRAGON_MEAL.get()).pattern("BMB").pattern("MBM").pattern("BMB").m_206416_(Character.valueOf('B'), Tags.Items.BONES).m_206416_(Character.valueOf('M'), IafItemTags.DRAGON_FOOD_MEAT).m_176498_(consumer);
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_RED.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_RED.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_GREEN.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_GREEN.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_BRONZE.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_BRONZE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_GRAY.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_GRAY.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_BLUE.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_BLUE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_WHITE.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_WHITE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_SAPPHIRE.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_SAPPHIRE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_SILVER.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_SILVER.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_ELECTRIC.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_ELECTRIC.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_AMYTHEST.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_AMYTHEST.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_COPPER.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_COPPER.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSCALES_BLACK.get(), (ItemLike)IafBlockRegistry.DRAGON_SCALE_BLACK.get());
        for (EnumDragonArmor enumDragonArmor : EnumDragonArmor.values()) {
            this.armorSet(consumer, enumDragonArmor.armorMaterial.m_6230_(), (ItemLike)enumDragonArmor.helmet.get(), (ItemLike)enumDragonArmor.chestplate.get(), (ItemLike)enumDragonArmor.leggings.get(), (ItemLike)enumDragonArmor.boots.get());
        }
        for (Enum enum_ : EnumSeaSerpent.values()) {
            this.armorSet(consumer, (ItemLike)((EnumSeaSerpent)enum_).scale.get(), (ItemLike)((EnumSeaSerpent)enum_).helmet.get(), (ItemLike)((EnumSeaSerpent)enum_).chestplate.get(), (ItemLike)((EnumSeaSerpent)enum_).leggings.get(), (ItemLike)((EnumSeaSerpent)enum_).boots.get());
            this.compact(consumer, (ItemLike)((EnumSeaSerpent)enum_).scale.get(), (ItemLike)((EnumSeaSerpent)enum_).scaleBlock.get());
        }
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_INGOT.get(), (ItemLike)IafBlockRegistry.DRAGONSTEEL_FIRE_BLOCK.get());
        this.toolSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_INGOT.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_SWORD.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_PICKAXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_AXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_SHOVEL.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_HOE.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_INGOT.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_HELMET.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_LEGGINGS.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_BOOTS.get());
        this.dragonArmorSet(consumer, (ItemLike)IafBlockRegistry.DRAGONSTEEL_FIRE_BLOCK.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_FIRE_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_FIRE_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_FIRE_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_FIRE_3.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_INGOT.get(), (ItemLike)IafBlockRegistry.DRAGONSTEEL_ICE_BLOCK.get());
        this.toolSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_INGOT.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_SWORD.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_PICKAXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_AXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_SHOVEL.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_HOE.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_INGOT.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_HELMET.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_LEGGINGS.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_BOOTS.get());
        this.dragonArmorSet(consumer, (ItemLike)IafBlockRegistry.DRAGONSTEEL_ICE_BLOCK.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_ICE_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_ICE_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_ICE_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_ICE_3.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_INGOT.get(), (ItemLike)IafBlockRegistry.DRAGONSTEEL_LIGHTNING_BLOCK.get());
        this.toolSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_INGOT.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_SWORD.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_PICKAXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_AXE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_SHOVEL.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_HOE.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_INGOT.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_HELMET.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_CHESTPLATE.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_LEGGINGS.get(), (ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_BOOTS.get());
        this.dragonArmorSet(consumer, (ItemLike)IafBlockRegistry.DRAGONSTEEL_LIGHTNING_BLOCK.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_LIGHTNING_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_LIGHTNING_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_LIGHTNING_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_DRAGONSTEEL_LIGHTNING_3.get());
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE.get(), 8).pattern("DDD").pattern("DSD").pattern("DDD").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('D'), (ItemLike)IafItemRegistry.DREAD_SHARD.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get(), 4).pattern("DD").pattern("DD").m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS_CHISELED.get()).pattern("D").pattern("D").m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS_SLAB.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_FACE.get(), 8).pattern("DDD").pattern("DSD").pattern("DDD").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42678_).m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS_SLAB.get(), 6).pattern("DDD").m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS_STAIRS.get(), 4).pattern("D  ").pattern("DD ").pattern("DDD").m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_STONE_TILE.get(), 8).pattern("DDD").pattern("D D").pattern("DDD").m_126127_(Character.valueOf('D'), (ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.DREAD_TORCH.get(), 4).pattern("D").pattern("S").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('D'), (ItemLike)IafItemRegistry.DREAD_SHARD.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafItemRegistry.EARPLUGS.get()).pattern("B B").m_206416_(Character.valueOf('B'), ItemTags.f_13168_).m_176498_(consumer);
        for (Enum enum_ : EnumTroll.values()) {
            this.armorSet(consumer, (ItemLike)((EnumTroll)enum_).leather.get(), (ItemLike)((EnumTroll)enum_).chestplate.get(), (ItemLike)((EnumTroll)enum_).leggings.get(), (ItemLike)((EnumTroll)enum_).boots.get());
            CustomShaped.shaped((ItemLike)((EnumTroll)enum_).helmet.get()).pattern("TTT").pattern("U U").m_126127_(Character.valueOf('T'), (ItemLike)((EnumTroll)enum_).leather.get()).m_126127_(Character.valueOf('U'), (ItemLike)IafItemRegistry.TROLL_TUSK.get()).m_176498_(consumer);
        }
        CustomShaped.shaped((ItemLike)IafBlockRegistry.GHOST_CHEST.get()).pattern(" E ").pattern("ECE").pattern(" E ").m_206416_(Character.valueOf('C'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('E'), (ItemLike)IafItemRegistry.ECTOPLASM.get()).m_176498_(consumer);
        this.dragonArmorSet(consumer, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD, (ItemLike)IafItemRegistry.DRAGONARMOR_GOLD_0.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_GOLD_1.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_GOLD_2.get(), (ItemLike)IafItemRegistry.DRAGONARMOR_GOLD_3.get());
        CustomShaped.shaped((ItemLike)IafBlockRegistry.GRAVEYARD_SOIL.get()).pattern(" E ").pattern("ECE").pattern(" E ").m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42382_).m_126127_(Character.valueOf('E'), (ItemLike)IafItemRegistry.ECTOPLASM.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.MYRMEX_DESERT_RESIN.get()).pattern("RR").pattern("RR").m_126127_(Character.valueOf('R'), (ItemLike)IafItemRegistry.MYRMEX_DESERT_RESIN.get()).m_176498_(consumer);
        CustomShaped.shaped((ItemLike)IafBlockRegistry.MYRMEX_JUNGLE_RESIN.get()).pattern("RR").pattern("RR").m_126127_(Character.valueOf('R'), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_RESIN.get()).m_176498_(consumer);
        this.armorSet(consumer, (ItemLike)IafItemRegistry.MYRMEX_DESERT_CHITIN.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_HELMET.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_CHESTPLATE.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_LEGGINGS.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_BOOTS.get());
        this.toolSet(consumer, (ItemLike)IafItemRegistry.MYRMEX_DESERT_CHITIN.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.MYRMEX_DESERT_SWORD.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_PICKAXE.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_AXE.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_SHOVEL.get(), (ItemLike)IafItemRegistry.MYRMEX_DESERT_HOE.get());
        this.armorSet(consumer, (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_CHITIN.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_HELMET.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_CHESTPLATE.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_LEGGINGS.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_BOOTS.get());
        this.toolSet(consumer, (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_CHITIN.get(), IafItemTags.BONES_WITHER, (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_SWORD.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_PICKAXE.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_AXE.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_SHOVEL.get(), (ItemLike)IafItemRegistry.MYRMEX_JUNGLE_HOE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.SILVER_INGOT.get(), (ItemLike)IafBlockRegistry.SILVER_BLOCK.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.SILVER_NUGGET.get(), (ItemLike)IafItemRegistry.SILVER_INGOT.get());
        this.armorSet(consumer, IafItemTags.INGOTS_SILVER, (ItemLike)IafItemRegistry.SILVER_HELMET.get(), (ItemLike)IafItemRegistry.SILVER_CHESTPLATE.get(), (ItemLike)IafItemRegistry.SILVER_LEGGINGS.get(), (ItemLike)IafItemRegistry.SILVER_BOOTS.get());
        this.toolSet(consumer, IafItemTags.INGOTS_SILVER, (TagKey<Item>)Tags.Items.RODS_WOODEN, (ItemLike)IafItemRegistry.SILVER_SWORD.get(), (ItemLike)IafItemRegistry.SILVER_PICKAXE.get(), (ItemLike)IafItemRegistry.SILVER_AXE.get(), (ItemLike)IafItemRegistry.SILVER_SHOVEL.get(), (ItemLike)IafItemRegistry.SILVER_HOE.get());
        this.compact(consumer, (ItemLike)IafItemRegistry.SAPPHIRE_GEM.get(), (ItemLike)IafBlockRegistry.SAPPHIRE_BLOCK.get());
        CustomShaped.shaped((ItemLike)IafItemRegistry.TIDE_TRIDENT.get()).pattern("TTT").pattern("SDS").pattern(" B ").m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_206416_(Character.valueOf('S'), IafItemTags.SCALES_SEA_SERPENT).m_126127_(Character.valueOf('T'), (ItemLike)IafItemRegistry.SERPENT_FANG.get()).m_126127_(Character.valueOf('B'), (ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_176498_(consumer);
    }

    private void createShapeless(@NotNull Consumer<FinishedRecipe> consumer) {
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.AMBROSIA.get()).m_126209_((ItemLike)IafItemRegistry.PIXIE_DUST.get()).m_126209_((ItemLike)Items.f_42399_).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)Items.f_42414_).m_126211_((ItemLike)IafBlockRegistry.ASH.get(), 9).m_126140_(consumer, IafRecipes.location("ash_to_charcoal"));
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.ASH.get()).requires(IafItemTags.CHARRED_BLOCKS, 9).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.BESTIARY.get()).m_126211_((ItemLike)IafItemRegistry.MANUSCRIPT.get(), 3).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.CHAIN_STICKY.get()).m_206419_(Tags.Items.SLIMEBALLS).m_126209_((ItemLike)IafItemRegistry.CHAIN.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)Items.f_151052_).m_126211_((ItemLike)IafItemRegistry.COPPER_NUGGET.get(), 9).m_126140_(consumer, IafRecipes.location("copper_nuggets_to_ingot"));
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.COPPER_NUGGET.get(), 9).m_206419_(Tags.Items.INGOTS_COPPER).m_126140_(consumer, IafRecipes.location("copper_ingot_to_nuggets"));
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.COPPER_PILE.get()).requires(IafItemTags.NUGGETS_COPPER, 2).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.DRAGON_ICE.get()).requires(IafItemTags.FROZEN_BLOCKS, 9).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)Items.f_42499_, 5).m_206419_(IafItemTags.MOB_SKULLS).m_126140_(consumer, IafRecipes.location("skull_to_bone_meal"));
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.DRAGONBONE_ARROW.get(), 5).m_126209_((ItemLike)IafItemRegistry.DRAGON_BONE.get()).m_126209_((ItemLike)IafItemRegistry.WITHER_SHARD.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.get()).m_126209_((ItemLike)Items.f_42029_).m_126209_((ItemLike)IafBlockRegistry.DREAD_STONE_BRICKS.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.DREADWOOD_PLANKS.get(), 4).m_126209_((ItemLike)IafBlockRegistry.DREADWOOD_LOG.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.FIRE_STEW.get()).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)Items.f_42585_).m_126209_((ItemLike)IafBlockRegistry.FIRE_LILY.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafItemRegistry.FROST_STEW.get()).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)Items.f_42696_).m_126209_((ItemLike)IafBlockRegistry.FROST_LILY.get()).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)IafBlockRegistry.GOLD_PILE.get()).requires((TagKey<Item>)Tags.Items.NUGGETS_GOLD, 2).m_176498_(consumer);
        CustomShapeless.shapeless((ItemLike)Items.f_41832_).requires(IafItemTags.CRACKLED_BLOCKS, 9).m_126140_(consumer, IafRecipes.location("crackled_to_gravel"));
        CustomShaped.shaped((ItemLike)IafItemRegistry.SEA_SERPENT_ARROW.get(), 4).pattern("X").pattern("#").pattern("Y").m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('X'), (ItemLike)IafItemRegistry.SERPENT_FANG.get()).m_206416_(Character.valueOf('Y'), IafItemTags.SCALES_SEA_SERPENT).m_176498_(consumer);
    }

    private void smithing(@NotNull Consumer<FinishedRecipe> consumer, ItemLike base, ItemLike material, Item result) {
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (Item)result).m_126389_("has_" + ForgeRegistries.ITEMS.getKey((Object)material.m_5456_()).m_135815_(), (CriterionTriggerInstance)IafRecipes.m_125977_((ItemLike)material)).m_126395_(consumer, IafRecipes.location(ForgeRegistries.ITEMS.getKey((Object)result).m_135815_()));
    }

    private void compact(@NotNull Consumer<FinishedRecipe> consumer, ItemLike unpacked, ItemLike packed) {
        String packedPath = ForgeRegistries.ITEMS.getKey((Object)packed.m_5456_()).m_135815_();
        String unpackedPath = ForgeRegistries.ITEMS.getKey((Object)unpacked.m_5456_()).m_135815_();
        IafRecipes.m_176568_(consumer, (ItemLike)unpacked, (ItemLike)packed, (String)IafRecipes.locationString(unpackedPath + "_to_" + packedPath), null, (String)IafRecipes.locationString(packedPath + "_to_" + unpackedPath), null);
    }

    private void toolSet(@NotNull Consumer<FinishedRecipe> consumer, TagKey<Item> material, TagKey<Item> handle, ItemLike ... items) {
        this.toolSet(consumer, Ingredient.m_204132_(material), Ingredient.m_204132_(handle), items);
    }

    private void toolSet(@NotNull Consumer<FinishedRecipe> consumer, ItemLike material, TagKey<Item> handle, ItemLike ... items) {
        this.toolSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_204132_(handle), items);
    }

    private void toolSet(@NotNull Consumer<FinishedRecipe> consumer, TagKey<Item> material, ItemLike handle, ItemLike ... items) {
        this.toolSet(consumer, Ingredient.m_204132_(material), Ingredient.m_43929_((ItemLike[])new ItemLike[]{handle}), items);
    }

    private void toolSet(@NotNull Consumer<FinishedRecipe> consumer, ItemLike material, ItemLike handle, ItemLike ... items) {
        this.toolSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{handle}), items);
    }

    private void toolSet(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike ... results) {
        for (ItemLike result : results) {
            Item item = result.m_5456_();
            if (item instanceof SwordItem) {
                this.sword(consumer, material, handle, result);
                continue;
            }
            if (item instanceof PickaxeItem) {
                this.pickaxe(consumer, material, handle, result);
                continue;
            }
            if (item instanceof AxeItem) {
                this.axe(consumer, material, handle, result);
                continue;
            }
            if (item instanceof ShovelItem) {
                this.shovel(consumer, material, handle, result);
                continue;
            }
            if (item instanceof HoeItem) {
                this.hoe(consumer, material, handle, result);
                continue;
            }
            throw new IllegalArgumentException("Result is not a valid tool: [" + result + "]");
        }
    }

    private void armorSet(@NotNull Consumer<FinishedRecipe> consumer, TagKey<Item> tag, ItemLike ... results) {
        this.armorSet(consumer, Ingredient.m_204132_(tag), results);
    }

    private void armorSet(@NotNull Consumer<FinishedRecipe> consumer, ItemLike item, ItemLike ... results) {
        this.armorSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), results);
    }

    private void armorSet(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike ... results) {
        block6: for (ItemLike result : results) {
            Item item = result.m_5456_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                switch (armorItem.m_40402_()) {
                    case HEAD: {
                        this.helmet(consumer, ingredient, result);
                        continue block6;
                    }
                    case CHEST: {
                        this.chestPlate(consumer, ingredient, result);
                        continue block6;
                    }
                    case LEGS: {
                        this.leggings(consumer, ingredient, result);
                        continue block6;
                    }
                    case FEET: {
                        this.boots(consumer, ingredient, result);
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Result is not a valid armor item: [" + result + "]");
                    }
                }
            }
            throw new IllegalArgumentException("Result is not an armor item: [" + result + "]");
        }
    }

    private void helmet(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("###").pattern("# #").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void chestPlate(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void leggings(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void boots(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("# #").pattern("# #").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void sword(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike result) {
        CustomShaped.shaped(result).pattern("M").pattern("M").pattern("H").define(Character.valueOf('M'), material).define(Character.valueOf('H'), handle).m_176498_(consumer);
    }

    private void pickaxe(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike result) {
        CustomShaped.shaped(result).pattern("MMM").pattern(" H ").pattern(" H ").define(Character.valueOf('M'), material).define(Character.valueOf('H'), handle).m_176498_(consumer);
    }

    private void axe(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike result) {
        CustomShaped.shaped(result).pattern("MM").pattern("MH").pattern(" H").define(Character.valueOf('M'), material).define(Character.valueOf('H'), handle).m_176498_(consumer);
    }

    private void shovel(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike result) {
        CustomShaped.shaped(result).pattern("M").pattern("H").pattern("H").define(Character.valueOf('M'), material).define(Character.valueOf('H'), handle).m_176498_(consumer);
    }

    private void hoe(@NotNull Consumer<FinishedRecipe> consumer, Ingredient material, Ingredient handle, ItemLike result) {
        CustomShaped.shaped(result).pattern("MM").pattern(" H").pattern(" H").define(Character.valueOf('M'), material).define(Character.valueOf('H'), handle).m_176498_(consumer);
    }

    private void dragonArmorSet(@NotNull Consumer<FinishedRecipe> consumer, ItemLike material, ItemLike ... results) {
        this.dragonArmorSet(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), results);
    }

    private void dragonArmorSet(@NotNull Consumer<FinishedRecipe> consumer, TagKey<Item> tag, ItemLike ... results) {
        this.dragonArmorSet(consumer, Ingredient.m_204132_(tag), results);
    }

    private void dragonArmorSet(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike ... results) {
        block6: for (ItemLike result : results) {
            if (result instanceof ItemDragonArmor) {
                ItemDragonArmor dragonArmor = (ItemDragonArmor)result;
                switch (dragonArmor.dragonSlot) {
                    case 0: {
                        this.dragonHead(consumer, ingredient, result);
                        continue block6;
                    }
                    case 1: {
                        this.dragonNeck(consumer, ingredient, result);
                        continue block6;
                    }
                    case 2: {
                        this.dragonBody(consumer, ingredient, result);
                        continue block6;
                    }
                    case 3: {
                        this.dragonTail(consumer, ingredient, result);
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Result is not a valid dragon armor [" + result + "]");
                    }
                }
            }
            throw new IllegalArgumentException("Result is not a dragon armor [" + result + "]");
        }
    }

    private void dragonHead(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("   ").pattern(" ##").pattern("###").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void dragonNeck(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("   ").pattern("###").pattern(" ##").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void dragonBody(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("###").pattern("###").pattern("# #").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void dragonTail(@NotNull Consumer<FinishedRecipe> consumer, Ingredient ingredient, ItemLike result) {
        CustomShaped.shaped(result).pattern("   ").pattern("  #").pattern("## ").define(Character.valueOf('#'), ingredient).m_176498_(consumer);
    }

    private void forgeBrick(@NotNull Consumer<FinishedRecipe> consumer, ItemLike brick, TagKey<Item> scales, ItemLike result) {
        CustomShaped.shaped(result, 4).pattern("SBS").pattern("BSB").pattern("SBS").define(Character.valueOf('S'), Ingredient.m_204132_(scales)).m_126127_(Character.valueOf('B'), brick).m_176498_(consumer);
    }

    private void forgeCore(@NotNull Consumer<FinishedRecipe> consumer, ItemLike brick, ItemLike heart, ItemLike result) {
        CustomShaped.shaped(result).pattern("BBB").pattern("BHB").pattern("BBB").m_126127_(Character.valueOf('H'), heart).m_126127_(Character.valueOf('B'), brick).m_176498_(consumer);
    }

    private void forgeInput(@NotNull Consumer<FinishedRecipe> consumer, ItemLike brick, TagKey<Item> material, ItemLike result) {
        CustomShaped.shaped(result).pattern("BIB").pattern("I I").pattern("BIB").define(Character.valueOf('I'), Ingredient.m_204132_(material)).m_126127_(Character.valueOf('B'), brick).m_176498_(consumer);
    }

    public void m_213708_(@NotNull CachedOutput output) {
        HashSet set = Sets.newHashSet();
        this.m_176531_(finishedRecipe -> {
            if (!set.add(finishedRecipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + finishedRecipe.m_6445_());
            }
            IafRecipes.m_236359_(output, finishedRecipe.m_125966_(), this.f_236355_.m_236048_(finishedRecipe.m_6445_()));
        });
    }

    private static void m_236359_(CachedOutput output, JsonObject recipeJson, Path path) {
        try {
            DataProvider.m_236072_((CachedOutput)output, (JsonElement)recipeJson, (Path)path);
        }
        catch (IOException exception) {
            IceAndFire.LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)exception);
        }
    }

    private static ResourceLocation location(String path) {
        return new ResourceLocation("iceandfire", path);
    }

    private static String locationString(String path) {
        return "iceandfire:" + path;
    }

    private static class CustomShaped
    extends ShapedRecipeBuilder {
        public CustomShaped(ItemLike result, int count) {
            super(result, count);
        }

        public static CustomShaped shaped(ItemLike result) {
            return CustomShaped.shaped(result, 1);
        }

        public static CustomShaped shaped(ItemLike result, int count) {
            return new CustomShaped(result, count);
        }

        public CustomShaped pattern(@NotNull String pattern) {
            super.m_126130_(pattern);
            return this;
        }

        public CustomShaped define(@NotNull Character symbol, @NotNull Ingredient ingredient) {
            super.m_126124_(symbol, ingredient);
            return this;
        }

        public void m_126140_(Consumer<FinishedRecipe> finishedRecipe, @NotNull ResourceLocation recipeId) {
            this.m_126143_(recipeId);
            finishedRecipe.accept((FinishedRecipe)new ShapedRecipeBuilder.Result(recipeId, this.f_126106_, this.f_126107_, this.f_126111_ == null ? "" : this.f_126111_, this.f_126108_, this.f_126109_, this.f_126110_, new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.f_126106_.m_41471_().m_40783_() + "/" + recipeId.m_135815_())));
        }

        private void m_126143_(ResourceLocation id) {
            if (this.f_126108_.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
            }
            HashSet set = Sets.newHashSet(this.f_126109_.keySet());
            set.remove(Character.valueOf(' '));
            for (String s : this.f_126108_) {
                for (int i = 0; i < s.length(); ++i) {
                    char c0 = s.charAt(i);
                    if (!this.f_126109_.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                        throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                    }
                    set.remove(Character.valueOf(c0));
                }
            }
            if (!set.isEmpty()) {
                throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
            }
            if (this.f_126108_.size() == 1 && ((String)this.f_126108_.get(0)).length() == 1) {
                throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
            }
        }
    }

    private static class CustomShapeless
    extends ShapelessRecipeBuilder {
        public CustomShapeless(ItemLike result, int count) {
            super(result, count);
        }

        public static CustomShapeless shapeless(ItemLike result) {
            return CustomShapeless.shapeless(result, 1);
        }

        public static CustomShapeless shapeless(ItemLike result, int count) {
            return new CustomShapeless(result, count);
        }

        public CustomShapeless requires(@NotNull TagKey<Item> tag, int count) {
            for (int i = 0; i < count; ++i) {
                this.m_126184_(Ingredient.m_204132_(tag));
            }
            return this;
        }

        public CustomShapeless requires(@NotNull Ingredient ingredient, int quantity) {
            super.m_126186_(ingredient, quantity);
            return this;
        }

        public void m_126140_(Consumer<FinishedRecipe> finishedRecipe, @NotNull ResourceLocation recipeId) {
            finishedRecipe.accept((FinishedRecipe)new ShapelessRecipeBuilder.Result(recipeId, this.f_126173_, this.f_126174_, this.f_126177_ == null ? "" : this.f_126177_, this.f_126175_, this.f_126176_, new ResourceLocation(recipeId.m_135827_(), "recipes/" + this.f_126173_.m_41471_().m_40783_() + "/" + recipeId.m_135815_())));
        }
    }
}

