/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;

public class BlockCharedPath
extends DirtPathBlock {
    public static final BooleanProperty REVERTS = BooleanProperty.m_61465_((String)"revert");
    public Item itemBlock;
    public int dragonType;

    public BlockCharedPath(int dragonType) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(dragonType != 1 ? SoundType.f_56739_ : SoundType.f_56744_).m_60978_(0.6f).m_60911_(dragonType != 1 ? 0.6f : 0.98f).m_60977_().m_60999_());
        this.dragonType = dragonType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)REVERTS, (Comparable)Boolean.FALSE));
    }

    public static String getNameFromType(int dragonType) {
        return switch (dragonType) {
            case 0 -> "chared_dirt_path";
            case 1 -> "frozen_dirt_path";
            case 2 -> "crackled_dirt_path";
            default -> "";
        };
    }

    public BlockState getSmushedState(int dragonType) {
        return switch (dragonType) {
            case 0 -> ((Block)IafBlockRegistry.CHARRED_DIRT.get()).m_49966_();
            case 1 -> ((Block)IafBlockRegistry.FROZEN_DIRT.get()).m_49966_();
            case 2 -> ((Block)IafBlockRegistry.CRACKLED_DIRT.get()).m_49966_();
            default -> null;
        };
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.f_46443_) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (((Boolean)state.m_61143_((Property)REVERTS)).booleanValue() && rand.m_188503_(3) == 0) {
                worldIn.m_46597_(pos, Blocks.f_152481_.m_49966_());
            }
        }
        if (worldIn.m_8055_(pos.m_7494_()).m_60767_().m_76333_()) {
            worldIn.m_46597_(pos, this.getSmushedState(this.dragonType));
        }
        this.updateBlockState((Level)worldIn, pos);
    }

    private void updateBlockState(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos.m_7494_()).m_60767_().m_76333_()) {
            worldIn.m_46597_(pos, this.getSmushedState(this.dragonType));
        }
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.m_49966_().m_61124_((Property)REVERTS, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.m_61143_((Property)REVERTS) != false ? 1 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{REVERTS});
    }
}

