/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions.networking;

import com.github.justinwon777.humancompanions.core.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenInventoryPacket {
    private final int id;
    private final int size;
    private final int entityId;

    public OpenInventoryPacket(int id, int size, int entityId) {
        this.id = id;
        this.size = size;
        this.entityId = entityId;
    }

    public static OpenInventoryPacket decode(FriendlyByteBuf buf) {
        return new OpenInventoryPacket(buf.readUnsignedByte(), buf.m_130242_(), buf.readInt());
    }

    public static void encode(OpenInventoryPacket msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.id);
        buf.m_130130_(msg.size);
        buf.writeInt(msg.entityId);
    }

    public int getId() {
        return this.id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void handle(OpenInventoryPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketHandler.openInventory(msg));
        context.get().setPacketHandled(true);
    }
}

