/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gnumus;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.gnumus.init.GnumusModBlocks;
import net.mcreator.gnumus.init.GnumusModEntities;
import net.mcreator.gnumus.init.GnumusModFeatures;
import net.mcreator.gnumus.init.GnumusModItems;
import net.mcreator.gnumus.init.GnumusModMobEffects;
import net.mcreator.gnumus.init.GnumusModParticleTypes;
import net.mcreator.gnumus.init.GnumusModSounds;
import net.mcreator.gnumus.init.GnumusModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="gnumus")
public class GnumusMod {
    public static final Logger LOGGER = LogManager.getLogger(GnumusMod.class);
    public static final String MODID = "gnumus";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("gnumus", "gnumus"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public GnumusMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GnumusModTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        GnumusModSounds.REGISTRY.register(bus);
        GnumusModBlocks.REGISTRY.register(bus);
        GnumusModItems.REGISTRY.register(bus);
        GnumusModEntities.REGISTRY.register(bus);
        GnumusModFeatures.REGISTRY.register(bus);
        GnumusModMobEffects.REGISTRY.register(bus);
        GnumusModParticleTypes.REGISTRY.register(bus);
        GeckoLib.initialize();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

