/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.item.ConfigurableItem;
import com.eeeab.eeeabsmobs.sever.item.IUnbreakableItem;
import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ItemGuardianAxe
extends AxeItem
implements ConfigurableItem,
IUnbreakableItem {
    private Multimap<Attribute, AttributeModifier> defaultModifiers = this.creatAttributesFromConfig();
    private static final UUID GUARDIAN_BASE_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("BFF48EEA-FF5B-45B6-88FC-3C8FBBAF78FA");

    public ItemGuardianAxe(Tier tier, Item.Properties properties) {
        super(tier, (float)(-3.0 + EMConfigHandler.COMMON.ITEM.GUARDIAN_AXE_TOOL.attackDamageValue), (float)(-4.0 + EMConfigHandler.COMMON.ITEM.GUARDIAN_AXE_TOOL.attackSpeedValue), properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)EEEABMobs.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockHitResult result = ItemGuardianAxe.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (Objects.equals(hand, InteractionHand.MAIN_HAND) && HitResult.Type.BLOCK == result.m_6662_() && Direction.UP == result.m_82434_()) {
            player.m_21011_(hand, true);
            AbilityCapability.IAbilityCapability capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
            if (capability != null) {
                player.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                EntityCameraShake.cameraShake(level, player.m_20182_(), 8.0f, 0.125f, 0, 20);
                if (!level.f_46443_) {
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.GUARDIAN_AXE_ABILITY_TYPE);
                }
                player.m_36335_().m_41524_((Item)this, (int)((Double)EMConfigHandler.COMMON.ITEM.itemGuardianAxeCoolingTime.get() * 20.0));
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity hitEntity, LivingEntity livingEntity) {
        if (!hitEntity.f_19853_.f_46443_) {
            hitEntity.m_5496_((SoundEvent)SoundInit.GIANT_AXE_HIT.get(), 1.0f, 0.2f);
        }
        return super.m_7579_(itemStack, hitEntity, livingEntity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        if (EMTUtils.SHOW_ITEM_CD) {
            tooltip.add(EMTUtils.itemCoolTime((Double)EMConfigHandler.COMMON.ITEM.itemGuardianAxeCoolingTime.get()));
        }
        int i = (int)(SweepingEdgeEnchantment.m_45193_((int)((Integer)EMConfigHandler.COMMON.ITEM.itemGuardianAxeSweepingLevel.get())) * 100.0f);
        tooltip.addAll(EMTUtils.complexText("item.", 2, ChatFormatting.GRAY, this.m_5524_(), Component.m_237113_((String)(i > 0 ? i + "%" : "1.0")).m_130940_(ChatFormatting.YELLOW)));
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (Enchantments.f_44983_.equals(enchantment)) {
            return (Integer)EMConfigHandler.COMMON.ITEM.itemGuardianAxeSweepingLevel.get();
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.SWORD_SWEEP == toolAction || super.canPerformAction(stack, toolAction);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> creatAttributesFromConfig() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", EMConfigHandler.COMMON.ITEM.GUARDIAN_AXE_TOOL.attackDamageValue - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", EMConfigHandler.COMMON.ITEM.GUARDIAN_AXE_TOOL.attackSpeedValue - 4.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(GUARDIAN_BASE_KNOCKBACK_RESISTANCE_UUID, "Weapon modifier", 0.1, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    @Override
    public void refreshAttributesFromConfig() {
        this.defaultModifiers = this.creatAttributesFromConfig();
    }

    @Override
    public boolean canBreakItem() {
        return false;
    }
}

