/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.integration.curios;

import com.eeeab.eeeabsmobs.sever.integration.curios.CuriosRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public enum ICuriosApi {
    INSTANCE;


    public static boolean isLoaded() {
        return CuriosRegistry.getInstance() != null;
    }

    public boolean isPresentInventory(LivingEntity entity, Item item) {
        Optional optional = CuriosApi.getCuriosHelper().getCuriosHandler(entity).resolve();
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.get();
            return this.findFirstCurio(entity, item, handler.getCurios()).isPresent();
        }
        return false;
    }

    public Optional<SlotResult> findFirstCurio(LivingEntity entity, Item item, Map<String, ICurioStacksHandler> curios) {
        for (String id : curios.keySet()) {
            ICurioStacksHandler stacksHandler = curios.get(id);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (stack.m_41619_() || stack.m_41720_() != item) continue;
                NonNullList renderStates = stacksHandler.getRenders();
                return Optional.of(new SlotResult(new SlotContext(id, entity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
            }
        }
        return Optional.empty();
    }
}

