/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.util;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityFallingBlock;
import com.mojang.math.Quaternion;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class ModEntityUtils {
    private ModEntityUtils() {
    }

    public static boolean isBeneficial(MobEffect effect) {
        return effect != null && (effect.m_19483_() == MobEffectCategory.BENEFICIAL || effect.m_19486_());
    }

    public static boolean isProjectileSource(DamageSource source) {
        Entity entity = source.m_7640_();
        return entity instanceof Projectile || source.m_19360_();
    }

    public static boolean checkDirectEntityConsistency(DamageSource source) {
        return source.m_7639_() == source.m_7640_();
    }

    public static boolean checkTargetComingCloser(LivingEntity entity, LivingEntity target) {
        Vec3 betweenEntitiesVec = entity.m_20182_().m_82546_(target.m_20182_());
        return target.m_20184_().m_82526_(betweenEntitiesVec) > 0.0 && target.m_20184_().m_82556_() > 0.015;
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity, float maxBlockHardness) {
        return ModEntityUtils.canDestroyBlock(world, pos, world.m_8055_(pos), maxBlockHardness, entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, Entity entity) {
        return ModEntityUtils.canDestroyBlock(world, pos, world.m_8055_(pos), 50.0f, entity);
    }

    public static boolean canDestroyBlock(Level world, BlockPos pos, BlockState state, float maxBlockHardness, Entity entity) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness <= maxBlockHardness && !state.m_60795_() && state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static boolean canMobDestroy(Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity);
    }

    public static boolean isTargetFacingAway(Entity referEntity, Entity targetEntity, double tolerance) {
        Vec3 toOtherVec;
        Vec3 lookVec = targetEntity.m_20154_();
        return Math.acos(lookVec.m_82526_(toOtherVec = referEntity.m_20182_().m_82546_(targetEntity.m_20182_()).m_82541_())) > -Math.cos(Math.toRadians(tolerance));
    }

    public static AABB makeAABBWithSize(double x, double y, double z, double yOffset, double sizeX, double sizeY, double sizeZ) {
        return new AABB(x - sizeX / 2.0, (y += yOffset) - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
    }

    public static Vec3 findPounceTargetPoint(Entity attacker, Entity target, double overshoot) {
        double vx = target.m_20185_() - attacker.m_20185_();
        double vz = target.m_20189_() - attacker.m_20189_();
        float angle = (float)Math.atan2(vz, vx);
        double distance = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
        double dx = (double)Mth.m_14089_((float)angle) * (distance + overshoot);
        double dz = (double)Mth.m_14031_((float)angle) * (distance + overshoot);
        return new Vec3(attacker.m_20185_() + dx, target.m_20186_(), attacker.m_20189_() + dz);
    }

    public static Vec3 checkSummonEntityPoint(LivingEntity summoner, double pX, double pZ, double pMinY, double pMaxY) {
        BlockPos blockpos = new BlockPos(pX, pMaxY, pZ);
        boolean flag = false;
        double d0 = 0.0;
        ServerLevel level = (ServerLevel)summoner.f_19853_;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
            if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag) {
            return new Vec3(pX, (double)blockpos.m_123342_() + d0, pZ);
        }
        return new Vec3(pX, pMinY, pZ);
    }

    public static float actualDamageIsCalculatedBasedOnArmor(float damage, float armor, float toughness, float armorReductionMultiplier) {
        float adjustedArmor = armor * armorReductionMultiplier;
        return CombatRules.m_19272_((float)damage, (float)adjustedArmor, (float)toughness);
    }

    public static float getTargetRelativeAngle(LivingEntity entity, LivingEntity target) {
        return ModEntityUtils.getTargetRelativeAngle(entity, target.m_20182_());
    }

    public static float getTargetRelativeAngle(LivingEntity entity, Vec3 position) {
        float entityHitAngle = (float)((Math.atan2(position.m_7094_() - entity.m_20189_(), position.m_7096_() - entity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
        float entityAttackingAngle = entity.f_20883_ % 360.0f;
        if (entityHitAngle < 0.0f) {
            entityHitAngle += 360.0f;
        }
        if (entityAttackingAngle < 0.0f) {
            entityAttackingAngle += 360.0f;
        }
        return entityHitAngle - entityAttackingAngle;
    }

    public static void forceKnockBack(LivingEntity attacker, LivingEntity target, float strength, double ratioX, double ratioZ, boolean optional) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attacker, (float)strength, (double)ratioX, (double)ratioZ);
        if (optional && event.isCanceled()) {
            return;
        }
        strength = optional ? event.getStrength() : strength;
        ratioX = optional ? event.getRatioX() : ratioX;
        double d = ratioZ = optional ? event.getRatioZ() : ratioZ;
        if (optional) {
            strength *= (float)(1.0 - target.m_21133_(Attributes.f_22278_));
        }
        if (strength > 0.0f) {
            attacker.f_19812_ = true;
            if (!optional) {
                target.f_19864_ = true;
            }
            Vec3 vector3d = attacker.m_20184_();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
            target.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, attacker.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)strength) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
        }
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos, float fallingFactor) {
        if (!((Boolean)EMConfigHandler.COMMON.ENTITY.enableSpawnFallingBlock.get()).booleanValue()) {
            return;
        }
        Random random = new Random();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        fallingFactor = random.nextBoolean() ? (fallingFactor += (float)(0.4 + random.nextGaussian() * 0.2)) : (fallingFactor -= (float)Mth.m_14008_((double)(0.2 + random.nextGaussian() * 0.2), (double)0.2, (double)((double)fallingFactor - 0.1)));
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_60767_().m_76334_()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock((Level)level, block, (float)(0.32 + (double)fallingFactor * 0.2));
            fallingBlock.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos, double mx, double mz) {
        if (!((Boolean)EMConfigHandler.COMMON.ENTITY.enableSpawnFallingBlock.get()).booleanValue()) {
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_60767_().m_76334_()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, block, 10);
            fallingBlock.m_5997_(mx, 0.2 + random.m_188583_() * 0.2, mz);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void spawnFallingBlockByPos(ServerLevel level, BlockPos pos, Quaternion quaternionf, int duration, float fallingFactor) {
        if (!((Boolean)EMConfigHandler.COMMON.ENTITY.enableSpawnFallingBlock.get()).booleanValue()) {
            return;
        }
        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
        BlockState block = level.m_8055_(pos);
        BlockState blockAbove = level.m_8055_(abovePos);
        if (!block.m_60795_() && block.m_60796_((BlockGetter)level, pos) && !block.m_155947_() && !blockAbove.m_60767_().m_76334_()) {
            EntityFallingBlock fallingBlock = new EntityFallingBlock((Level)level, block, quaternionf, duration, fallingFactor);
            fallingBlock.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)fallingBlock);
        }
    }

    public static void addEffectStackingAmplifier(@Nullable Entity entity, LivingEntity target, MobEffect mobEffect, int duration, int maxLevel, boolean ambient, boolean visible, boolean showIcon, boolean refreshDuration, boolean force) {
        if (!target.m_21023_(mobEffect)) {
            target.m_7292_(new MobEffectInstance(mobEffect, duration, 0, ambient, visible, showIcon));
        } else {
            MobEffectInstance instance = target.m_21124_(mobEffect);
            if (instance != null) {
                int level = instance.m_19564_();
                if (level < Math.max(maxLevel - 1, 0)) {
                    ++level;
                }
                int n = duration = refreshDuration ? duration : Math.max(instance.m_19557_() / 2, duration);
                if (force) {
                    target.m_147215_(new MobEffectInstance(mobEffect, duration, level, ambient, visible, showIcon), entity);
                } else {
                    target.m_147207_(new MobEffectInstance(mobEffect, duration, level, ambient, visible, showIcon), entity);
                }
            }
        }
    }

    public static boolean advancedBreakBlocks(Level level, LivingEntity entity, float maxBlockHardness, int destroyRangeX, int destroyRangeY, int destroyRangeZ, int offsetY, float offset, boolean dropBlock, boolean playSound) {
        double radians = Math.toRadians(entity.m_146908_() + 90.0f);
        int j1 = Mth.m_14107_((double)entity.m_20186_());
        int i2 = Mth.m_14107_((double)(entity.m_20185_() + Math.cos(radians) * (double)offset));
        int j2 = Mth.m_14107_((double)(entity.m_20189_() + Math.sin(radians) * (double)offset));
        boolean flag = false;
        for (int j = -destroyRangeX; j <= destroyRangeX; ++j) {
            for (int k2 = offsetY; k2 <= destroyRangeY; ++k2) {
                for (int k = -destroyRangeZ; k <= destroyRangeZ; ++k) {
                    int l2 = i2 + j;
                    int l = j1 + k2;
                    int i1 = j2 + k;
                    BlockPos blockpos = new BlockPos(l2, l, i1);
                    BlockState blockstate = level.m_8055_(blockpos);
                    if (!blockstate.canEntityDestroy((BlockGetter)level, blockpos, (Entity)entity) || !ModEntityUtils.canDestroyBlock(level, blockpos, (Entity)entity, maxBlockHardness)) continue;
                    flag = level.m_46953_(blockpos, dropBlock, (Entity)entity) || flag;
                }
            }
        }
        if (flag && playSound) {
            level.m_5898_(null, 1022, entity.m_20183_(), 0);
        }
        return flag;
    }
}

