/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.projectile;

import com.eeeab.eeeabsmobs.client.particle.ParticleDust;
import com.eeeab.eeeabsmobs.client.particle.base.ParticleOrb;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.entity.util.ModMobType;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.eeeab.eeeabsmobs.sever.util.damage.EMDamageSource;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityImmortalShuriken
extends Projectile
implements IEntity {
    private static final double TRACKING_DISTANCE_THRESHOLD = 2.4;
    private static final double RE_FIND_RANGE = 30.0;
    private static final int MAX_ACTIVE = 600;
    private LivingEntity target;
    private UUID targetUUID;
    private boolean closeFlag;
    private double preX;
    private double preY;
    private double preZ;
    private int difficultyLevel;
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.m_135353_(EntityImmortalShuriken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> {
        Player player;
        return entity.m_6336_() != ModMobType.IMMORTAL && !entity.m_6095_().m_204039_(EMTagKey.IMMORTAL_IGNORE_HUNT_TARGETS) && entity.m_6097_() && (entity instanceof Enemy || entity instanceof NeutralMob || entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) && (this.m_37282_() == null || !this.m_37282_().m_7307_((Entity)entity));
    };

    public EntityImmortalShuriken(EntityType<EntityImmortalShuriken> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public EntityImmortalShuriken(Level level, LivingEntity caster, LivingEntity target, int duration) {
        this((EntityType<EntityImmortalShuriken>)((EntityType)EntityInit.IMMORTAL_SHURIKEN.get()), level);
        this.m_5602_((Entity)caster);
        this.target = target;
        this.difficultyLevel = this.f_19853_.m_46791_().m_19028_();
        this.setDuration(duration);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_ || (this.m_37282_() == null || !this.m_37282_().m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            super.m_8119_();
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19853_.f_46443_) {
                Level level;
                HitResult hitresult;
                if (this.checkCanShoot() && (hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_(hitresult);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                    this.m_146870_();
                }
                if (this.target != null) {
                    this.preX = this.target.m_20185_();
                    this.preY = this.target.m_20227_(0.3333333333333333);
                    this.preZ = this.target.m_20189_();
                } else if (this.targetUUID != null && (level = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.target = (LivingEntity)serverLevel.m_8791_(this.targetUUID);
                }
                if (!(this.closeFlag || this.f_19797_ % 5 + this.f_19796_.m_188503_(3) != 0 || this.target != null && this.target.m_6084_())) {
                    LivingEntity entity = this.reFindTarget();
                    if (entity == null) {
                        this.target = null;
                        this.targetUUID = null;
                        this.closeFlag = false;
                    } else {
                        this.target = entity;
                    }
                }
            }
            if (this.checkCanShoot() && this.m_20184_().m_165925_() > 2.5000003E-7 && this.f_19797_ % 5 == 0) {
                this.m_5496_((SoundEvent)SoundInit.IMMORTAL_SHURIKEN_SPIN.get(), 0.15f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.5f + 1.0f);
            }
            this.m_20101_();
            ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
            if (this.f_19797_ > 600) {
                this.m_146870_();
            } else if (!this.f_19853_.f_46443_) {
                if (this.checkCanShoot()) {
                    float distanced = this.distanceToPre();
                    if (this.closeFlag || (double)distanced <= 2.4) {
                        if (!this.closeFlag) {
                            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.03, 0.0));
                        }
                        this.closeFlag = true;
                        return;
                    }
                    Vec3 movement = this.findTargetPoint().m_82490_(0.7);
                    this.m_20256_(movement);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.95));
                }
            } else {
                Vec3 movement = this.m_20184_();
                boolean shoot = this.checkCanShoot() && movement.m_165925_() > 2.5000003E-7;
                double ySpeed = shoot ? -movement.f_82480_ * 0.25 : (double)(0.125f + 0.125f * this.f_19796_.m_188501_());
                double xSpeed = -movement.f_82479_ * 0.25;
                double zSpeed = -movement.f_82481_ * 0.25;
                for (int i = 0; i < (shoot ? 5 : 2); ++i) {
                    double x = this.m_20185_() + this.f_19796_.m_188583_() * 0.2;
                    double y = this.m_20227_(0.3) + this.f_19796_.m_188583_() * 0.1;
                    double z = this.m_20189_() + this.f_19796_.m_188583_() * 0.2;
                    float colorOffset = 0.15f * this.f_19796_.m_188501_();
                    this.f_19853_.m_7106_((ParticleOptions)new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), 0.18f - colorOffset, 0.44f - colorOffset, 0.6f - colorOffset, (float)(5.0 + this.f_19796_.m_188500_() * 5.0), 12, ParticleDust.EnumDustBehavior.SHRINK, 1.0f, true), x, y, z, xSpeed, ySpeed, zSpeed);
                }
                if (this.f_19797_ % 5 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)new ParticleOrb.OrbData(0.08f, 0.12f, 0.17f, 2.0f, 10), this.m_20208_(0.5), this.m_20227_(0.5), this.m_20262_(0.5), xSpeed, ySpeed, xSpeed);
                }
            }
        } else {
            this.m_146870_();
        }
    }

    public void m_7822_(byte id) {
        if (id == 7) {
            Vec3 movement = this.m_20184_();
            double x = this.m_20185_() + movement.f_82479_;
            double y = this.m_20227_(0.3);
            double z = this.m_20189_() + movement.f_82481_;
            this.f_19853_.m_7785_(x, y, z, (SoundEvent)SoundInit.IMMORTAL_SHURIKEN_EXPLODE.get(), SoundSource.NEUTRAL, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f + 0.8f, false);
            ParticleDust.DustData particle1 = new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), 0.18f, 0.44f, 0.6f, 15.0f, 20, ParticleDust.EnumDustBehavior.SHRINK, 0.9f, true);
            ParticleOrb.OrbData particle2 = new ParticleOrb.OrbData(0.08f, 0.12f, 0.17f, 2.0f, 15);
            ModParticleUtils.roundParticleOutburst(this.f_19853_, 8.0, new ParticleOptions[]{particle1, particle2}, x, y, z, 0.25f);
        }
        super.m_7822_(id);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            Entity entity2 = this.m_37282_();
            if (entity2 instanceof EntityImmortal) {
                EntityImmortal immortal = (EntityImmortal)entity2;
                float damageMultiplier = 0.0f;
                MobEffectInstance instance = hitEntity.m_21124_((MobEffect)EffectInit.ERODE_EFFECT.get());
                if (instance != null) {
                    damageMultiplier += (float)(instance.m_19564_() + 1) * 0.08f;
                }
                immortal.doHurtTarget(EMDamageSource.immortalMagicAttack((Entity)this, (Entity)immortal), hitEntity, false, false, false, 0.025f, 0.3f, 1.0f + damageMultiplier);
            } else {
                hitEntity.m_6469_(EMDamageSource.immortalMagicAttack((Entity)this, this.m_37282_()), 2.0f + hitEntity.m_21233_() * 0.025f);
            }
            ModEntityUtils.addEffectStackingAmplifier((Entity)this, hitEntity, (MobEffect)EffectInit.ERODE_EFFECT.get(), 300, 5, true, true, true, true, true);
        } else {
            entity.m_6469_(DamageSource.f_19319_, 11.4514f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DURATION, (Object)20);
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.target != null) {
            compoundTag.m_128362_("target", this.target.m_20148_());
        }
        compoundTag.m_128405_("difficultyLevel", this.difficultyLevel);
        compoundTag.m_128405_("duration", this.getDuration());
        compoundTag.m_128347_("preX", this.preX);
        compoundTag.m_128347_("preY", this.preY);
        compoundTag.m_128347_("preZ", this.preZ);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128403_("target")) {
            this.targetUUID = compoundTag.m_128342_("target");
        }
        this.difficultyLevel = compoundTag.m_128451_("difficultyLevel");
        this.setDuration(compoundTag.m_128451_("duration"));
        this.preX = compoundTag.m_128459_("preX");
        this.preY = compoundTag.m_128459_("preY");
        this.preZ = compoundTag.m_128459_("preZ");
    }

    private boolean checkCanShoot() {
        return this.f_19797_ > this.getDuration();
    }

    @Nullable
    private LivingEntity reFindTarget() {
        return this.f_19853_.m_6443_(LivingEntity.class, ModEntityUtils.makeAABBWithSize(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 30.0, 30.0, 30.0), this.LIVING_ENTITY_SELECTOR).stream().findFirst().orElse(null);
    }

    public boolean m_5603_(Entity entity) {
        if (!super.m_5603_(entity) || entity == this.m_37282_() || entity instanceof EntityAbsImmortal && ((Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get()).booleanValue()) {
            return false;
        }
        return this.m_37282_() == null || !this.m_37282_().m_20365_(entity);
    }

    private float distanceToPre() {
        float d0 = (float)(this.m_20185_() - this.preX);
        float d1 = (float)(this.m_20186_() - this.preY);
        float d2 = (float)(this.m_20189_() - this.preZ);
        return Mth.m_14116_((float)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    private Vec3 findTargetPoint() {
        if (this.target == null) {
            return Vec3.f_82478_;
        }
        double d1 = this.preX - this.m_20185_();
        double d2 = this.preY - this.m_20186_();
        double d3 = this.preZ - this.m_20189_();
        double d0 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        return new Vec3(d1, d2 + d0, d3).m_82541_();
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DATA_DURATION, (Object)duration);
    }
}

