/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.eeeabsmobs.sever.entity.effects.EntityImmortalLaser;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityImmortalShuriken;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ImmortalMagic {
    public static void spawnImmortalLaser(LivingEntity caster, int count, float totalOffset, int duration, Vec3 spawnPos) {
        if (count <= 0) {
            count = 1;
        }
        Vec3 looking = caster.m_20154_();
        float angleStep = totalOffset / (float)(count + 1);
        for (int i = 0; i < count; ++i) {
            float angle = -totalOffset / 2.0f + (float)(i + 1) * angleStep;
            Vec3 vec3 = looking.m_82524_(angle);
            float f0 = (float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_);
            EntityImmortalLaser laser = new EntityImmortalLaser(caster.f_19853_, caster, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, f0, duration, i == 0);
            caster.f_19853_.m_7967_((Entity)laser);
        }
    }

    public static void spawnShurikenWithTargets(LivingEntity caster, int count, List<LivingEntity> entities, double radius, double angle, boolean flat) {
        if (count <= 0) {
            count = 1;
        }
        float angleRange = (float)Math.toRadians(angle);
        LivingEntity[] targets = new LivingEntity[count];
        ImmortalMagic.assignTargets(count, entities, targets);
        for (int i = 0; i < count; ++i) {
            float divideAngle = ((float)i + 0.5f) * angleRange / (float)count - angleRange / 2.0f;
            float yaw = caster.m_146908_();
            float pitch = caster.m_146909_();
            double x = caster.m_20185_();
            double y = caster.m_20227_(0.5);
            double z = caster.m_20189_();
            int duration = 15 + i + i * 15;
            if (count > 6) {
                duration = 10 + i + i * 10;
            }
            if (flat) {
                double motionX = Math.cos(divideAngle) * radius;
                double motionY = Math.cos(Math.toRadians(pitch)) * radius;
                double motionZ = Math.sin(divideAngle) * radius;
                ImmortalMagic.spawnShuriken(caster, targets[i], x, y, z, motionX, motionY, motionZ, 0.4f, duration);
                continue;
            }
            double cosYaw = Math.cos(Math.toRadians(yaw));
            double sinYaw = Math.sin(Math.toRadians(yaw));
            double xInPlane = Math.sin(divideAngle) * radius;
            double zInPlane = Math.sin(Math.toRadians(pitch)) * radius;
            double motionX = xInPlane * cosYaw - zInPlane * sinYaw;
            double motionY = Math.cos(divideAngle) * radius;
            double motionZ = xInPlane * sinYaw + zInPlane * cosYaw;
            ImmortalMagic.spawnShuriken(caster, targets[i], x + motionX, y + motionY, z + motionZ, motionX, motionY, motionZ, 0.2f, duration);
        }
    }

    public static void spawnShuriken(LivingEntity caster, LivingEntity target, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, float velocity, int duration) {
        EntityImmortalShuriken shuriken = new EntityImmortalShuriken(caster.f_19853_, caster, target, duration);
        shuriken.m_6034_(posX, posY, posZ);
        shuriken.m_6686_(motionX, motionY, motionZ, velocity, 3.0f);
        caster.f_19853_.m_7967_((Entity)shuriken);
    }

    public static void assignTargets(int count, List<LivingEntity> entities, LivingEntity[] targets) {
        if (entities.isEmpty()) {
            return;
        }
        int size = entities.size();
        int distribution = count / size;
        int remainder = count % size;
        int j = 0;
        for (int i = 0; i < size && j < count; ++i) {
            int start = i * distribution + Math.min(i, remainder);
            int end = (i + 1) * distribution + Math.min(i + 1, remainder);
            for (int k = start; k < end && j < count; ++k, ++j) {
                targets[j] = entities.get(i);
            }
        }
        if (size == 1) {
            Arrays.fill(targets, 0, count, entities.get(0));
        }
    }
}

