/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationSimpleAI;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortalSkeleton;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalSkeleton;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityImmortalKnight
extends EntityAbsImmortalSkeleton
implements IEntity {
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)3, (int)5);
    private static final UniformInt ROAR_INTERVAL = TimeUtil.m_145020_((int)15, (int)30);
    private int ticksUntilNextAlert;
    private int nextBoostTick;

    public EntityImmortalKnight(EntityType<? extends EntityImmortalKnight> type, Level level) {
        super((EntityType<? extends EntityAbsImmortal>)type, level);
        this.active = true;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.88f;
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, (Goal)new AnimationSimpleAI<EntityImmortalKnight>(this, () -> this.roarAnimation, EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP)){

            public void m_8037_() {
                LivingEntity target;
                super.m_8037_();
                if (EntityImmortalKnight.this.getAnimationTick() == 8) {
                    EntityImmortalKnight.this.m_5496_((SoundEvent)SoundInit.IMMORTAL_SKELETON_ROAR.get(), 0.8f, (((EntityImmortalKnight)this.entity).f_19796_.m_188501_() - ((EntityImmortalKnight)this.entity).f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                if ((target = EntityImmortalKnight.this.m_5448_()) != null) {
                    ((EntityImmortalKnight)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
            }

            @Override
            public void m_8041_() {
                ((EntityImmortalKnight)this.entity).invigorateOthers();
                super.m_8041_();
            }
        });
        super.registerCustomGoals();
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_KNIGHT.combatConfig;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public void m_8119_() {
        boolean flag;
        super.m_8119_();
        boolean bl = flag = this.f_19796_.m_188501_() < 0.1f + this.f_19853_.m_6436_(this.m_20183_()).m_19057_();
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.isActive() && this.m_5448_() != null && this.isNoAnimation() && this.f_19797_ % 60 == 0 && this.nextBoostTick == 0 && flag) {
            this.playAnimation(this.roarAnimation);
            this.nextBoostTick = ROAR_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    @Override
    protected void m_8024_() {
        if (this.m_5448_() != null) {
            this.maybeAlertOthers();
            if (this.nextBoostTick > 0) {
                --this.nextBoostTick;
            }
        }
        super.m_8024_();
    }

    private void maybeAlertOthers() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            LivingEntity target = this.m_5448_();
            if (target != null && this.m_21574_().m_148306_((Entity)target)) {
                this.alertOthers();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    private void invigorateOthers() {
        double range = this.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(range, 5.0, range);
        if (this.m_5448_() != null) {
            this.f_19853_.m_6443_(EntityAbsImmortalSkeleton.class, aabb, EntitySelector.f_20408_).stream().filter(skeleton -> !(skeleton instanceof EntityImmortalKnight)).forEach(skeleton -> skeleton.m_147207_(new MobEffectInstance(MobEffects.f_19600_, 200, 0), (Entity)this));
            this.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 200, 0), (Entity)this);
        }
    }

    private void alertOthers() {
        double range = this.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(range, 5.0, range);
        if (this.m_5448_() != null) {
            this.f_19853_.m_6443_(EntityImmortalSkeleton.class, aabb, EntitySelector.f_20408_).stream().filter(immortalSkeleton -> immortalSkeleton.m_5448_() == null && !this.m_7307_((Entity)this.m_5448_())).forEach(immortalSkeleton -> immortalSkeleton.m_6710_(this.m_5448_()));
        }
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        if (this.m_5448_() == null && entity != null) {
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
        if (entity instanceof Player) {
            this.m_6598_((Player)entity);
        }
        super.m_6710_(entity);
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.f_19853_.f_46443_) {
            LivingEntity livingEntity;
            Entity entity;
            if (this.m_5448_() == null && (entity = source.m_7639_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() != this.m_6336_()) {
                this.m_6703_(livingEntity);
            }
            if (ModEntityUtils.isProjectileSource(source)) {
                damage *= 0.5f;
            }
            return super.m_6469_(source, damage);
        }
        return false;
    }

    @Override
    protected int getCareerId(RandomSource random) {
        return EntityAbsImmortalSkeleton.CareerType.KNIGHT.id;
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyIn) {
        this.m_8061_(EquipmentSlot.MAINHAND, randomSource.m_188501_() < 0.2f ? EntityAbsImmortalSkeleton.CareerType.KNIGHT.holdItems[0].m_7968_() : EntityAbsImmortalSkeleton.CareerType.KNIGHT.holdItems[1].m_7968_());
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        if (randomSource.m_188501_() < 0.2f) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
            this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity, float damageMultiplier, float knockBackMultiplier, boolean canDisableShield) {
        if (!super.doHurtTarget(entity, damageMultiplier, knockBackMultiplier, canDisableShield)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity;
            targetEntity.m_147207_(new MobEffectInstance((MobEffect)EffectInit.ERODE_EFFECT.get(), 200), (Entity)this);
        }
        return true;
    }

    @Override
    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        AbstractArrow arrow = super.getArrow(arrowStack, distanceFactor);
        if (arrow instanceof Arrow) {
            ((Arrow)arrow).m_36870_(new MobEffectInstance((MobEffect)EffectInit.ERODE_EFFECT.get(), 200));
        }
        return arrow;
    }
}

