/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.guling;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.ai.AnimationMeleePlusAI;
import com.eeeab.animate.server.ai.AnimationSimpleAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationDeactivate;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.ai.animation.AnimationRepel;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.particle.ParticleDust;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.control.EMBodyRotationControl;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.navigate.EMPathNavigateGround;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityElectromagnetic;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityGrenade;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityAbsGuling;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityGulingSentinelHeavy
extends EntityAbsGuling
implements IEntity,
GlowEntity,
RangedAttackMob {
    public final Animation dieAnimation = Animation.create(60);
    public final Animation activeAnimation = Animation.create(30);
    public final Animation deactivateAnimation = Animation.create(30);
    public final Animation attackAnimationLeft = Animation.create(25);
    public final Animation attackAnimationRight = Animation.create(25);
    public final Animation smashAttackAnimation = Animation.create(30);
    public final Animation rangeAttackAnimation = Animation.create(100);
    public final Animation rangeAttackStopAnimation = Animation.create(10);
    public final Animation electromagneticAnimation = Animation.create(100);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.activeAnimation, this.deactivateAnimation, this.attackAnimationLeft, this.attackAnimationRight, this.smashAttackAnimation, this.rangeAttackAnimation, this.rangeAttackStopAnimation, this.electromagneticAnimation};
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE = SynchedEntityData.m_135353_(EntityGulingSentinelHeavy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ALWAYS_ACTIVE = SynchedEntityData.m_135353_(EntityGulingSentinelHeavy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int deactivateTick;
    private int smashAttackTick;
    private int rangeAttackTick;
    private int electromagneticTick;
    public final ControlledAnimation glowControlled = new ControlledAnimation(10);
    public final ControlledAnimation hotControlled = new ControlledAnimation(20);
    public final ControlledAnimation electromagneticConControlled = new ControlledAnimation(20);
    private static final int SMASH_ATTACK_TICK = 370;
    private static final int ELECTROMAGNETIC_TICK = 350;
    private static final int RANGE_ATTACK_TICK = 400;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] hand;

    public EntityGulingSentinelHeavy(EntityType<? extends EntityAbsGuling> type, Level level) {
        super((EntityType<? extends EEEABMobLibrary>)type, level);
        this.active = false;
        this.dropAfterDeathAnim = false;
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        if (this.f_19853_.f_46443_) {
            this.hand = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_ELITE;
    }

    public float getStepHeight() {
        return 1.5f;
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    @Override
    protected boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.isActive();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.85f;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new EMBodyRotationControl((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new EMPathNavigateGround(this, level);
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.GULING.GULING_SENTINEL_HEAVY.combatConfig;
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (!this.f_19853_.f_46443_) {
            if (animation == this.smashAttackAnimation) {
                this.smashAttackTick = this.getCoolingTimerUtil(370, 320, 0.5f);
            } else if (animation == this.rangeAttackAnimation) {
                this.rangeAttackTick = this.getCoolingTimerUtil(400, 350, 0.5f);
            } else if (animation == this.electromagneticAnimation) {
                this.electromagneticTick = this.getCoolingTimerUtil(350, 300, 0.5f);
            }
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityAbsGuling.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, 0, false, false, golem -> !(golem instanceof Shulker)));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal(this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && EntityGulingSentinelHeavy.this.isActive();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new EMLookAtGoal(this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && EntityGulingSentinelHeavy.this.isActive();
            }
        });
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationDie<EntityGulingSentinelHeavy>(this));
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityGulingSentinelHeavy>(this, () -> this.activeAnimation));
        this.f_21345_.m_25352_(1, new AnimationDeactivate<EntityGulingSentinelHeavy>(this, () -> this.deactivateAnimation));
        this.f_21345_.m_25352_(1, (Goal)new GSHMeleeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GSHRangeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GSHElectromagneticAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AnimationRepel<EntityGulingSentinelHeavy>(this, () -> this.smashAttackAnimation, 7.0f, 18, 1.5f, 1.5f, true){

            @Override
            public void m_8037_() {
                ((EntityGulingSentinelHeavy)this.entity).m_20334_(0.0, ((EntityGulingSentinelHeavy)this.entity).m_20096_() && !((EntityGulingSentinelHeavy)this.entity).m_20068_() ? (double)-0.01f : ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, 0.0);
                LivingEntity target = ((EntityGulingSentinelHeavy)this.entity).m_5448_();
                if (target != null) {
                    if (((EntityGulingSentinelHeavy)this.entity).getAnimationTick() < 15) {
                        ((EntityGulingSentinelHeavy)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    } else {
                        ((EntityGulingSentinelHeavy)this.entity).m_146922_(((EntityGulingSentinelHeavy)this.entity).f_19859_);
                    }
                }
                super.m_8037_();
            }

            @Override
            protected void onHit(LivingEntity entity) {
                if (!((EntityGulingSentinelHeavy)this.entity).hotControlled.isStop()) {
                    entity.m_20254_(3);
                }
            }
        });
        this.f_21345_.m_25352_(1, new AnimationSimpleAI<EntityGulingSentinelHeavy>(this, () -> this.rangeAttackAnimation));
        this.f_21345_.m_25352_(2, new AnimationMeleePlusAI<EntityGulingSentinelHeavy>(this, 1.0, 20, () -> this.attackAnimationLeft, () -> this.attackAnimationRight));
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        Animation animation = this.getAnimation();
        return !this.isActive() || animation == this.activeAnimation || animation == this.deactivateAnimation || super.m_6673_(damageSource);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.glowControlled.updatePrevTimer();
        this.hotControlled.updatePrevTimer();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
                this.m_6710_(null);
            }
            if (!this.m_21525_() && !this.isActive()) {
                if (((Boolean)EMConfigHandler.COMMON.MOB.GULING.GULING_SENTINEL_HEAVY.enableNonCombatHeal.get()).booleanValue()) {
                    this.m_5634_(0.5f);
                }
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                this.f_20885_ = this.f_20883_ = this.m_146908_();
            }
            if (this.isAlwaysActive()) {
                this.setActive(true);
                this.active = true;
                this.deactivateTick = 0;
            } else if (!this.m_21525_() && this.isNoAnimation()) {
                if (!this.isActive() && this.m_5448_() != null && this.targetDistance <= 12.0f) {
                    this.m_216990_((SoundEvent)SoundInit.GSH_FRICTION.get());
                    this.playAnimation(this.activeAnimation);
                    this.setActive(true);
                }
                if (this.isActive() && this.m_6084_() && this.m_5448_() == null && this.deactivateTick >= 300) {
                    this.m_216990_((SoundEvent)SoundInit.GSH_FRICTION.get());
                    this.playAnimation(this.deactivateAnimation);
                    this.setActive(false);
                }
            }
            if (this.checkCanAttack() && this.smashAttackTick <= 0 && (this.targetDistance <= 6.5f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, this.m_5448_()) || this.targetDistance < 6.0f)) {
                this.playAnimation(this.smashAttackAnimation);
            }
            if (this.checkCanAttack() && this.rangeAttackTick <= 0 && Math.pow(this.targetDistance, 2.0) > this.m_142593_(this.m_5448_()) + 5.0) {
                this.playAnimation(this.rangeAttackAnimation);
            }
            if (this.checkCanAttack() && this.electromagneticTick <= 0 && (this.getHealthPercentage() <= 80.0f || this.f_19797_ > 1200) && this.targetDistance < 6.5f) {
                this.playAnimation(this.electromagneticAnimation);
            }
        }
        this.pushEntitiesAway(1.8f, this.m_20206_(), 1.8f, 1.8f);
        int tick = this.getAnimationTick();
        if (this.getAnimation() == this.smashAttackAnimation) {
            if (tick == 1) {
                this.m_5496_((SoundEvent)SoundInit.GSH_PRE_ATTACK.get(), 0.5f, this.m_6100_());
            } else if (tick == 18) {
                this.m_5496_(SoundEvents.f_11913_, 1.25f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
                BlockState block = this.f_19853_.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_())));
                ModParticleUtils.annularParticleOutburstOnGround(this.f_19853_, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), (LivingEntity)this, 16, 8, 3.0, 0.5, 0.0, 0.1);
                if (!this.hotControlled.isStop()) {
                    ModParticleUtils.annularParticleOutburstOnGround(this.f_19853_, (ParticleOptions)ParticleTypes.f_123745_, (LivingEntity)this, 6, 6, 2.5, 0.5, 0.0, 0.15);
                }
            }
        } else if (this.getAnimation() == this.rangeAttackAnimation) {
            if (tick >= 20 && tick % 20 == 0) {
                this.hotControlled.increaseTimer(5);
            }
        } else if (this.getAnimation() == this.attackAnimationLeft || this.getAnimation() == this.attackAnimationRight) {
            if (tick == 9 || tick == 17) {
                this.m_5496_((SoundEvent)SoundInit.GSH_ATTACK.get(), this.m_6121_(), this.m_6100_());
            }
        } else if (this.getAnimation() == this.dieAnimation) {
            if (tick <= 15) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.m_21391_((Entity)target, 30.0f, 30.0f);
                    this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
            } else {
                this.m_146922_(this.f_19859_);
            }
            if (tick == 38) {
                float range = 5.0f;
                float attackArc = 120.0f;
                List<LivingEntity> entities = this.getNearByLivingEntities(range - 0.5f, 3.0, range - 0.5f, range - 0.5f);
                for (LivingEntity hitEntity : entities) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, hitEntity);
                    float entityHitDistance = (float)Math.sqrt((hitEntity.m_20189_() - this.m_20189_()) * (hitEntity.m_20189_() - this.m_20189_()) + (hitEntity.m_20185_() - this.m_20185_()) * (hitEntity.m_20185_() - this.m_20185_())) - hitEntity.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= range - 0.5f && entityRelativeAngle <= attackArc / 2.0f && entityRelativeAngle >= -attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + attackArc / 2.0f)) continue;
                    this.gshHurtTarget(hitEntity, 3.0f, true);
                    double ratioX = Math.sin(this.m_146908_() * ((float)Math.PI / 180));
                    double ratioZ = -Math.cos(this.m_146908_() * ((float)Math.PI / 180));
                    ModEntityUtils.forceKnockBack((LivingEntity)this, hitEntity, 0.5f, ratioX, ratioZ, true);
                }
            } else if (tick == 39) {
                boolean hot = !this.hotControlled.isStop();
                EntityCameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.125f, 0, 10);
                if (this.f_19853_.f_46443_) {
                    ParticleDust.DustData dustData = new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), 0.24f, 0.24f, 0.24f, 40.0f, 25, ParticleDust.EnumDustBehavior.GROW, 1.0f);
                    ParticleOptions[] options = hot ? new ParticleOptions[]{dustData, ParticleTypes.f_123745_} : new ParticleOptions[]{dustData};
                    ModParticleUtils.annularParticleOutburst(this.f_19853_, 15.0, options, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.5, 0.1);
                }
            }
        } else if (this.getAnimation() == this.electromagneticAnimation) {
            this.m_20334_(0.0, this.m_20096_() && !this.m_20068_() ? (double)-0.01f : this.m_20184_().f_82480_, 0.0);
            if (tick == 1) {
                this.m_5496_((SoundEvent)SoundInit.GSH_PRE_ATTACK.get(), 0.75f, 0.5f);
            } else if (tick > 20 && tick < 90) {
                this.electromagneticConControlled.increaseTimer();
                if (tick == 42 || tick == 64 || tick == 86) {
                    this.m_5496_((SoundEvent)SoundInit.GSH_ELECTROMAGNETIC.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.electromagneticConControlled.decreaseTimer(10);
                }
            } else {
                this.electromagneticConControlled.decreaseTimer(2);
            }
        }
        if (this.isActive() && this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            this.doWalkEffect(1);
        }
        if (this.isActive() && this.m_6084_()) {
            if (this.f_19853_.f_46443_ && this.f_19797_ % 2 == 0 && this.f_19796_.m_188503_(100) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleInit.GUARDIAN_SPARK.get(), this.m_20208_(1.5), this.m_20227_(0.5), this.m_20262_(1.5), 0.0, 0.07, 0.0);
            }
            if (this.f_19853_.f_46443_ && !this.hotControlled.isStop() && this.hand != null && this.hand.length > 0) {
                Vec3 left = this.hand[0];
                Vec3 right = this.hand[1];
                if (left != null && right != null) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    if (this.f_19796_.m_188503_(100) == 0) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, left.f_82479_, left.f_82480_, left.f_82481_, d0, d1, d2);
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, right.f_82479_, right.f_82480_, right.f_82481_, d0, d1, d2);
                    } else {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, left.f_82479_, left.f_82480_, left.f_82481_, d0, d1, d2);
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, right.f_82479_, right.f_82480_, right.f_82481_, d0, d1, d2);
                    }
                }
            }
        }
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (this.f_19853_.f_46443_ && (double)speed > 0.05 && this.isActive() && !this.m_20067_() && this.frame % 10 == 1 && (this.isNoAnimation() || this.getAnimation() == this.rangeAttackAnimation)) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.GSH_STEP.get(), this.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.rangeAttackTick > 0) {
                --this.rangeAttackTick;
            }
            if (this.smashAttackTick > 0) {
                --this.smashAttackTick;
            }
            if (this.electromagneticTick > 0) {
                --this.electromagneticTick;
            }
            if (this.isActive() && !this.isAlwaysActive()) {
                if (this.m_5448_() == null || this.f_19797_ % 2 == 0 && !this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    ++this.deactivateTick;
                } else if (this.deactivateTick > 0) {
                    --this.deactivateTick;
                }
            }
        }
        this.glowControlled.incrementOrDecreaseTimer(this.isGlow());
        if (this.getAnimation() != this.rangeAttackAnimation && this.f_19797_ % 10 == 0) {
            this.hotControlled.decreaseTimer();
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (source != DamageSource.f_19317_ && source != DamageSource.f_19318_) {
            damage = this.getAnimation() == this.electromagneticAnimation ? (damage *= 0.2f) : (damage *= 0.8f);
        }
        return super.m_6469_(source, damage);
    }

    protected void m_7472_(DamageSource source, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(source, pLooting, pRecentlyHit);
        ItemEntity itementity = this.m_19998_((ItemLike)ItemInit.ANCIENT_DRIVE_CRYSTAL.get());
        if (itementity != null) {
            itementity.m_32064_();
            itementity.m_146915_(true);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_ALWAYS_ACTIVE, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)compound.m_128471_("isActive"));
        this.f_19804_.m_135381_(DATA_ALWAYS_ACTIVE, (Object)compound.m_128471_("isAlwaysActive"));
        this.active = this.isActive();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isActive", ((Boolean)this.f_19804_.m_135370_(DATA_ACTIVE)).booleanValue());
        compound.m_128379_("isAlwaysActive", ((Boolean)this.f_19804_.m_135370_(DATA_ALWAYS_ACTIVE)).booleanValue());
    }

    private boolean checkCanAttack() {
        return !this.m_21525_() && this.isActive() && this.isNoAnimation() && this.m_5448_() != null && this.m_6779_(this.m_5448_());
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.GSH_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundInit.GSH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.GSH_IDLE.get();
    }

    public void m_8032_() {
        if (this.isActive() && this.getAnimation() != this.activeAnimation) {
            super.m_8032_();
        }
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.125).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public boolean isGlow() {
        return this.isActive() && this.m_21223_() > 0.0f;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20227_(-0.5) - this.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.12f;
        this.m_216990_((SoundEvent)SoundInit.LAUNCH_GRENADE.get());
        for (int i = 1; i <= 2; ++i) {
            double yBodyRadians = Math.toRadians(this.f_20883_ + (float)(180 * (i - 1)));
            EntityGrenade grenade = new EntityGrenade(this.f_19853_, (LivingEntity)this);
            grenade.shoot(d1, d2 + d4, d3, velocity, 3.0f);
            Vec3 vec3 = this.m_20182_().m_82549_(this.m_20154_());
            grenade.m_6034_(vec3.f_82479_ + (double)(this.m_20205_() * 0.82f) * Math.cos(yBodyRadians), this.m_20227_(0.48), vec3.f_82481_ + (double)(this.m_20205_() * 0.82f) * Math.sin(yBodyRadians));
            this.f_19853_.m_7967_((Entity)grenade);
        }
    }

    public void gshHurtTarget(LivingEntity hitEntity, float damageMultiplier, boolean disableShield) {
        Player player;
        boolean hot;
        double baseDamage = this.m_21133_(Attributes.f_22281_);
        boolean flag = hitEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(baseDamage * (double)damageMultiplier));
        boolean bl = hot = !this.hotControlled.isStop();
        if (flag) {
            hitEntity.f_19802_ = 0;
            if (hot) {
                hitEntity.m_20254_(5);
            }
        } else if (disableShield && hitEntity instanceof Player && (player = (Player)hitEntity).m_21254_()) {
            player.m_36384_(true);
        }
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)isActive);
        this.deactivateTick = 0;
    }

    public boolean isAlwaysActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ALWAYS_ACTIVE);
    }

    public void setAlwaysActive(boolean alwaysActive) {
        this.f_19804_.m_135381_(DATA_ALWAYS_ACTIVE, (Object)alwaysActive);
    }

    static class GSHMeleeAttackGoal
    extends AnimationAI<EntityGulingSentinelHeavy> {
        protected GSHMeleeAttackGoal(EntityGulingSentinelHeavy entity) {
            super(entity);
        }

        @Override
        protected boolean test(Animation animation) {
            return animation == ((EntityGulingSentinelHeavy)this.entity).attackAnimationLeft || animation == ((EntityGulingSentinelHeavy)this.entity).attackAnimationRight;
        }

        public void m_8037_() {
            block7: {
                int tick;
                block6: {
                    tick = ((EntityGulingSentinelHeavy)this.entity).getAnimationTick();
                    LivingEntity target = ((EntityGulingSentinelHeavy)this.entity).m_5448_();
                    ((EntityGulingSentinelHeavy)this.entity).m_20334_(0.0, ((EntityGulingSentinelHeavy)this.entity).m_20096_() && !((EntityGulingSentinelHeavy)this.entity).m_20068_() ? (double)-0.01f : ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, 0.0);
                    if ((tick >= 15 || tick <= 10) && target != null) {
                        ((EntityGulingSentinelHeavy)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    } else {
                        ((EntityGulingSentinelHeavy)this.entity).m_146922_(((EntityGulingSentinelHeavy)this.entity).f_19859_);
                    }
                    if (tick != 10) break block6;
                    float attackArc = 30.0f;
                    float range = 6.0f;
                    List<LivingEntity> entities = ((EntityGulingSentinelHeavy)this.entity).getNearByLivingEntities(6.0, ((EntityGulingSentinelHeavy)this.entity).m_20206_(), 6.0, 6.0);
                    for (LivingEntity livingEntity : entities) {
                        float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, livingEntity);
                        float entityHitDistance = (float)Math.sqrt((livingEntity.m_20189_() - ((EntityGulingSentinelHeavy)this.entity).m_20189_()) * (livingEntity.m_20189_() - ((EntityGulingSentinelHeavy)this.entity).m_20189_()) + (livingEntity.m_20185_() - ((EntityGulingSentinelHeavy)this.entity).m_20185_()) * (livingEntity.m_20185_() - ((EntityGulingSentinelHeavy)this.entity).m_20185_())) - livingEntity.m_20205_() / 2.0f;
                        if (!(entityHitDistance <= 6.0f && entityRelativeAngle <= 15.0f && entityRelativeAngle >= -15.0f || entityRelativeAngle >= 345.0f) && !(entityRelativeAngle <= -345.0f)) continue;
                        ((EntityGulingSentinelHeavy)this.entity).gshHurtTarget(livingEntity, 1.0f, true);
                        double ratioX = -Math.sin(((EntityGulingSentinelHeavy)this.entity).f_20883_ * ((float)Math.PI / 180));
                        double ratioZ = Math.cos(((EntityGulingSentinelHeavy)this.entity).f_20883_ * ((float)Math.PI / 180));
                        ModEntityUtils.forceKnockBack((LivingEntity)this.entity, livingEntity, 0.8f, ratioX, ratioZ, true);
                    }
                    break block7;
                }
                if (tick != 18) break block7;
                float leftArc = 45.0f;
                float rightArc = 45.0f;
                if (((EntityGulingSentinelHeavy)this.entity).getAnimation() == ((EntityGulingSentinelHeavy)this.entity).attackAnimationRight) {
                    rightArc = 90.0f;
                } else {
                    leftArc = 90.0f;
                }
                float range = 4.5f;
                List<LivingEntity> entities = ((EntityGulingSentinelHeavy)this.entity).getNearByLivingEntities(4.5);
                for (LivingEntity livingEntity : entities) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, livingEntity);
                    float entityHitDistance = (float)Math.sqrt((livingEntity.m_20189_() - ((EntityGulingSentinelHeavy)this.entity).m_20189_()) * (livingEntity.m_20189_() - ((EntityGulingSentinelHeavy)this.entity).m_20189_()) + (livingEntity.m_20185_() - ((EntityGulingSentinelHeavy)this.entity).m_20185_()) * (livingEntity.m_20185_() - ((EntityGulingSentinelHeavy)this.entity).m_20185_())) - livingEntity.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= 4.5f && entityRelativeAngle <= rightArc / 2.0f && entityRelativeAngle >= -leftArc / 2.0f || entityRelativeAngle >= 315.0f) && !(entityRelativeAngle <= -315.0f)) continue;
                    ((EntityGulingSentinelHeavy)this.entity).gshHurtTarget(livingEntity, 1.25f, false);
                    ModEntityUtils.forceKnockBack((LivingEntity)this.entity, livingEntity, 0.25f, ((EntityGulingSentinelHeavy)this.entity).m_20185_() - livingEntity.m_20185_(), ((EntityGulingSentinelHeavy)this.entity).m_20189_() - livingEntity.m_20189_(), true);
                }
            }
        }
    }

    static class GSHRangeAttackGoal
    extends AnimationAI<EntityGulingSentinelHeavy> {
        private int lostTargetDelay;

        public GSHRangeAttackGoal(EntityGulingSentinelHeavy entity) {
            super(entity);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.lostTargetDelay = 0;
        }

        @Override
        protected boolean test(Animation animation) {
            return animation == ((EntityGulingSentinelHeavy)this.entity).rangeAttackAnimation;
        }

        public void m_8037_() {
            LivingEntity target = ((EntityGulingSentinelHeavy)this.entity).m_5448_();
            ((EntityGulingSentinelHeavy)this.entity).m_146922_(((EntityGulingSentinelHeavy)this.entity).f_20883_);
            if (this.lostTargetDelay > 0) {
                --this.lostTargetDelay;
            }
            if (target != null && target.m_6084_() && ((EntityGulingSentinelHeavy)this.entity).m_6779_(target) && this.lostTargetDelay < 10) {
                if (!((EntityGulingSentinelHeavy)this.entity).m_21574_().m_148306_((Entity)target)) {
                    this.lostTargetDelay += 2;
                }
            } else {
                ((EntityGulingSentinelHeavy)this.entity).playAnimation(((EntityGulingSentinelHeavy)this.entity).rangeAttackStopAnimation);
                return;
            }
            this.moveGoal(target);
            ((EntityGulingSentinelHeavy)this.entity).m_21563_().m_24960_((Entity)target, 15.0f, 15.0f);
            ((EntityGulingSentinelHeavy)this.entity).m_21391_((Entity)target, 15.0f, 15.0f);
            int tick = ((EntityGulingSentinelHeavy)this.entity).getAnimationTick();
            if (tick % 20 == 0 && tick > 10) {
                ((EntityGulingSentinelHeavy)this.entity).m_6504_(target, 1.0f);
            }
        }

        private void moveGoal(LivingEntity target) {
            double moveSpeed = ((EntityGulingSentinelHeavy)this.entity).m_21133_(Attributes.f_22279_) * 0.75;
            double distance = ((EntityGulingSentinelHeavy)this.entity).m_20280_((Entity)target);
            if (distance < Math.pow(6.0, 2.0)) {
                Vec3 vec3 = GSHRangeAttackGoal.findTargetPoint((Entity)target, (Entity)this.entity);
                ((EntityGulingSentinelHeavy)this.entity).m_20334_(vec3.f_82479_ * moveSpeed, ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, vec3.f_82481_ * moveSpeed);
            } else if (distance > Math.pow(12.0, 2.0)) {
                Vec3 vec3 = GSHRangeAttackGoal.findTargetPoint((Entity)this.entity, (Entity)target);
                ((EntityGulingSentinelHeavy)this.entity).m_20334_(vec3.f_82479_ * moveSpeed, ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, vec3.f_82481_ * moveSpeed);
            } else {
                ((EntityGulingSentinelHeavy)this.entity).m_20334_(0.0, ((EntityGulingSentinelHeavy)this.entity).m_20096_() && !((EntityGulingSentinelHeavy)this.entity).m_20068_() ? (double)-0.01f : ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, 0.0);
            }
        }

        public static Vec3 findTargetPoint(Entity entity, Entity target) {
            Vec3 vec3 = target.m_20182_();
            return new Vec3(vec3.f_82479_ - entity.m_20185_(), 0.0, vec3.f_82481_ - entity.m_20189_()).m_82541_();
        }
    }

    static class GSHElectromagneticAttackGoal
    extends AnimationAI<EntityGulingSentinelHeavy> {
        public GSHElectromagneticAttackGoal(EntityGulingSentinelHeavy entity) {
            super(entity);
        }

        @Override
        protected boolean test(Animation animation) {
            return animation == ((EntityGulingSentinelHeavy)this.entity).electromagneticAnimation;
        }

        public void m_8037_() {
            int tick = ((EntityGulingSentinelHeavy)this.entity).getAnimationTick();
            ((EntityGulingSentinelHeavy)this.entity).m_20334_(0.0, ((EntityGulingSentinelHeavy)this.entity).m_20096_() && !((EntityGulingSentinelHeavy)this.entity).m_20068_() ? (double)-0.01f : ((EntityGulingSentinelHeavy)this.entity).m_20184_().f_82480_, 0.0);
            if (!(((EntityGulingSentinelHeavy)this.entity).f_19853_.f_46443_ || tick != 43 && tick != 65 && tick != 87)) {
                int count = 10;
                float offset = (float)Math.toRadians(((EntityGulingSentinelHeavy)this.entity).m_217043_().m_188583_() * 360.0 - 180.0);
                float amount = (float)(((EntityGulingSentinelHeavy)this.entity).m_21133_(Attributes.f_22281_) * 1.25);
                for (int i = 0; i < 10; ++i) {
                    float f1 = (float)((double)((EntityGulingSentinelHeavy)this.entity).m_146908_() + (double)(((float)i + offset) * (float)Math.PI) * 0.2);
                    EntityElectromagnetic.shoot(((EntityGulingSentinelHeavy)this.entity).f_19853_, (LivingEntity)this.entity, amount, 2.0f, 12, 3, f1 * 57.295776f - 90.0f);
                }
            }
        }
    }
}

