/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.corpse;

import com.eeeab.animate.server.ai.AnimationSimpleAI;
import com.eeeab.animate.server.ai.AnimationSpellAI;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.ai.animation.AnimationRepel;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.NeedStopAiEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.KeepDistanceGoal;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityAbsCorpse;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpse;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCrimsonCrack;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCrimsonRay;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityBloodBall;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class EntityCorpseWarlock
extends EntityAbsCorpse
implements IEntity,
NeedStopAiEntity,
RangedAttackMob {
    public final Animation dieAnimation = Animation.create(0);
    public final Animation attackAnimation = Animation.create(15);
    public final Animation summonAnimation = Animation.create(30);
    public final Animation frenzyAnimation = Animation.create(30);
    public final Animation teleportAnimation = Animation.create(30);
    public final Animation resetPosAnimation = Animation.create(30);
    public final Animation vampireAnimation = Animation.create(90);
    public final Animation robustAnimation = Animation.create(100);
    public final Animation babbleAnimation = Animation.create(666);
    public final Animation tearSpaceAnimation = Animation.create(30);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.attackAnimation, this.summonAnimation, this.frenzyAnimation, this.teleportAnimation, this.resetPosAnimation, this.vampireAnimation, this.robustAnimation, this.babbleAnimation, this.tearSpaceAnimation};
    private int nextDPTick;
    private int hurtCount;
    private int nextHealTick;
    private List<EntityCorpse> entities = new ArrayList<EntityCorpse>();
    private static final int[] SPAWN_COUNT = new int[]{2, 4, 6};
    private static final int MAX_HURT_COUNT = 3;
    private static final UniformInt NEXT_HEAL_TIME = TimeUtil.m_145020_((int)15, (int)25);
    private static final TargetingConditions IGNORE_ALLIES = TargetingConditions.m_148352_().m_26888_(e -> {
        if (e instanceof EntityAbsCorpse) {
            return (Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get() == false;
        }
        return true;
    });
    public final ControlledAnimation glowControllerAnimation = new ControlledAnimation(10);
    private static final EntityDataAccessor<Boolean> DATA_IS_HEAL = SynchedEntityData.m_135353_(EntityCorpseWarlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_REST_POSITION = SynchedEntityData.m_135353_(EntityCorpseWarlock.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] myPos;

    public EntityCorpseWarlock(EntityType<? extends EntityAbsCorpse> type, Level level) {
        super(type, level);
        this.active = true;
        if (this.f_19853_.f_46443_) {
            this.myPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_ELITE;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        MobEffect effect = effectInstance.m_19544_();
        return (this.noConflictingTasks() || effect == EffectInit.VERTIGO_EFFECT.get() || effect == MobEffects.f_19619_) && super.m_147207_(effectInstance, entity);
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    public int m_19876_() {
        return this.m_5647_() == null ? 11998484 : super.m_19876_();
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.CORPSES.CORPSE_WARLOCK.combatConfig;
    }

    @Override
    protected EMConfigHandler.DamageCapConfig getDamageCap() {
        return EMConfigHandler.COMMON.MOB.CORPSES.CORPSE_WARLOCK.maximumDamageCap;
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (!this.f_19853_.f_46443_ && animation == this.teleportAnimation) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 50, 0, false, false));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false).m_26146_(300));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationDie<EntityCorpseWarlock>(this));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.summonAnimation, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.teleportAnimation, true){

            @Override
            public void m_8056_() {
                super.m_8056_();
                for (int i = 0; i < 16 && !((EntityCorpseWarlock)this.entity).tryTeleportToTargetBehind((Entity)(((EntityCorpseWarlock)this.entity).targetDistance < 8.0f ? ((EntityCorpseWarlock)this.entity).m_5448_() : null)); ++i) {
                }
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.resetPosAnimation, false){

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((EntityCorpseWarlock)this.entity).tryTeleportToRestPosition();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.frenzyAnimation, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.tearSpaceAnimation, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.vampireAnimation, false));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.babbleAnimation, false));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationSimpleAI(this, () -> this.robustAnimation, false));
        this.f_21345_.m_25352_(1, new AnimationRepel<EntityCorpseWarlock>(this, () -> this.attackAnimation, 4.0f, 6, 2.0f, 2.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new WarlockTeleportGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WarlockSummonGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WarlockTearApartGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WarlockReinforceGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WarlockRobustGoal(this));
        this.f_21345_.m_25352_(6, new KeepDistanceGoal<EntityCorpseWarlock>(this, 0.96, 18.0f, 2.0f));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 6.0f));
    }

    @Override
    public void m_8119_() {
        Animation animation;
        super.m_8119_();
        this.glowControllerAnimation.updatePrevTimer();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.noConflictingTasks() && this.m_5448_() == null && this.f_19797_ % 2 == 0 && this.f_19796_.m_188503_(400) == 0) {
            this.playAnimation(this.babbleAnimation);
        }
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.isNoAnimation() && this.m_5448_() == null && this.f_19797_ % 10 == 0 && this.isNoAtRestPos() && this.nextDPTick <= 0) {
            this.nextDPTick = 1200;
            this.playAnimation(this.resetPosAnimation);
        }
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.noConflictingTasks() && this.hurtCount >= 3 && this.m_5448_() != null && this.f_19797_ % 2 == 0 && (!this.f_19853_.m_45971_(LivingEntity.class, IGNORE_ALLIES, (LivingEntity)this, this.m_20191_().m_82400_(2.0)).isEmpty() || this.targetDistance <= 5.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, this.m_5448_()) || this.targetDistance < 4.0f)) {
            this.hurtCount = 0;
            this.playAnimation(this.attackAnimation);
        }
        if (!(this.f_19853_.f_46443_ || this.m_21525_() || this.f_19797_ % 40 != 0 || this.m_5448_() == null && this.getHealthPercentage() == 100.0f || !this.noConflictingTasks() || this.nextHealTick > 0)) {
            this.entities = this.f_19853_.m_45971_(EntityCorpse.class, TargetingConditions.m_148353_().m_26888_(e -> {
                EntityCorpse c;
                return this.m_5448_() == null || e instanceof EntityCorpse && (!(c = (EntityCorpse)e).m_21023_((MobEffect)EffectInit.FRENZY_EFFECT.get()) || this.getHealthPercentage() < 50.0f) && !c.valuable;
            }), (LivingEntity)this, this.m_20191_().m_82377_(32.0, 16.0, 32.0)).stream().filter(e -> this == e.getOwner()).limit(10L).collect(Collectors.toList());
            if (!this.entities.isEmpty()) {
                this.resetHealTick();
                this.playAnimation(this.vampireAnimation);
            }
        }
        if ((animation = this.getAnimation()) == this.vampireAnimation) {
            int tick = this.getAnimationTick();
            if (!this.f_19853_.f_46443_) {
                for (EntityCorpse corps : this.entities) {
                    if (corps == null || !corps.isActive()) continue;
                    Vec3 diff = corps.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 5.0, 0.0));
                    float strength = 0.05f;
                    if (this.m_20270_((Entity)corps) >= 16.0f) {
                        strength += 0.05f;
                    }
                    diff = diff.m_82541_().m_82490_((double)strength);
                    corps.m_20256_(corps.m_20184_().m_82546_(diff));
                    if (!(corps.m_20186_() < this.m_20186_() + 3.0)) continue;
                    corps.m_20256_(corps.m_20184_().m_82520_(0.0, 0.075, 0.0));
                }
                LivingEntity target = this.m_5448_();
                if (tick == 50) {
                    boolean isNotEmpty = this.entities.stream().anyMatch(LivingEntity::m_6084_);
                    this.entities.forEach(LivingEntity::m_6074_);
                    this.setIsHeal(isNotEmpty && (target != null && this.getHealthPercentage() < 50.0f || target == null && this.getHealthPercentage() != 100.0f));
                    if (!isNotEmpty) {
                        this.f_19853_.m_7605_((Entity)this, (byte)13);
                    }
                    this.m_6504_(target, !isNotEmpty ? 4.0f : (float)this.entities.size());
                } else if (tick > 60) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (!this.isHeal() && target != null) {
                        this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    }
                } else {
                    this.m_20334_(0.0, 0.12f, 0.0);
                }
            } else if (tick == 20) {
                Vec3 vec3 = this.m_20182_();
                float yRot = this.f_20883_;
                float offsetX = (float)(Math.cos(Math.toRadians(yRot + 90.0f)) * 1.5);
                float offsetZ = (float)(Math.sin(Math.toRadians(yRot + 90.0f)) * 1.5);
                this.myPos[0] = new Vec3(vec3.f_82479_ + (double)offsetX, vec3.f_82480_ + (double)this.m_20206_() * 0.6, vec3.f_82481_ + (double)offsetZ);
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 10.0, 1.0, 1.0, 1.0, 1.0, 1.0, 30.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.oscillate(0.25f, -0.24f, 12), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, AnimData.startAndEnd(0.0f, 8.0f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, AnimData.startAndEnd(0.0f, -offsetX), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, AnimData.startAndEnd(0.0f, -offsetZ), true)});
            } else if (tick == 50) {
                this.myPos[1] = this.m_20182_().m_82520_(0.0, 5.0, 0.0);
                for (int i = 0; i < 64; ++i) {
                    double d0 = this.myPos[1].f_82479_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.5f, (float)0.5f);
                    double d1 = this.myPos[1].f_82480_;
                    double d2 = this.myPos[1].f_82481_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.5f, (float)0.5f);
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), d0, d1, d2, 0.0, 0.0, 0.0);
                }
                this.f_19853_.m_7785_(this.myPos[1].f_82479_, this.myPos[1].f_82480_, this.myPos[1].f_82481_, (SoundEvent)SoundInit.CORPSE_WARLOCK_TEAR.get(), this.m_5720_(), this.m_6121_(), this.m_6100_(), false);
            }
        } else if (animation == this.teleportAnimation || animation == this.resetPosAnimation) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.m_6842_(true);
                this.doTeleportEffect();
            } else if (tick == 15) {
                this.doTeleportEffect();
            } else if (tick >= 20) {
                this.m_6842_(this.m_21023_(MobEffects.f_19609_));
            }
        } else if (animation == this.babbleAnimation) {
            if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 12.0f) {
                this.playAnimation(this.teleportAnimation);
            }
            this.doCrimsonEyeEffect(2.5f);
        } else if (animation == this.attackAnimation) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (this.f_19853_.f_46443_ && this.getAnimationTick() == 5) {
                ModParticleUtils.randomAnnularParticleOutburst(this.f_19853_, 50.0, new ParticleOptions[]{ParticleTypes.f_123762_}, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.4f);
            }
        } else if (animation == this.robustAnimation) {
            int tick = this.getAnimationTick();
            if (tick > 35) {
                this.doCrimsonEyeEffect(-1.0f);
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.m_20334_(0.0, 0.25, 0.0);
            }
        }
    }

    private void doAroundSelfEffect(ParticleOptions particleOptions) {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.15;
            double d1 = this.f_19796_.m_188583_() * 0.15;
            double d2 = this.f_19796_.m_188583_() * 0.15;
            this.f_19853_.m_7106_(particleOptions, this.m_20208_(1.5), this.m_20187_() + 0.15, this.m_20262_(1.5), d0, d1, d2);
        }
    }

    private void doCrimsonEyeEffect(float offset) {
        if (this.f_19853_.f_46443_) {
            int tick = this.getAnimationTick();
            if (tick % 20 == 0) {
                Vec3 vec3 = this.m_20182_();
                float yRot = this.f_20883_;
                float offsetX = (float)(Math.cos(Math.toRadians(yRot + 90.0f)) * (double)offset);
                float offsetZ = (float)(Math.sin(Math.toRadians(yRot + 90.0f)) * (double)offset);
                this.myPos[0] = new Vec3(vec3.f_82479_ + (double)offsetX, vec3.f_82480_ + (double)this.m_20206_() * 1.5, vec3.f_82481_ + (double)offsetZ);
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON_EYE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 10.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, false, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos)});
            }
            if (tick % 5 == 0) {
                ModParticleUtils.advAttractorParticle((ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), (Entity)this, 12, 0.0f, 2.5f, 20.0f, new ParticleComponent[]{new ParticleComponent.Attractor(this.myPos, 1.2f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.0f, 0.6f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(3.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.BLUE, AnimData.KeyTrack.constant(0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.GREEN, AnimData.KeyTrack.constant(0.0f), false)}, false);
            }
        }
    }

    private void doTeleportEffect() {
        this.m_20334_(0.0, 0.0, 0.0);
        if (this.f_19853_.f_46443_) {
            this.myPos[0] = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.6, 0.0);
            AnimData.KeyTrack keyTrack1 = AnimData.KeyTrack.oscillate(0.0f, 2.0f, 24);
            AnimData.KeyTrack keyTrack2 = new AnimData.KeyTrack(new float[]{0.0f, 40.0f, 40.0f, 0.0f}, new float[]{0.0f, 0.2f, 0.8f, 1.0f});
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 14.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack1, true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack2, false), new RibbonComponent((ParticleType<? extends RibbonParticleData>)((ParticleType)ParticleInit.FLAT_RIBBON.get()), 8, 0.0, 0.0, 0.0, 0.12f, 0.95, 0.35, 0.35, 0.75, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, AnimData.KeyTrack.startAndEnd(1.0f, 0.0f))}, false)});
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.nextDPTick > 0) {
                --this.nextDPTick;
            }
            if (this.nextHealTick > 0) {
                --this.nextHealTick;
            }
        }
        this.glowControllerAnimation.incrementOrDecreaseTimer(this.isGlow());
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        boolean flag;
        Entity entity = source.m_7639_();
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        Animation animation = this.getAnimation();
        if (animation == this.teleportAnimation) {
            return false;
        }
        if (!(animation != this.vampireAnimation && animation != this.robustAnimation || source == DamageSource.f_19317_ && source == DamageSource.f_19318_)) {
            damage *= 0.2f;
        }
        if (entity != null) {
            if (animation == this.babbleAnimation) {
                this.playAnimation(this.teleportAnimation);
            }
            Double maxDistance = (Double)EMConfigHandler.COMMON.MOB.CORPSES.CORPSE_WARLOCK.maxDistanceTakeDamage.get();
            if (ModEntityUtils.isProjectileSource(source) && (double)this.m_20270_(entity) >= maxDistance) {
                return false;
            }
        }
        if ((flag = super.m_6469_(source, damage)) && entity != null && this.f_19796_.m_188501_() < 0.6f) {
            ++this.hurtCount;
        }
        return flag;
    }

    protected float m_6515_(DamageSource source, float damage) {
        damage = super.m_6515_(source, damage);
        if (source.m_7639_() == this) {
            damage = 0.0f;
        }
        if (source.m_19387_() || source.m_19379_()) {
            damage *= 0.5f;
        }
        return damage;
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 13) {
            this.doAroundSelfEffect((ParticleOptions)ParticleTypes.f_123792_);
        } else if (id == 14) {
            this.doAroundSelfEffect((ParticleOptions)ParticleInit.WARLOCK_HEAL.get());
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    protected void m_147246_() {
        for (int j = 0; j < 64; ++j) {
            double d0 = (double)j / 63.0;
            float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
            double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            if (j >= 10) continue;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, d1, d2, d3, (double)f, (double)f1, (double)f2);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        return super.m_6518_(level, instance, spawnType, groupData, tag);
    }

    public boolean tryTeleportToTargetBehind(@Nullable Entity target) {
        EntityTeleportEvent.TeleportCommand event;
        double radian = target != null && target.m_6084_() ? Math.toRadians(this.getAngleBetweenEntities((Entity)this, target) + 90.0) : Math.toRadians(this.m_146908_() + (float)this.f_19796_.m_216332_(-180, 180));
        double d0 = this.m_20185_() - (double)(this.f_19796_.m_188503_(12) + 12) * Math.cos(radian);
        double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double d2 = this.m_20189_() - (double)(this.f_19796_.m_188503_(12) + 12) * Math.sin(radian);
        BlockPos restPos = this.getRestPos().orElse(null);
        if (restPos != null && this.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)restPos)) > 32.0) {
            d0 = (float)restPos.m_123341_() + 0.5f;
            d1 = restPos.m_123342_();
            d2 = (float)restPos.m_123343_() + 0.5f;
        }
        if ((event = ForgeEventFactory.onEntityTeleportCommand((Entity)this, (double)d0, (double)d1, (double)d2)).isCanceled()) {
            return false;
        }
        boolean flag = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11700_, this.m_5720_(), 1.0f, 1.1f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void tryTeleportToRestPosition() {
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            BlockPos pos = restPos.get();
            if (this.m_5448_() != null) {
                return;
            }
            EntityTeleportEvent.TeleportCommand event = ForgeEventFactory.onEntityTeleportCommand((Entity)this, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            if (event.isCanceled()) {
                return;
            }
            boolean flag = this.m_20984_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, false);
            if (flag && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }

    public boolean checkCanSummonCorpse() {
        return !this.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get()) && this.getNearByEntities(EntityCorpse.class, 16.0, 16.0, 16.0, 16.0).size() <= 12;
    }

    public void summonCorpse(Vec3 vec3) {
        EntityType entityType = this.f_19796_.m_188499_() ? (EntityType)EntityInit.CORPSE.get() : (EntityType)EntityInit.CORPSE_VILLAGER.get();
        EntityCorpse entity = (EntityCorpse)entityType.m_20615_(this.f_19853_);
        if (entity != null && vec3 != null && !this.f_19853_.f_46443_) {
            entity.setInitSpawn();
            entity.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(new BlockPos(vec3)), MobSpawnType.MOB_SUMMONED, null, null);
            entity.setOwner(this);
            entity.m_20219_(vec3);
            this.f_19853_.m_7967_((Entity)entity);
        }
    }

    public TargetType assessTargetAI() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            float threat;
            if (target instanceof Player) {
                return TargetType.KNOTTY;
            }
            AttributeInstance attribute = target.m_21051_(Attributes.f_22281_);
            AttributeInstance attribute1 = target.m_21051_(Attributes.f_22284_);
            float health = target.m_21233_();
            float attack = 0.0f;
            float armor = 0.0f;
            if (attribute != null) {
                attack = (float)attribute.m_22115_();
            }
            if (attribute1 != null) {
                armor = (float)attribute1.m_22115_();
            }
            if ((threat = Math.max(attack + armor, health / 10.0f)) >= 10.0f && threat <= 30.0f) {
                return TargetType.KNOTTY;
            }
            if (threat > 30.0f) {
                return TargetType.HARD;
            }
        }
        return TargetType.COMMON;
    }

    public void m_6504_(@Nullable LivingEntity entity, float strength) {
        EntityBloodBall bloodBall = new EntityBloodBall(this.f_19853_, 30, this.isHeal(), (int)strength);
        if (entity != null) {
            bloodBall.setTargetUUID(entity.m_20148_());
        }
        bloodBall.m_5602_((Entity)this);
        bloodBall.m_146884_(this.m_20182_().m_82520_(0.0, 5.0, 0.0));
        this.f_19853_.m_7967_((Entity)bloodBall);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (!this.f_19853_.f_46443_ && target == null && this.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            this.resetHealTick();
        }
        super.m_6710_(target);
    }

    private void resetHealTick() {
        this.nextHealTick = NEXT_HEAL_TIME.m_214085_(this.f_19796_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_HEAL, (Object)false);
        this.f_19804_.m_135372_(DATA_REST_POSITION, Optional.empty());
    }

    protected void m_7472_(DamageSource source, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(source, pLooting, pRecentlyHit);
        if (source.m_7639_() != null || this.m_5448_() != null) {
            ItemEntity itementity = this.m_19998_((ItemLike)ItemInit.HEART_OF_PAGAN.get());
            ItemEntity itementity2 = this.m_19998_((ItemLike)ItemInit.SOUL_SUMMONING_NECKLACE.get());
            if (itementity != null && itementity2 != null) {
                itementity.m_32064_();
                itementity.m_146915_(true);
                itementity2.m_32064_();
                itementity2.m_146915_(true);
            }
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)SoundInit.CORPSE_WARLOCK_HURT.get(), this.m_6121_(), this.m_6100_() - 0.5f);
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        this.m_5496_((SoundEvent)SoundInit.CORPSE_WARLOCK_HURT.get(), this.m_6121_() * 0.8f, this.m_6100_() + 0.25f);
        return null;
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public boolean noConflictingTasks() {
        return this.isNoAnimation() && !this.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.getRestPos().ifPresent(pos -> compound.m_128365_("spawnPos", (Tag)NbtUtils.m_129224_((BlockPos)pos)));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("spawnPos")) {
            this.setRestPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("spawnPos")));
        }
    }

    @Override
    public boolean isGlow() {
        return this.m_6084_() && (this.getAnimation() == this.vampireAnimation || this.getAnimation() == this.teleportAnimation || this.getAnimation() == this.robustAnimation || this.getAnimation() == this.babbleAnimation);
    }

    public boolean isHeal() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_HEAL);
    }

    public void setIsHeal(boolean isHeal) {
        this.f_19804_.m_135381_(DATA_IS_HEAL, (Object)isHeal);
    }

    private boolean isNoAtRestPos() {
        Optional<BlockPos> restPos = this.getRestPos();
        return restPos.filter(blockPos -> blockPos.m_123331_((Vec3i)this.m_20183_()) > 9.0).isPresent();
    }

    public Optional<BlockPos> getRestPos() {
        return (Optional)this.f_19804_.m_135370_(DATA_REST_POSITION);
    }

    public void setRestPos(BlockPos pos) {
        this.f_19804_.m_135381_(DATA_REST_POSITION, Optional.ofNullable(pos));
    }

    public int getNextHealTick() {
        return this.nextHealTick;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return EntityCorpseWarlock.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22277_, 36.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    static class WarlockAnimationSimpleAI
    extends AnimationSimpleAI<EntityCorpseWarlock> {
        private final boolean lookAtTarget;

        public WarlockAnimationSimpleAI(EntityCorpseWarlock entity, Supplier<Animation> animationSupplier, boolean lookAtTarget) {
            super(entity, animationSupplier);
            this.lookAtTarget = lookAtTarget;
        }

        public void m_8037_() {
            LivingEntity target = ((EntityCorpseWarlock)this.entity).m_5448_();
            if (this.lookAtTarget && target != null) {
                ((EntityCorpseWarlock)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityCorpseWarlock)this.entity).m_146922_(((EntityCorpseWarlock)this.entity).f_19859_);
            }
        }
    }

    static class WarlockTeleportGoal
    extends AnimationSpellAI<EntityCorpseWarlock> {
        public WarlockTeleportGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target;
            if (super.m_8036_() && (target = ((EntityCorpseWarlock)this.spellCaster).m_5448_()) != null) {
                float distance = ((EntityCorpseWarlock)this.spellCaster).m_20270_((Entity)target) - target.m_20205_() / 2.0f;
                return (distance < 16.0f || !((EntityCorpseWarlock)this.spellCaster).m_21574_().m_148306_((Entity)target)) && ((EntityCorpseWarlock)this.spellCaster).m_217043_().m_188503_(100) == 0 || distance < 8.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this.spellCaster, target) || distance < 6.0f;
            }
            return false;
        }

        @Override
        protected void inSpellCasting() {
        }

        @Override
        protected int getSpellCastingCooling() {
            return 150 + ((EntityCorpseWarlock)this.spellCaster).f_19796_.m_188503_(90);
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getEMAnimation() {
            return ((EntityCorpseWarlock)this.spellCaster).teleportAnimation;
        }
    }

    static class WarlockSummonGoal
    extends AnimationSpellAI<EntityCorpseWarlock> {
        public WarlockSummonGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            boolean flag = ((EntityCorpseWarlock)this.spellCaster).getNextHealTick() <= 0;
            boolean flag1 = ((EntityCorpseWarlock)this.spellCaster).f_19797_ >= this.nextAttackTickCount;
            boolean flag2 = ((EntityCorpseWarlock)this.spellCaster).checkCanSummonCorpse();
            boolean flag3 = ((EntityCorpseWarlock)this.spellCaster).noConflictingTasks();
            if (target != null && target.m_6084_()) {
                if (!flag3) {
                    return false;
                }
                return flag1 && flag2;
            }
            return flag && flag1 && flag2 && flag3 && ((EntityCorpseWarlock)this.spellCaster).getHealthPercentage() != 100.0f;
        }

        @Override
        public boolean m_8045_() {
            return this.attackDelay > 0;
        }

        @Override
        protected void inSpellCasting() {
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            double minY = ((EntityCorpseWarlock)this.spellCaster).m_20186_();
            double maxY = ((EntityCorpseWarlock)this.spellCaster).m_20186_() + 1.0;
            if (target != null) {
                minY = Math.min(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_());
                maxY = Math.max(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_()) + 1.0;
            }
            TargetType targetType = ((EntityCorpseWarlock)this.spellCaster).assessTargetAI();
            int count = SPAWN_COUNT[Math.min(targetType.type, SPAWN_COUNT.length - 1)];
            for (int i = 0; i < count; ++i) {
                float f1 = (float)((double)((EntityCorpseWarlock)this.spellCaster).m_146908_() + (double)((float)i * (float)Math.PI) * (2.0 / (double)count));
                double x = ((EntityCorpseWarlock)this.spellCaster).m_20185_() + (double)Mth.m_14089_((float)f1) * 3.0;
                double z = ((EntityCorpseWarlock)this.spellCaster).m_20189_() + (double)Mth.m_14031_((float)f1) * 3.0;
                ((EntityCorpseWarlock)this.spellCaster).summonCorpse(ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.spellCaster, x, z, minY, maxY));
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().duration;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getEMAnimation() {
            return ((EntityCorpseWarlock)this.spellCaster).summonAnimation;
        }
    }

    static class WarlockTearApartGoal
    extends AnimationSpellAI<EntityCorpseWarlock> {
        private double preX;
        private double preZ;
        private double targetY;
        private double targetX;
        private double targetZ;
        private LivingEntity target;

        public WarlockTearApartGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            if (target != null) {
                this.target = target;
                this.preX = target.m_20185_();
                this.preZ = target.m_20189_();
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.target == null) {
                return;
            }
            if (this.attackDelay > 6) {
                ((EntityCorpseWarlock)this.spellCaster).m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            }
            if (this.attackDelay <= 6) {
                ((EntityCorpseWarlock)this.spellCaster).m_21563_().m_24950_(this.targetX, this.targetY, this.targetZ, 30.0f, 30.0f);
            }
            if (this.attackDelay == 7) {
                double dz;
                double x = this.target.m_20185_();
                this.targetY = Mth.m_14107_((double)(this.target.m_20186_() + 1.0));
                double z = this.target.m_20189_();
                double vx = (x - this.preX) / 9.0;
                double vz = (z - this.preZ) / 9.0;
                int radius = 32;
                this.targetX = Mth.m_14107_((double)(x + vx * (double)radius));
                this.targetZ = Mth.m_14107_((double)(z + vz * (double)radius));
                double dx = this.targetX - ((EntityCorpseWarlock)this.spellCaster).m_20185_();
                double dist = dx * dx + (dz = this.targetZ - ((EntityCorpseWarlock)this.spellCaster).m_20189_()) * dz;
                if (dist < 3.0) {
                    this.targetX = Mth.m_14107_((double)this.target.m_20185_());
                    this.targetZ = Mth.m_14107_((double)this.target.m_20189_());
                }
            }
        }

        @Override
        protected void inSpellCasting() {
            if (!((EntityCorpseWarlock)this.spellCaster).f_19853_.f_46443_) {
                double radians = 0.0;
                double targetWidth = 0.0;
                if (this.target != null) {
                    radians = Math.toRadians(this.target.f_20883_ + 180.0f);
                    targetWidth = Math.min((double)this.target.m_20205_(), 1.5);
                }
                EntityCrimsonCrack crack = new EntityCrimsonCrack(((EntityCorpseWarlock)this.spellCaster).f_19853_, (LivingEntity)this.spellCaster, new Vec3(this.targetX - targetWidth * Math.cos(radians), this.targetY + (double)0.56125f, this.targetZ - targetWidth * Math.sin(radians)));
                ((EntityCorpseWarlock)this.spellCaster).f_19853_.m_7967_((Entity)crack);
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return 300;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getEMAnimation() {
            return ((EntityCorpseWarlock)this.spellCaster).tearSpaceAnimation;
        }
    }

    static class WarlockReinforceGoal
    extends AnimationSpellAI<EntityCorpseWarlock> {
        private final TargetingConditions reinforceConditions = TargetingConditions.m_148352_().m_26883_(16.0).m_26888_(e -> {
            if (!(e instanceof EntityCorpse)) return false;
            EntityCorpse c = (EntityCorpse)e;
            if (!c.valuable) return false;
            return true;
        });
        private List<EntityCorpse> list;

        public WarlockReinforceGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (((EntityCorpseWarlock)this.spellCaster).f_19797_ % 5 != 0) {
                return false;
            }
            this.list = ((EntityCorpseWarlock)this.spellCaster).f_19853_.m_45971_(EntityCorpse.class, this.reinforceConditions, (LivingEntity)this.spellCaster, ((EntityCorpseWarlock)this.spellCaster).m_20191_().m_82377_(32.0, 16.0, 32.0));
            return !this.list.isEmpty();
        }

        @Override
        protected void inSpellCasting() {
            if (this.list != null && !this.list.isEmpty()) {
                this.list.stream().filter(c -> c.m_6084_() && this.spellCaster == c.getOwner() && !c.m_21023_((MobEffect)EffectInit.FRENZY_EFFECT.get())).forEach(c -> {
                    int type = ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().type;
                    c.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FRENZY_EFFECT.get(), 200 + 100 * type, type));
                    c.valuable = false;
                });
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().duration;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getEMAnimation() {
            return ((EntityCorpseWarlock)this.spellCaster).frenzyAnimation;
        }
    }

    static class WarlockRobustGoal
    extends AnimationSpellAI<EntityCorpseWarlock> {
        public WarlockRobustGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            if (super.m_8036_()) {
                boolean flag;
                LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
                boolean bl = flag = ((EntityCorpseWarlock)this.spellCaster).getHealthPercentage() < 75.0f || ((EntityCorpseWarlock)this.spellCaster).f_19797_ > 1200;
                if (target != null) {
                    return flag && ((EntityCorpseWarlock)this.spellCaster).m_20270_((Entity)target) - target.m_20205_() / 2.0f < 16.0f;
                }
            }
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        @Override
        public boolean m_8045_() {
            return ((EntityCorpseWarlock)this.spellCaster).getAnimation() == ((EntityCorpseWarlock)this.spellCaster).robustAnimation;
        }

        @Override
        public void m_8037_() {
            int tick = ((EntityCorpseWarlock)this.spellCaster).getAnimationTick();
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            if (target != null) {
                if (tick > 40) {
                    ((EntityCorpseWarlock)this.spellCaster).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    ((EntityCorpseWarlock)this.spellCaster).m_146922_(((EntityCorpseWarlock)this.spellCaster).f_19859_);
                }
                double minY = Math.min(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_()) - 16.0;
                double maxY = Math.max(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_()) + 1.0;
                if (tick >= 40 && tick % 10 == 0) {
                    for (int i = 0; i < 5; ++i) {
                        double rz = target.m_20189_() + ((EntityCorpseWarlock)this.spellCaster).f_19796_.m_188583_() * 5.0;
                        double rx = target.m_20185_() + ((EntityCorpseWarlock)this.spellCaster).f_19796_.m_188583_() * 5.0;
                        this.spawnRay(rx, rz, minY, maxY);
                    }
                }
                if (((EntityCorpseWarlock)this.spellCaster).f_19796_.m_188499_() && (tick == 45 || tick == 55 || tick == 65 || tick == 75 || tick == 85)) {
                    this.spawnRay(target.m_20185_(), target.m_20189_(), minY, maxY);
                }
            }
        }

        private void spawnRay(double x, double z, double minY, double maxY) {
            if (!((EntityCorpseWarlock)this.spellCaster).f_19853_.f_46443_) {
                Vec3 sPos = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.spellCaster, x, z, minY, maxY);
                EntityCrimsonRay.PreAttack ray = new EntityCrimsonRay.PreAttack(((EntityCorpseWarlock)this.spellCaster).f_19853_, sPos, (LivingEntity)this.spellCaster, 16 + ((EntityCorpseWarlock)this.spellCaster).m_217043_().m_188503_(5));
                ray.m_146884_(sPos);
                ((EntityCorpseWarlock)this.spellCaster).f_19853_.m_7967_((Entity)ray);
            }
        }

        @Override
        protected void inSpellCasting() {
        }

        @Override
        protected int getSpellCastingCooling() {
            return 800 - ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().duration;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getEMAnimation() {
            return ((EntityCorpseWarlock)this.spellCaster).robustAnimation;
        }
    }

    public static enum TargetType {
        COMMON(0, 200),
        KNOTTY(1, 300),
        HARD(2, 400);

        public final int type;
        public final int duration;

        private TargetType(int type, int duration) {
            this.type = type;
            this.duration = duration;
        }
    }
}

