/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.corpse;

import com.eeeab.animate.server.ai.AnimationMeleeAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationMelee;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.sever.capability.FrenzyCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.CopyOwnerTargetGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.ReFindOwnerGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.RedirectOwnerHatredGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.WhenOwnerDeadGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.navigate.EMWallClimberNavigation;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityAbsCorpse;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseWarlock;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityCorpse
extends EntityAbsCorpse
implements IEntity {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(EntityCorpse.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final Animation attackAnimation1 = Animation.create(15);
    public final Animation attackAnimation2 = Animation.create(15);
    public final Animation attackAnimation3 = Animation.create(15);
    public final Animation spawnAnimation = Animation.create(20);
    private final Animation[] animations = new Animation[]{this.attackAnimation1, this.attackAnimation2, this.attackAnimation3, this.spawnAnimation};

    public EntityCorpse(EntityType<? extends EntityAbsCorpse> type, Level level) {
        super(type, level);
        this.active = true;
    }

    public boolean isFrenzy() {
        FrenzyCapability.IFrenzyCapability capability = HandlerCapability.getCapability((Entity)this, HandlerCapability.FRENZY_EFFECT_CAPABILITY);
        if (capability != null) {
            return capability.isFrenzy();
        }
        return false;
    }

    @Override
    public boolean isGlow() {
        return super.isGlow() && !this.isFrenzy();
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.CORPSES.CORPSE.combatConfig;
    }

    protected PathNavigation m_6037_(Level level) {
        return new EMWallClimberNavigation((Mob)this, level);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return fallDistance > 10.0f;
    }

    protected boolean m_8028_() {
        return true;
    }

    @Override
    public void setInitSpawn() {
        super.setInitSpawn();
        this.playAnimation(this.spawnAnimation);
        this.active = false;
        this.setActive(false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityAbsCorpse.class}).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityCorpse>(this, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpse>(this, () -> this.attackAnimation1, 9, 2.0f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpse>(this, () -> this.attackAnimation2, 9, 2.0f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpse>(this, () -> this.attackAnimation3, 9, 2.0f, 1.5f, 1.5f));
        this.f_21345_.m_25352_(2, new AnimationMeleeAI<EntityCorpse>(this, 1.2, 5, () -> this.attackAnimation1, () -> this.attackAnimation2, () -> this.attackAnimation3));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, EntityAbsCorpse.class, 6.0f));
        this.f_21345_.m_25352_(1, new ReFindOwnerGoal<EntityCorpse>(this, EntityCorpseWarlock.class, 18.0));
        this.f_21346_.m_25352_(2, new CopyOwnerTargetGoal<EntityCorpse>(this));
        this.f_21345_.m_25352_(3, new RedirectOwnerHatredGoal<EntityCorpse>(this, 16.0f));
        this.f_21345_.m_25352_(3, new WhenOwnerDeadGoal<EntityCorpse>(this));
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19853_.f_46443_ && this.getAnimation() == this.spawnAnimation) {
            this.setSpawnParticle(4);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (!this.f_19853_.f_46443_ && this.active && !this.isActive()) {
            this.setActive(true);
        }
        this.active = this.isActive();
        if (!this.active) {
            this.m_21573_().m_26573_();
            this.m_146922_(this.f_19859_);
            this.f_20883_ = this.m_146908_();
        }
    }

    public void setSpawnParticle(int amount) {
        RandomSource randomsource = this.m_217043_();
        BlockState blockstate = this.m_20075_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < amount; ++i) {
                double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                double d1 = this.m_20186_();
                double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_ && this.getOwner() != null && this.getOwner().m_6084_()) {
            if (source.m_7639_() == this.getOwner()) {
                this.getOwner().m_5634_(this.getOwner().m_21233_() * 0.01f);
                this.getOwner().f_19853_.m_7605_((Entity)this.getOwner(), (byte)14);
            }
            this.f_19853_.m_45971_(Mob.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(16.0)).stream().filter(mob -> mob != this && mob != this.getOwner() && mob.m_6084_() && mob.m_5448_() == this).forEach(mob -> {
                mob.m_6710_((LivingEntity)this.getOwner());
                Brain mobBrain = mob.m_6274_();
                if (mobBrain.m_21874_(MemoryModuleType.f_26372_)) {
                    mobBrain.m_21879_(MemoryModuleType.f_26372_, (Object)this.getOwner());
                }
            });
        }
        super.m_6667_(source);
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        boolean flag = super.m_214076_(level, entity);
        if (!((Boolean)EMConfigHandler.COMMON.MOB.CORPSES.CORPSE.enableConvertToCorpse.get()).booleanValue()) {
            return flag;
        }
        if (level.m_46791_() == Difficulty.NORMAL || level.m_46791_() == Difficulty.HARD) {
            Villager villager;
            Zombie zombie;
            if (level.m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_()) {
                return flag;
            }
            if (entity instanceof Zombie && !(zombie = (Zombie)entity).m_6162_()) {
                return this.convertToCorpse(level, (EntityType)EntityInit.CORPSE.get(), (Mob)zombie);
            }
            if (entity instanceof Villager && !(villager = (Villager)entity).m_6162_() && villager.m_7141_().m_35576_() == 1) {
                return this.convertToCorpse(level, (EntityType)EntityInit.CORPSE_VILLAGER.get(), (Mob)villager);
            }
        }
        return flag;
    }

    private <T extends EntityAbsCorpse> boolean convertToCorpse(ServerLevel level, EntityType<T> entityType, Mob sourceEntity) {
        EntityAbsCorpse convertEntity = (EntityAbsCorpse)sourceEntity.m_21406_(entityType, false);
        if (convertEntity != null) {
            convertEntity.m_6518_((ServerLevelAccessor)level, level.m_6436_(convertEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
            ForgeEventFactory.onLivingConvert((LivingEntity)sourceEntity, (LivingEntity)convertEntity);
            if (!this.m_20067_()) {
                level.m_5898_(null, 1026, this.m_20183_(), 0);
            }
            if (this.isSummon() && this.getOwner() != null && this.getOwner().m_6084_()) {
                convertEntity.setInitSpawn();
                convertEntity.setOwner(this.getOwner());
            }
            return false;
        }
        return true;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return EntityCorpse.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.CORPSE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.CORPSE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.CORPSE_DEATH.get();
    }
}

