/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityFallingBlock;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.entity.util.ShockWaveUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class ImmortalShakeGroundGoal
extends AnimationAI<EntityImmortal> {
    private static final int SHAKE_GROUND_RANGE = 20;

    public ImmortalShakeGroundGoal(EntityImmortal entity) {
        super(entity);
    }

    @Override
    public void m_8041_() {
        ((EntityImmortal)this.entity).canInterruptsAnimation = false;
        super.m_8041_();
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == ((EntityImmortal)this.entity).smashGround1Animation || animation == ((EntityImmortal)this.entity).smashGround2Animation || animation == ((EntityImmortal)this.entity).smashGround3Animation || animation == ((EntityImmortal)this.entity).shoryukenAnimation;
    }

    public void m_8037_() {
        LivingEntity target = ((EntityImmortal)this.entity).m_5448_();
        Animation animation = ((EntityImmortal)this.entity).getAnimation();
        int tick = ((EntityImmortal)this.entity).getAnimationTick();
        if (animation == ((EntityImmortal)this.entity).smashGround1Animation) {
            ((EntityImmortal)this.entity).anchorToGround();
            if (target != null && (tick < 19 || tick > 25)) {
                ((EntityImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
            if (tick == 15) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.6f, ((EntityImmortal)this.entity).m_6100_() + 0.05f);
            } else if (tick == 19) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_SHAKE_GROUND.get(), 1.0f, 1.0f);
            } else if (tick == 21) {
                boolean onGround = ((EntityImmortal)this.entity).m_20096_();
                for (LivingEntity entityHit : ShockWaveUtils.doRingShockWave(((EntityImmortal)this.entity).f_19853_, ((EntityImmortal)this.entity).getPosOffset(false, 1.5f, 0.0f, -1.0f), 3.8, -0.03f, false, 12)) {
                    if (entityHit == this.entity) continue;
                    boolean hit2 = ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, false, false, 0.025f, 1.2f, 0.9f);
                    ((EntityImmortal)this.entity).disableShield(entityHit, 50);
                    ((EntityImmortal)this.entity).knockBack(entityHit, onGround ? (hit2 ? 0.5 : 0.25) : 0.1, onGround ? (hit2 ? 0.3 : 0.15) : -1.0, true, false);
                }
            } else if (tick == 22) {
                ((EntityImmortal)this.entity).shakeGround(0.3f, 20.0f, 0.2f, 5, 5);
            }
        } else if (animation == ((EntityImmortal)this.entity).smashGround2Animation) {
            ((EntityImmortal)this.entity).anchorToGround();
            if (target != null && (tick >= 60 || tick < 16)) {
                ((EntityImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
            if (tick == 12) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.7f, ((EntityImmortal)this.entity).m_6100_() + 0.1f);
            } else if (tick == 16) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_SHAKE_GROUND.get(), 1.2f, 1.0f);
            } else if (tick == 17) {
                for (LivingEntity entityHit : ShockWaveUtils.doRingShockWave(((EntityImmortal)this.entity).f_19853_, ((EntityImmortal)this.entity).getPosOffset(false, 1.5f, 0.0f, -1.0f), 5.0, 0.0f, true, 35)) {
                    if (entityHit == this.entity) continue;
                    ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, false, false, 0.025f, 1.1f, 1.1f);
                    ((EntityImmortal)this.entity).disableShield(entityHit, 50);
                    ((EntityImmortal)this.entity).knockBack(entityHit, 0.5, 0.05, true, false);
                }
            } else if (tick == 18) {
                ((EntityImmortal)this.entity).shakeGround(0.45f, 20.0f, 0.2f, 5, 5);
            } else if (tick == 42) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK2.get(), 1.5f, 1.2f);
            } else if (tick > 45 && tick < 56) {
                if (tick == 46) {
                    ((EntityImmortal)this.entity).shakeGround(0.0f, 20.0f, 0.2f, 8, 2);
                }
                int i = tick - 45;
                float tickFactor = EMMathUtils.getTickFactor(i, 9.0f, false);
                if (tick % 2 == 0) {
                    ((EntityImmortal)this.entity).f_19853_.m_5594_(null, ((EntityImmortal)this.entity).m_20183_(), (SoundEvent)SoundInit.IMMORTAL_STONE_CRACK.get(), ((EntityImmortal)this.entity).m_5720_(), 1.0f, 1.0f);
                }
                ShockWaveUtils.doAdvShockWave((LivingEntity)this.entity, i, 3.0f, 2.0, 1.5, 2.0, false, false, hit -> {
                    if (hit instanceof LivingEntity) {
                        LivingEntity entityHit = (LivingEntity)hit;
                        ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, false, false, 0.03f, 1.0f, 0.6f);
                        ((EntityImmortal)this.entity).knockBack(entityHit, 0.2, 0.05, true, false);
                    } else if (hit instanceof EntityFallingBlock) {
                        hit.m_20256_(hit.m_20184_().m_82520_(0.0, 0.025 * (double)tickFactor, 0.0));
                    }
                }, 0.1f + 0.65f * tickFactor);
            } else if (tick == 75) {
                ((EntityImmortal)this.entity).canInterruptsAnimation = true;
            }
        } else if (animation == ((EntityImmortal)this.entity).smashGround3Animation) {
            if (((EntityImmortal)this.entity).blockEntity != null) {
                target = ((EntityImmortal)this.entity).blockEntity;
            }
            if (tick < 20 && target != null) {
                ((EntityImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
            if (tick > 10 && tick < 20) {
                if (tick == 16) {
                    ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK2.get(), 1.5f, 1.4f);
                }
                this.pursuit(target, EMMathUtils.getTickFactor(tick - 10, 5.0f, true), 3.0f, 6.0f, 2.0f);
            } else if (tick >= 20 && tick < 32) {
                ((EntityImmortal)this.entity).anchorToGround();
                if (tick == 20) {
                    float width = ((EntityImmortal)this.entity).m_20205_() * 0.8f;
                    this.smashGround(((EntityImmortal)this.entity).getPosOffset(true, 1.45f, width, -1.0f));
                    this.smashGround(((EntityImmortal)this.entity).getPosOffset(false, 1.45f, width, -1.0f));
                } else if (tick == 21) {
                    ((EntityImmortal)this.entity).shakeGround(0.3f, 20.0f, 0.215f, 8, 2);
                }
                int i = tick - 20;
                float tickFactor = EMMathUtils.getTickFactor(i, 9.0f, false);
                if (tick % 2 == 0) {
                    ((EntityImmortal)this.entity).f_19853_.m_5594_(null, ((EntityImmortal)this.entity).m_20183_(), (SoundEvent)SoundInit.IMMORTAL_STONE_CRACK.get(), ((EntityImmortal)this.entity).m_5720_(), 1.0f, 1.0f);
                }
                ShockWaveUtils.doAdvShockWave((LivingEntity)this.entity, i, 3.0f, 0.7, 1.5, 2.0, false, false, hit -> {
                    if (hit instanceof LivingEntity) {
                        LivingEntity entityHit = (LivingEntity)hit;
                        ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, false, false, 0.03f, 1.0f, 0.75f);
                        ((EntityImmortal)this.entity).knockBack(entityHit, 0.3, 0.05, true, false);
                    } else if (hit instanceof EntityFallingBlock) {
                        hit.m_20256_(hit.m_20184_().m_82520_(0.0, 0.02 * (double)tickFactor, 0.0));
                    }
                }, 0.2f + 0.65f * tickFactor);
            }
        } else if (animation == ((EntityImmortal)this.entity).shoryukenAnimation) {
            if ((tick < 16 || tick >= 30 && tick < 39 || tick >= 65) && target != null) {
                float speed = tick >= 65 ? 15.0f : 30.0f;
                ((EntityImmortal)this.entity).m_21391_((Entity)target, speed, speed);
                ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, speed, speed);
            } else {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
            if (tick > 10 && tick < 30) {
                this.pursuit(target, EMMathUtils.getTickFactor(tick - 10, 20.0f, true), 5.0f, 10.0f, 3.0f);
            } else if (tick >= 40 && tick <= 45) {
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
                this.pursuit(target, EMMathUtils.getTickFactor(tick - 40, 5.0f, true), 3.725f, 7.5f, 7.0f);
            }
            if (tick == 15) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.7f, ((EntityImmortal)this.entity).m_6100_() - 0.05f);
            } else if (tick == 16) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_SHORYUKEN.get(), 0.5f, 0.8f);
            } else if (tick == 20) {
                float attackDistance = 5.0f;
                boolean hitFlag = false;
                for (LivingEntity entityHit : ((EntityImmortal)this.entity).getNearByLivingEntities(attackDistance)) {
                    hitFlag = true;
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, entityHit);
                    float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) * (entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) + (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_()) * (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_())) - entityHit.m_20205_() / 2.0f;
                    if (!(entityHitDistance <= attackDistance) || !(entityRelativeAngle >= -20.0f && entityRelativeAngle <= 90.0f || entityRelativeAngle >= 310.0f) && !(entityRelativeAngle <= -310.0f)) continue;
                    ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, entityHit.m_21023_((MobEffect)EffectInit.ERODE_EFFECT.get()), true, false, 0.03f, 0.8f, 1.0f);
                    ((EntityImmortal)this.entity).knockBack(entityHit, 0.65, 0.45, true, false);
                }
                if (hitFlag) {
                    ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_PUNCH_HIT.get(), 1.0f, 1.1f);
                }
            }
            if (tick == 42) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.7f, ((EntityImmortal)this.entity).m_6100_() + 0.1f);
            } else if (tick == 44) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_SHORYUKEN.get(), 0.6f, 0.9f);
            } else if (tick == 46) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_SHAKE_GROUND.get(), 1.2f, 1.2f);
            } else if (tick == 47) {
                for (LivingEntity entityHit : ShockWaveUtils.doRingShockWave(((EntityImmortal)this.entity).f_19853_, ((EntityImmortal)this.entity).getPosOffset(false, 4.5f, 0.0f, -1.0f), 2.5, -0.05f, false, 10)) {
                    if (entityHit == this.entity) continue;
                    int preInvulnerableTime = entityHit.f_19802_;
                    entityHit.f_19802_ = 0;
                    boolean hit3 = ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, false, false, 0.03f, 1.2f, 1.0f);
                    ((EntityImmortal)this.entity).disableShield(entityHit, 50);
                    if (!hit3) {
                        entityHit.f_19802_ = preInvulnerableTime;
                    }
                    ((EntityImmortal)this.entity).knockBack(entityHit, hit3 ? 0.2 : 0.1, hit3 ? 0.25 : 0.15, true, false);
                }
            } else if (tick == 48) {
                ((EntityImmortal)this.entity).f_19853_.m_5594_(null, ((EntityImmortal)this.entity).m_20183_(), (SoundEvent)SoundInit.IMMORTAL_STONE_CRACK.get(), ((EntityImmortal)this.entity).m_5720_(), 0.9f, 1.0f);
                ((EntityImmortal)this.entity).shakeGround(0.3f, 20.0f, 0.2f, 5, 5);
            }
        }
    }

    private void smashGround(Vec3 pos) {
        for (LivingEntity entityHit : ShockWaveUtils.doRingShockWave(((EntityImmortal)this.entity).f_19853_, pos, 2.8, 0.0f, false, 5)) {
            if (entityHit == this.entity) continue;
            ((EntityImmortal)this.entity).doHurtTarget(entityHit, true, false, true, false, 0.025f, 1.1f, 1.2f);
            ((EntityImmortal)this.entity).knockBack(entityHit, 0.3, 0.1, true, false);
        }
    }

    private void pursuit(LivingEntity target, float tickFactor, float distance, float maxDistance, float canMoveDistance) {
        float distanceFactor = 0.25f;
        if (target != null) {
            float distanceTo = ((EntityImmortal)this.entity).m_20270_((Entity)target);
            if (distanceTo <= canMoveDistance) {
                return;
            }
            distanceFactor = EMMathUtils.getTickFactor(Math.min(distanceTo, distance), maxDistance, false);
        }
        double radians = Math.toRadians(((EntityImmortal)this.entity).m_146908_() + 90.0f);
        Vec3 pounceVec = new Vec3(Math.cos(radians), 0.0, Math.sin(radians)).m_82541_();
        double moveSpeed = ((EntityImmortal)this.entity).m_21133_(Attributes.f_22279_);
        float speedMultiplier = EMMathUtils.calculateSpeedMultiplier(tickFactor, distanceFactor, 3.0f, 15.0f);
        ((EntityImmortal)this.entity).m_20334_(pounceVec.f_82479_ * (double)speedMultiplier * moveSpeed, ((EntityImmortal)this.entity).m_20184_().f_82480_, pounceVec.f_82481_ * (double)speedMultiplier * moveSpeed);
    }
}

