/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityImmortalMagicCircle;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.entity.util.ShockWaveUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ImmortalPounceGoal
extends AnimationAI<EntityImmortal> {
    public static final float MAX_DISTANCE = 32.0f;
    private Vec3 pounceVec = Vec3.f_82478_;
    private LivingEntity targetCache;
    private float distanceFactor;

    public ImmortalPounceGoal(EntityImmortal entity) {
        super(entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.targetCache = ((EntityImmortal)this.entity).m_5448_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.pounceVec = Vec3.f_82478_;
        this.targetCache = null;
        this.distanceFactor = 0.0f;
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == ((EntityImmortal)this.entity).pouncePreAnimation || animation == ((EntityImmortal)this.entity).pounceHoldAnimation || animation == ((EntityImmortal)this.entity).pounceEndAnimation || animation == ((EntityImmortal)this.entity).pounceSmashAnimation || animation == ((EntityImmortal)this.entity).pouncePickAnimation;
    }

    public void m_8037_() {
        Animation animation = ((EntityImmortal)this.entity).getAnimation();
        int tick = ((EntityImmortal)this.entity).getAnimationTick();
        if (animation == ((EntityImmortal)this.entity).pouncePreAnimation) {
            if (tick < 10) {
                if (this.targetCache != null && !this.targetCache.m_213877_()) {
                    ((EntityImmortal)this.entity).m_21391_((Entity)this.targetCache, 90.0f, 30.0f);
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 200.0f, 30.0f);
                    Vec3 vec3 = ((EntityImmortal)this.entity).m_20182_();
                    this.pounceVec = new Vec3(this.targetCache.m_20185_() - vec3.f_82479_, 0.0, this.targetCache.m_20189_() - vec3.f_82481_).m_82541_();
                    this.distanceFactor = this.getDistanceFactor(this.targetCache, 32.0f, false);
                    if (tick == 5) {
                        EntityImmortalMagicCircle.spawn(((EntityImmortal)this.entity).f_19853_, (LivingEntity)this.entity, ((EntityImmortal)this.entity).m_20182_().m_82520_(0.0, 0.25, 0.0), 3.0f, -1.0f, (int)(20.0f + 90.0f * this.distanceFactor), ((EntityImmortal)this.entity).m_146908_(), EntityImmortalMagicCircle.MagicCircleType.SPEED, false);
                    }
                } else if (((EntityImmortal)this.entity).m_5448_() != null) {
                    this.targetCache = ((EntityImmortal)this.entity).m_5448_();
                }
            } else if (this.pounceVec.m_82553_() == 0.0) {
                ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceEndAnimation);
            } else {
                ((EntityImmortal)this.entity).shakeGround(0.0f, 32.0f, 0.125f, 2, 4);
                ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceHoldAnimation);
            }
        } else if (animation == ((EntityImmortal)this.entity).pounceHoldAnimation) {
            if (this.pounceVec.m_82553_() == 0.0 || this.distanceFactor == 0.0f) {
                ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceEndAnimation);
            } else if (tick < 40) {
                boolean flag;
                boolean bl = flag = this.targetCache != null;
                if (flag) {
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 10.0f, 10.0f);
                }
                float tickFactor = EMMathUtils.getTickFactor(tick, 40.0f, true);
                float speedMultiplier = EMMathUtils.calculateSpeedMultiplier(tickFactor, this.distanceFactor, 3.0f, 15.0f);
                double baseValue = ((EntityImmortal)this.entity).m_21172_(Attributes.f_22279_);
                double moveSpeed = Math.min(((EntityImmortal)this.entity).m_21133_(Attributes.f_22279_), baseValue + baseValue * 0.4);
                if (tick % 2 == 0) {
                    this.doHurtTarget(4.5f, 5.0f, 3.5f, 1.0f, 0.1f, false, false, true, 0.5f);
                }
                if (flag && ((EntityImmortal)this.entity).m_20280_((Entity)this.targetCache) <= ((EntityImmortal)this.entity).m_142593_(this.targetCache) + 9.0) {
                    speedMultiplier *= 0.5f;
                    this.distanceFactor = Math.min(this.getDistanceFactor(this.targetCache, 16.0f, true), 0.8f);
                    double heightDifference = Math.abs(((EntityImmortal)this.entity).m_20186_() - this.targetCache.m_20186_());
                    if (heightDifference >= 6.0 || ((EntityImmortal)this.entity).m_217043_().m_188501_() < 0.4f) {
                        ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pouncePickAnimation);
                    } else {
                        ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceSmashAnimation);
                    }
                } else if (speedMultiplier < 0.45f) {
                    ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceEndAnimation);
                }
                ((EntityImmortal)this.entity).m_20334_(this.pounceVec.f_82479_ * moveSpeed * (double)speedMultiplier, ((EntityImmortal)this.entity).m_20184_().f_82480_, this.pounceVec.f_82481_ * moveSpeed * (double)speedMultiplier);
            } else {
                ((EntityImmortal)this.entity).playAnimation(((EntityImmortal)this.entity).pounceEndAnimation);
            }
        } else if (animation == ((EntityImmortal)this.entity).pounceSmashAnimation) {
            if (tick < 9) {
                this.lookAtTarget();
                if (tick == 5) {
                    ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.6f, ((EntityImmortal)this.entity).m_6100_());
                }
            } else {
                ((EntityImmortal)this.entity).anchorToGround();
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
                if (tick == 9) {
                    ((EntityImmortal)this.entity).m_216990_((SoundEvent)SoundInit.IMMORTAL_SHAKE_GROUND.get());
                } else if (tick == 10) {
                    Vec3 pos = ((EntityImmortal)this.entity).getPosOffset(false, 3.0f, 0.5f, -1.0f);
                    for (LivingEntity entityHit : ShockWaveUtils.doRingShockWave(((EntityImmortal)this.entity).f_19853_, pos, 3.5, 0.0f, false, 20)) {
                        if (entityHit == this.entity) continue;
                        ((EntityImmortal)this.entity).doHurtTarget(entityHit, false, false, true, false, 0.025f, 1.0f, 0.9f);
                        ((EntityImmortal)this.entity).disableShield(entityHit, 50);
                        ((EntityImmortal)this.entity).knockBack(entityHit, 0.2, 0.5, false, false);
                    }
                } else if (tick == 11) {
                    ((EntityImmortal)this.entity).shakeGround(0.2f, 16.0f, 0.25f, 2, 4);
                } else if (tick == 12) {
                    ((EntityImmortal)this.entity).f_19853_.m_5594_(null, ((EntityImmortal)this.entity).m_20183_(), (SoundEvent)SoundInit.IMMORTAL_STONE_CRACK.get(), ((EntityImmortal)this.entity).m_5720_(), 1.0f, 1.0f);
                } else if (tick > 30 && this.targetCache != null) {
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 10.0f, 30.0f);
                }
            }
        } else if (animation == ((EntityImmortal)this.entity).pouncePickAnimation) {
            if (tick < 12) {
                this.lookAtTarget();
                if (tick >= 5 && this.distanceFactor > 0.0f) {
                    float tickFactor = EMMathUtils.getTickFactor(tick, 5.0f, false);
                    float speedMultiplier = EMMathUtils.calculateSpeedMultiplier(tickFactor, this.distanceFactor, 3.0f, 1.5f);
                    double moveSpeed = Math.min(((EntityImmortal)this.entity).m_21133_(Attributes.f_22279_), ((EntityImmortal)this.entity).m_21172_(Attributes.f_22279_));
                    double radians = Math.toRadians(((EntityImmortal)this.entity).m_146908_() + 90.0f);
                    ((EntityImmortal)this.entity).m_20334_(Math.cos(radians) * moveSpeed * (double)speedMultiplier, ((EntityImmortal)this.entity).m_20184_().f_82480_, Math.sin(radians) * moveSpeed * (double)speedMultiplier);
                }
                if (tick == 6) {
                    ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.6f, ((EntityImmortal)this.entity).m_6100_() + 0.2f);
                } else if (tick == 10) {
                    this.doHurtTarget(5.0f, 6.0f, 4.5f, 0.0f, 1.0f, true, true, false, 1.0f);
                    ((EntityImmortal)this.entity).shakeGround(0.0f, 16.0f, 0.25f, 2, 4);
                }
            } else {
                if (tick > 15 && this.targetCache != null) {
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 15.0f, 30.0f);
                }
                ((EntityImmortal)this.entity).m_146922_(((EntityImmortal)this.entity).f_19859_);
            }
        } else if (animation == ((EntityImmortal)this.entity).pounceEndAnimation && this.targetCache != null && this.targetCache.m_6084_()) {
            ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 10.0f, 30.0f);
        }
    }

    private void doHurtTarget(float range, float height, float hitDistance, float strength, float yStrength, boolean sendMessage, boolean heal, boolean stun, float damageMultiplier) {
        float attackArc = 120.0f;
        boolean hitFlag = !sendMessage;
        for (LivingEntity entityHit : ((EntityImmortal)this.entity).getNearByEntities(LivingEntity.class, range, height, range, range)) {
            float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, entityHit);
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) * (entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) + (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_()) * (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_())) - entityHit.m_20205_() / 2.0f;
            if (!((double)entityHitDistance < 0.75) && (!(entityHitDistance <= hitDistance) || !(entityRelativeAngle >= -attackArc / 2.0f && entityRelativeAngle <= attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + attackArc / 2.0f))) continue;
            if (stun) {
                ((EntityImmortal)this.entity).stun(null, entityHit, 40, false);
            }
            ((EntityImmortal)this.entity).doHurtTarget(entityHit, true, heal && entityHit.m_21023_((MobEffect)EffectInit.ERODE_EFFECT.get()), heal, false, 0.03f, 1.0f, damageMultiplier);
            if (!hitFlag) {
                hitFlag = true;
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_PUNCH_HIT.get(), 1.0f, 1.1f);
                ((EntityImmortal)this.entity).f_19853_.m_7605_((Entity)this.entity, (byte)8);
            }
            ((EntityImmortal)this.entity).knockBack(entityHit, strength, yStrength, true, false);
        }
    }

    private float getDistanceFactor(LivingEntity target, float distance, boolean inversion) {
        return EMMathUtils.getTickFactor(Math.min(((EntityImmortal)this.entity).m_20270_((Entity)target), distance * 2.0f), distance, inversion);
    }

    private void lookAtTarget() {
        if (!(((EntityImmortal)this.entity).m_5448_() == null || this.targetCache != null && this.targetCache.m_6084_())) {
            this.targetCache = ((EntityImmortal)this.entity).m_5448_();
        } else if (this.targetCache != null) {
            ((EntityImmortal)this.entity).m_21391_((Entity)this.targetCache, 30.0f, 30.0f);
            ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)this.targetCache, 30.0f, 30.0f);
        }
    }
}

