/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityImmortalMagicCircle;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ImmortalAttractGoal
extends AnimationAI<EntityImmortal> {
    public ImmortalAttractGoal(EntityImmortal entity) {
        super(entity);
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == ((EntityImmortal)this.entity).attractAnimation;
    }

    public void m_8037_() {
        int tick = ((EntityImmortal)this.entity).getAnimationTick();
        if (tick < 40) {
            if (tick < 38) {
                ((EntityImmortal)this.entity).anchorToGround();
            }
            this.slowlyLookAtTarget();
            if (tick == 29) {
                EntityImmortalMagicCircle.spawn(((EntityImmortal)this.entity).f_19853_, (LivingEntity)this.entity, ((EntityImmortal)this.entity).m_20182_().m_82520_(0.0, 0.25, 0.0), 2.5f, 0.0f, 10 + ((EntityImmortal)this.entity).m_217043_().m_188503_(11), ((EntityImmortal)this.entity).f_20885_, EntityImmortalMagicCircle.MagicCircleType.POWER, true);
            } else if (tick == 36) {
                ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_ATTACK.get(), 1.6f, ((EntityImmortal)this.entity).m_6100_());
            } else if (tick == 39) {
                ((EntityImmortal)this.entity).pursuit(8.0f, 0.0f, 0.5);
                ((EntityImmortal)this.entity).f_19853_.m_7605_((Entity)this.entity, (byte)9);
            }
        } else {
            if (tick == 40 || tick == 41 || tick == 42) {
                if (tick == 40) {
                    ((EntityImmortal)this.entity).shakeGround(0.0f, 20.0f, 0.25f, 2, 3);
                }
                float attackArc = 180.0f;
                boolean hitFlag = false;
                float attackDistance = 5.0f;
                for (LivingEntity entityHit : ((EntityImmortal)this.entity).getNearByEntities(LivingEntity.class, attackDistance, attackDistance, attackDistance, attackDistance)) {
                    float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, entityHit);
                    float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) * (entityHit.m_20189_() - ((EntityImmortal)this.entity).m_20189_()) + (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_()) * (entityHit.m_20185_() - ((EntityImmortal)this.entity).m_20185_())) - entityHit.m_20205_() / 2.0f;
                    if (entityHitDistance <= attackDistance && (entityRelativeAngle >= -attackArc / 2.0f && entityRelativeAngle <= attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f || entityRelativeAngle <= -360.0f + attackArc / 2.0f) && tick == 40) {
                        int preInvulnerableTime = entityHit.f_19802_;
                        entityHit.f_19802_ = 0;
                        ((EntityImmortal)this.entity).stun(null, entityHit, 40, false);
                        if (!((EntityImmortal)this.entity).doHurtTarget(entityHit, true, entityHit.m_21023_((MobEffect)EffectInit.ERODE_EFFECT.get()), false, false, 0.035f, 1.0f, 1.2f)) {
                            entityHit.f_19802_ = preInvulnerableTime;
                        }
                        if (!hitFlag) {
                            hitFlag = true;
                            ((EntityImmortal)this.entity).m_5496_((SoundEvent)SoundInit.IMMORTAL_PUNCH_HARD_HIT.get(), 1.2f, 1.1f);
                            ((EntityImmortal)this.entity).f_19853_.m_7605_((Entity)this.entity, (byte)10);
                        }
                    }
                    ((EntityImmortal)this.entity).knockBack(entityHit, 1.0, 0.2, true, tick > 40);
                }
                int offset = (int)(attackDistance / 2.0f);
                if (tick == 41 && ModEntityUtils.canMobDestroy((Entity)this.entity) && ModEntityUtils.advancedBreakBlocks(((EntityImmortal)this.entity).f_19853_, (LivingEntity)this.entity, 50.0f, offset, (int)attackDistance, offset, 0, offset, ((EntityImmortal)this.entity).checkCanDropItems(), true)) {
                    ((EntityImmortal)this.entity).f_19853_.m_7605_((Entity)this.entity, (byte)10);
                }
            }
            this.slowlyLookAtTarget();
        }
    }

    private void slowlyLookAtTarget() {
        LivingEntity target = ((EntityImmortal)this.entity).m_5448_();
        if (target != null) {
            float lookAtSpeed = 5.0f;
            if (((EntityImmortal)this.entity).m_20270_((Entity)target) > 5.0f) {
                lookAtSpeed = 90.0f;
            }
            ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, lookAtSpeed, 30.0f);
            ((EntityImmortal)this.entity).m_21391_((Entity)target, lookAtSpeed, 30.0f);
        }
    }
}

