/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.client.particle.base.ParticleRing;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.integration.curios.ICuriosApi;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrenzyCapability {
    public static final ResourceLocation ID = new ResourceLocation("eeeabsmobs", "frenzy_cap");

    public static class FrenzyCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<FrenzyCapabilityImpl> instance = LazyOptional.of(FrenzyCapabilityImpl::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.FRENZY_EFFECT_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT(nbt);
        }
    }

    public static class FrenzyCapabilityImpl
    implements IFrenzyCapability {
        private boolean isFrenzy;
        private long count;
        private int level;

        @Override
        public boolean isFrenzy() {
            return this.isFrenzy;
        }

        @Override
        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void onStart(LivingEntity entity) {
            if (entity != null) {
                this.isFrenzy = true;
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            if (this.isFrenzy && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_20301_(player.m_6062_());
                if (this.count <= 0L && player.f_19797_ % 10 == 0) {
                    player.m_36324_().m_38707_(1, 1.0f);
                }
                if (player.m_20142_() && !player.m_21211_().m_41720_().m_41472_()) {
                    if (this.count < 20L) {
                        ++this.count;
                    }
                } else if (this.count > 0L) {
                    --this.count;
                }
                if (this.count >= 20L && player.m_36324_().m_38702_() > 0) {
                    boolean inWater;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, this.level, false, false, true));
                    player.m_36399_(0.25f);
                    boolean bl = inWater = player.m_20069_() || player.isInFluidType((fluidType, height) -> player.canSwimInFluidType(fluidType));
                    if (inWater && player.m_20184_().m_165925_() < 0.46) {
                        Vec3 movement = player.m_20184_().m_82490_(1.05);
                        player.m_20256_(movement);
                    }
                    boolean checkCanDestroyBlock = (Boolean)EMConfigHandler.COMMON.OTHER.enableFrenzyDestroyBlock.get();
                    if (!player.f_19853_.f_46443_ && !inWater && checkCanDestroyBlock) {
                        Vec3 playerPos = player.m_20182_();
                        float yaw = player.m_146908_() * ((float)Math.PI / 180);
                        double forwardX = -Math.sin(yaw);
                        double forwardZ = Math.cos(yaw);
                        int side = (int)((double)player.m_20205_() + 1.5);
                        int forward = (int)((double)player.m_20205_() + 2.5);
                        for (int x = -side; x <= side; ++x) {
                            for (int z = -side; z <= side; ++z) {
                                int y = 0;
                                while ((float)y < player.m_20206_() + 1.0f) {
                                    double posX = playerPos.f_82479_ + forwardX * (double)forward + -forwardZ * (double)x;
                                    double posY = playerPos.f_82480_ + (double)y;
                                    double posZ = playerPos.f_82481_ + forwardZ * (double)forward + forwardX * (double)z;
                                    BlockPos pos = new BlockPos(posX, posY, posZ);
                                    if (ModEntityUtils.canDestroyBlock(player.f_19853_, pos, (Entity)player, 2.0f) && player.f_19853_.m_7702_(pos) == null) {
                                        player.f_19853_.m_46961_(pos, false);
                                    }
                                    ++y;
                                }
                            }
                        }
                    }
                    List entities = player.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)player, player.m_20191_());
                    for (LivingEntity hitEntity : entities) {
                        if (hitEntity == player || !hitEntity.m_6469_(DamageSource.m_19344_((Player)player), (float)this.level)) continue;
                        double angle = this.getAngleBetweenEntities((Entity)entity, (Entity)hitEntity);
                        double x = 3.0 * Math.cos(Math.toRadians(angle - 90.0));
                        double z = 3.0 * Math.sin(Math.toRadians(angle - 90.0));
                        hitEntity.m_20334_(x, 0.35, z);
                        hitEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 20, 0, false, false, true));
                    }
                    if (player.f_19853_.f_46443_) {
                        double x = player.m_20185_();
                        double y = player.m_20186_() + (double)(player.m_20206_() / 2.0f);
                        double z = player.m_20189_();
                        double motionX = player.m_20184_().f_82479_;
                        double motionY = player.m_20184_().f_82480_;
                        double motionZ = player.m_20184_().f_82481_;
                        if (player.f_19797_ % 3 == 0) {
                            if (inWater) {
                                for (int i = 0; i < 3; ++i) {
                                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123774_, player.m_20208_(1.5), player.m_20227_(0.5), player.m_20262_(1.5), -motionX * 0.25, -motionY * 0.25, -motionZ * 0.25);
                                }
                            } else {
                                player.f_19853_.m_7106_((ParticleOptions)new ParticleRing.RingData((float)Math.toRadians(-player.f_20883_), 0.0f, 30, 0.8f, 0.8f, 0.9f, 0.08f, 32.0f, false, ParticleRing.EnumRingBehavior.GROW_THEN_SHRINK), x + 8.0 * motionX, y + 1.5 * motionY, z + 8.0 * motionZ, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                }
            }
        }

        public double getAngleBetweenEntities(Entity attacker, Entity target) {
            return Math.atan2(target.m_20189_() - attacker.m_20189_(), target.m_20185_() - attacker.m_20185_()) * 57.29577951308232 + 90.0;
        }

        @Override
        public void onEnd(LivingEntity entity) {
            if (entity != null && this.isFrenzy) {
                this.count = 0L;
                this.isFrenzy = false;
                if (!entity.f_19853_.f_46443_) {
                    int durationTick = 120 * (this.level + 1);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        Item item = (Item)ItemInit.SOUL_SUMMONING_NECKLACE.get();
                        if (ICuriosApi.isLoaded() ? ICuriosApi.INSTANCE.isPresentInventory((LivingEntity)player, item) : player.m_150109_().f_35974_.stream().anyMatch(i -> i.m_150930_(item))) {
                            return;
                        }
                    }
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, durationTick, 1, false, true, true));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, durationTick, this.level, false, true, true));
                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.ARMOR_LOWER_EFFECT.get(), durationTick, this.level, false, true, true));
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("isFrenzy", this.isFrenzy);
            nbt.m_128405_("level", this.level);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.isFrenzy = nbt.m_128471_("isFrenzy");
            this.level = nbt.m_128451_("level");
        }
    }

    public static interface IFrenzyCapability
    extends INBTSerializable<CompoundTag> {
        public boolean isFrenzy();

        public void setLevel(int var1);

        public int getLevel();

        public void onStart(LivingEntity var1);

        public void onEnd(LivingEntity var1);

        public void tick(LivingEntity var1);
    }
}

