/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.util.anim;

public abstract class AnimData {
    public float evaluate(float t) {
        return 0.0f;
    }

    public static KeyTrack oscillate(float value1, float value2, int frequency) {
        if (frequency <= 1) {
            new KeyTrack(new float[]{value1, value2}, new float[]{0.0f, 1.0f});
        }
        float step = 1.0f / (float)frequency;
        float[] times = new float[frequency + 1];
        float[] values = new float[frequency + 1];
        for (int i = 0; i < frequency + 1; ++i) {
            float value = i % 2 == 0 ? value1 : value2;
            times[i] = step * (float)i;
            values[i] = value;
        }
        return new KeyTrack(values, times);
    }

    public static KeyTrack startAndEnd(float startValue, float endValue) {
        return new KeyTrack(new float[]{startValue, endValue}, new float[]{0.0f, 1.0f});
    }

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public static class KeyTrack
    extends AnimData {
        float[] values;
        float[] times;

        public KeyTrack(float[] values, float[] times) {
            this.values = values;
            this.times = times;
            if (values.length != times.length) {
                System.out.println("Malformed key track. Must have same number of keys and values or key track will evaluate to 0.");
            }
        }

        @Override
        public float evaluate(float t) {
            if (this.values.length != this.times.length) {
                return 0.0f;
            }
            for (int i = 0; i < this.times.length; ++i) {
                float time = this.times[i];
                if (t == time) {
                    return this.values[i];
                }
                if (t < time) {
                    if (i == 0) {
                        return this.values[0];
                    }
                    float a = (t - this.times[i - 1]) / (time - this.times[i - 1]);
                    return this.values[i - 1] * (1.0f - a) + this.values[i] * a;
                }
                if (i != this.values.length - 1) continue;
                return this.values[i];
            }
            return 0.0f;
        }
    }

    public static class Constant
    extends AnimData {
        float value;

        public Constant(float value) {
            this.value = value;
        }

        @Override
        public float evaluate(float t) {
            return this.value;
        }
    }

    public static class Oscillator
    extends AnimData {
        float value1;
        float value2;
        float frequency;
        float phaseShift;

        public Oscillator(float value1, float value2, float frequency, float phaseShift) {
            this.value1 = value1;
            this.value2 = value2;
            this.frequency = frequency;
            this.phaseShift = phaseShift;
        }

        @Override
        public float evaluate(float t) {
            float a = (this.value2 - this.value1) / 2.0f;
            return (float)((double)(this.value1 + a) + (double)a * Math.cos(t * this.frequency + this.phaseShift));
        }
    }
}

