/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.setup;

import com.calculusmaster.difficultraids.config.RaidDifficultyConfig;
import com.calculusmaster.difficultraids.config.RaiderConfigs;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class DifficultRaidsConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ForgeConfigSpec.IntValue WAVE_COUNT_EASY;
    public static ForgeConfigSpec.IntValue WAVE_COUNT_NORMAL;
    public static ForgeConfigSpec.IntValue WAVE_COUNT_HARD;
    public static ForgeConfigSpec.EnumValue<DifficultRaidsUtil.OverflowHandlingMode> OVERFLOW_MODE;
    public static ForgeConfigSpec.BooleanValue RESTRICTIVE_MODE;
    public static ForgeConfigSpec.DoubleValue BELL_SEARCH_RADIUS;
    public static ForgeConfigSpec.BooleanValue FRIENDLY_FIRE_ARROWS;
    public static ForgeConfigSpec.IntValue HIGHLIGHT_THRESHOLD;
    public static ForgeConfigSpec.BooleanValue BOSS_BARS;
    public static ForgeConfigSpec.BooleanValue SHOW_WAVE_INFORMATION;
    public static ForgeConfigSpec.BooleanValue INSANITY_MODE;
    public static ForgeConfigSpec.DoubleValue INSANITY_COUNT_MULTIPLIER;
    public static Map<String, ForgeConfigSpec.BooleanValue> ENABLED_RAIDERS;
    public static RaidDifficultyConfig DEFAULT;
    public static RaidDifficultyConfig HERO;
    public static RaidDifficultyConfig LEGEND;
    public static RaidDifficultyConfig MASTER;
    public static RaidDifficultyConfig GRANDMASTER;
    public static TagKey<EntityType<?>> WINDS_CURSE_IMMUNE;

    public static void initializeConfigs() {
        DEFAULT.init();
        HERO.init();
        LEGEND.init();
        MASTER.init();
        GRANDMASTER.init();
    }

    public static void register() {
        ForgeConfigSpec.Builder GENERAL = new ForgeConfigSpec.Builder();
        GENERAL.push("Wave Amounts");
        WAVE_COUNT_EASY = GENERAL.comment("Number of waves in a Raid on Easy difficulty.").defineInRange("waveCountEasy", 3, 1, Integer.MAX_VALUE);
        WAVE_COUNT_NORMAL = GENERAL.comment("Number of waves in a Raid on Normal difficulty.").defineInRange("waveCountNormal", 5, 1, Integer.MAX_VALUE);
        WAVE_COUNT_HARD = GENERAL.comment("Number of waves in a Raid on Hard difficulty.").defineInRange("waveCountHard", 7, 1, Integer.MAX_VALUE);
        OVERFLOW_MODE = GENERAL.comment("Advanced config. Only edit if you're working with the datapack configuration!").comment("Determines how the mod will handle the case where a raider does not have a spawn count defined for a wave.").comment("This can happen if the number of waves is changed, but the spawn counts list for a raider is not updated.").comment("ZERO: The raider will not spawn if it does not have a spawn count defined for the current wave.").comment("REPEAT: The raider will spawn with the last wave's (whatever the last registered wave is for it) spawn count for the current wave.").defineEnum("arrayOverflowMode", (Enum)DifficultRaidsUtil.OverflowHandlingMode.ZERO, (Enum[])new DifficultRaidsUtil.OverflowHandlingMode[]{DifficultRaidsUtil.OverflowHandlingMode.ZERO, DifficultRaidsUtil.OverflowHandlingMode.REPEAT});
        RESTRICTIVE_MODE = GENERAL.comment("If enabled, this will make it so that if a raider is not registered implicitly by DifficultRaids, or a datapack, it will not spawn in higher difficulty raids.").comment("This can be used if you want full control over raid spawns, and do not want other mods to inject their raiders if not registered by DifficultRaids or a datapack.").define("restrictiveMode", false);
        GENERAL.pop();
        GENERAL.push("Raid Mechanics");
        BELL_SEARCH_RADIUS = GENERAL.comment("Search radius of the Bell when hit.").comment("WARNING: This can cause a decent bit of lag at high radius values because it will search more and more blocks around the village center.").comment("Vanilla Minecraft uses a radius of 48 blocks.").defineInRange("bellSearchRadius", 256.0, 0.0, 2.147483647E9);
        FRIENDLY_FIRE_ARROWS = GENERAL.comment("Toggles whether arrows fired by Raiders (such as Pillagers) can deal damage to other Raiders.").define("friendlyFireArrowsEnabled", false);
        GENERAL.pop();
        GENERAL.push("UI");
        HIGHLIGHT_THRESHOLD = GENERAL.comment("If there are fewer raiders alive than this threshold, they will be highlighted permanently. Set to 0 to disable highlighting.").defineInRange("highlightThreshold", 3, 0, Integer.MAX_VALUE);
        BOSS_BARS = GENERAL.comment("Toggles whether Boss Bars for Elite Raiders/Bosses will show up during Raids.").comment(new String[]{"Enabling this will create Boss Event Bars for:", "DifficultRaids: Nuaos, Xydrax, Voldon, Modur", "Illage & Spillage: Freakager, Magispeller, Spiritcaller", "Dungeons Mobs: Redstone Golem", "Leo's Illagers: Lightningcaller, Clownager"}).define("bossBarsEnabled", true);
        SHOW_WAVE_INFORMATION = GENERAL.comment("Determines if wave information will show up in the Raid Event title.").define("showWaveInformation", true);
        GENERAL.pop();
        GENERAL.push("Insanity Mode");
        INSANITY_MODE = GENERAL.comment("Activate Insanity mode.").comment("'Detecting hundreds of raiders in the region. Are you certain whatever you're doing is worth it?'").define("insanityMode", false);
        INSANITY_COUNT_MULTIPLIER = GENERAL.comment("The multiplier for the number of raiders spawned in Insanity mode.").comment("This gets applied on top of whatever difficulty a Raid is at. This will not apply to Default Raids.").defineInRange("insanityCountMultiplier", 3.0, 1.0, Double.MAX_VALUE);
        GENERAL.pop();
        GENERAL.comment("Customize which Raiders will show up in Raids. By default, all raiders are enabled.").push("Enabled Raiders");
        ENABLED_RAIDERS.put("VINDICATOR", GENERAL.define("enableVindicators", true));
        ENABLED_RAIDERS.put("EVOKER", GENERAL.define("enableEvokers", true));
        ENABLED_RAIDERS.put("PILLAGER", GENERAL.define("enablePillagers", true));
        ENABLED_RAIDERS.put("WITCH", GENERAL.define("enableWitches", true));
        ENABLED_RAIDERS.put("RAVAGER", GENERAL.define("enableRavagers", true));
        ENABLED_RAIDERS.put("ILLUSIONER", GENERAL.define("enableIllusioners", true));
        ENABLED_RAIDERS.put("WARRIOR_ILLAGER", GENERAL.define("enableWarriors", true));
        ENABLED_RAIDERS.put("DART_ILLAGER", GENERAL.define("enableDarts", true));
        ENABLED_RAIDERS.put("ELECTRO_ILLAGER", GENERAL.define("enableConductors", true));
        ENABLED_RAIDERS.put("NECROMANCER_ILLAGER", GENERAL.define("enableNecromancers", true));
        ENABLED_RAIDERS.put("SHAMAN_ILLAGER", GENERAL.define("enableShamans", true));
        ENABLED_RAIDERS.put("TANK_ILLAGER", GENERAL.define("enableTanks", true));
        ENABLED_RAIDERS.put("ASSASSIN_ILLAGER", GENERAL.define("enableAssassins", true));
        ENABLED_RAIDERS.put("FROST_ILLAGER", GENERAL.define("enableFrostmages", true));
        ENABLED_RAIDERS.put("ASHENMANCER_ILLAGER", GENERAL.define("enableAshenmancers", true));
        GENERAL.push("Requires HunterIllager");
        ENABLED_RAIDERS.put("hunterillager", GENERAL.define("enableHunters", true));
        GENERAL.pop().push("Requires EnchantWithMob");
        ENABLED_RAIDERS.put("enchanter", GENERAL.define("enableEnchanters", true));
        GENERAL.pop().push("Requires It Takes a Pillage");
        ENABLED_RAIDERS.put("ARCHER", GENERAL.define("enableArchers", true));
        ENABLED_RAIDERS.put("SKIRMISHER", GENERAL.define("enableSkirmishers", true));
        ENABLED_RAIDERS.put("LEGIONER", GENERAL.define("enableLegioners", true));
        GENERAL.pop().push("Requires Illage & Spillage");
        ENABLED_RAIDERS.put("entity.illageandspillage.igniter", GENERAL.define("enableIgniters", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.twittollager", GENERAL.define("enableTwittollagers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.preserver", GENERAL.define("enablePreservers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.absorber", GENERAL.define("enableAbsorbers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.crocofang", GENERAL.define("enableCrocofangs", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.magispeller", GENERAL.define("enableMagispellers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.spiritcaller", GENERAL.define("enableSpiritcallers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.freakager", GENERAL.define("enableFreakagers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.boss_randomizer", GENERAL.define("enableBossRandomizers", true));
        GENERAL.pop().push("Requires Savage and Ravage");
        ENABLED_RAIDERS.put("GRIEFER", GENERAL.define("enableGriefers", true));
        ENABLED_RAIDERS.put("EXECUTIONER", GENERAL.define("enableExecutioners", true));
        ENABLED_RAIDERS.put("TRICKSTER", GENERAL.define("enableTricksters", true));
        ENABLED_RAIDERS.put("SR_ICEOLOGER", GENERAL.define("enableSavageRavageIceologers", true));
        GENERAL.pop().push("Requires Dungeon Mobs");
        ENABLED_RAIDERS.put("mountaineer", GENERAL.define("enableMountaineers", true));
        ENABLED_RAIDERS.put("royal_guard", GENERAL.define("enableRoyalGuards", true));
        ENABLED_RAIDERS.put("geomancer", GENERAL.define("enableGeomancers", true));
        ENABLED_RAIDERS.put("DM_ILLUSIONER", GENERAL.define("enableDungeonMobsIllusioners", true));
        ENABLED_RAIDERS.put("mage", GENERAL.define("enableMages", true));
        ENABLED_RAIDERS.put("iceologer", GENERAL.define("enableDungeonMobsIceologers", true));
        ENABLED_RAIDERS.put("windcaller", GENERAL.define("enableWindcallers", true));
        ENABLED_RAIDERS.put("squall_golem", GENERAL.define("enableSquallGolems", true));
        ENABLED_RAIDERS.put("redstone_golem", GENERAL.define("enableRedstoneGolems", true));
        GENERAL.pop();
        GENERAL.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GENERAL.build(), "difficultraids/general.toml");
        block7: for (RaidDifficulty rd : RaidDifficulty.values()) {
            RaidDifficultyConfig config = new RaidDifficultyConfig();
            ForgeConfigSpec.Builder spec = new ForgeConfigSpec.Builder();
            if (rd == RaidDifficulty.DEFAULT) {
                spec.comment("Note: Changing values in this config will have no impact on the game. Default Raids are Vanilla and do not feature anything from this mod. The config file exists for consistency within the code.\n");
            } else {
                spec.comment("Edit config values for " + rd.getFormattedName() + " Raids.\n");
            }
            spec.push("General Settings");
            config.elitesEnabled = spec.comment("Determines if Elite Raiders will show up in Raids.").define("elitesEnabled", true);
            config.playerHealthBoostAmount = spec.comment("Extra health that Raiders will receive per additional player in the Raid. 0 to disable Raiders receiving extra health.").defineInRange("playerHealthBoostAmount", 2.0, 0.0, Double.MAX_VALUE);
            spec.pop();
            spec.push("Vindicator Settings");
            config.vindicator = new RaiderConfigs.Vindicator(rd, spec);
            spec.pop();
            spec.push("Evoker Settings");
            config.evoker = new RaiderConfigs.Evoker(rd, spec);
            spec.pop();
            spec.push("Pillager Settings");
            config.pillager = new RaiderConfigs.Pillager(rd, spec);
            spec.pop();
            spec.push("Ravager Settings");
            config.ravager = new RaiderConfigs.Ravager(rd, spec);
            spec.pop();
            spec.push("Warrior Settings");
            config.warrior = new RaiderConfigs.Warrior(rd, spec);
            spec.pop();
            spec.push("Dart Settings");
            config.dart = new RaiderConfigs.Dart(rd, spec);
            spec.pop();
            spec.push("Conductor Settings");
            config.conductor = new RaiderConfigs.Conductor(rd, spec);
            spec.pop();
            spec.push("Necromancer Settings");
            config.necromancer = new RaiderConfigs.Necromancer(rd, spec);
            spec.pop();
            spec.push("Shaman Settings");
            config.shaman = new RaiderConfigs.Shaman(rd, spec);
            spec.pop();
            spec.push("Tank Settings");
            config.tank = new RaiderConfigs.Tank(rd, spec);
            spec.pop();
            spec.push("Assassin Settings");
            config.assassin = new RaiderConfigs.Assassin(rd, spec);
            spec.pop();
            spec.push("Frostmage Settings");
            config.frostmage = new RaiderConfigs.Frostmage(rd, spec);
            spec.pop();
            spec.push("Ashenmancer Settings");
            config.ashenmancer = new RaiderConfigs.Ashenmancer(rd, spec);
            spec.pop();
            spec.push("Elite Raiders");
            spec.push("Nuaos Settings");
            config.nuaos = new RaiderConfigs.Nuaos(rd, spec);
            spec.pop();
            spec.push("Xydrax Settings");
            config.xydrax = new RaiderConfigs.Xydrax(rd, spec);
            spec.pop();
            spec.push("Modur Settings");
            config.modur = new RaiderConfigs.Modur(rd, spec);
            spec.pop();
            spec.push("Voldon Settings");
            config.voldon = new RaiderConfigs.Voldon(rd, spec);
            spec.pop();
            spec.pop();
            spec.push("Compatibility");
            spec.comment("REQUIRES 'HunterIllager'").push("Hunter Illager Settings");
            config.hunter = new RaiderConfigs.Hunter(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Archer Settings");
            config.archer = new RaiderConfigs.Archer(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Skirmisher Settings");
            config.skirmisher = new RaiderConfigs.Skirmisher(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Legioner Settings");
            config.legioner = new RaiderConfigs.Legioner(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Savage and Ravage'").push("Executioner Settings");
            config.executioner = new RaiderConfigs.Executioner(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Dungeon Mobs'").push("Mountaineer Settings");
            config.mountaineer = new RaiderConfigs.Mountaineer(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Dungeon Mobs'").push("Royal Guard Settings");
            config.royalguard = new RaiderConfigs.RoyalGuard(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Leo's Illagers'").push("Vindicator With Shield Settings");
            config.vindicatorWithShield = new RaiderConfigs.VindicatorWithShield(rd, spec);
            spec.pop();
            spec.pop();
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec.build(), "difficultraids/raid-" + rd.toString().toLowerCase() + ".toml");
            switch (rd) {
                case DEFAULT: {
                    DEFAULT = config;
                    continue block7;
                }
                case HERO: {
                    HERO = config;
                    continue block7;
                }
                case LEGEND: {
                    LEGEND = config;
                    continue block7;
                }
                case MASTER: {
                    MASTER = config;
                    continue block7;
                }
                case GRANDMASTER: {
                    GRANDMASTER = config;
                }
            }
        }
    }

    static {
        ENABLED_RAIDERS = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        WINDS_CURSE_IMMUNE = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("difficultraids:winds_curse_immune"));
    }
}

