/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.config.RaidDifficultyConfig;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractIllagerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEnchantments;
import com.calculusmaster.difficultraids.util.Compat;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.entities.Guard;

public class NuaosEliteEntity
extends AbstractIllagerVariant {
    private final Component ELITE_NAME = Component.m_237115_((String)"com.calculusmaster.difficultraids.elite_event.nuaos");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent(this.ELITE_NAME, BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private static final EntityDataAccessor<Float> STORED_CHARGE_DAMAGE = SynchedEntityData.m_135353_(NuaosEliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int ticksLastDamageTaken = 0;

    public NuaosEliteEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new NuaosMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof IronGolem || Compat.GUARD_VILLAGERS.isLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount *= this.config().nuaos.friendlyDamageReduction;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        RaidDifficultyConfig cfg = this.config();
        ItemStack sword = this.m_21205_();
        sword.m_41663_(Enchantments.f_44977_, cfg.nuaos.sharpnessLevel);
        sword.m_41663_((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get(), cfg.nuaos.criticalBurstLevel);
        sword.m_41663_((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get(), cfg.nuaos.criticalStrikeLevel);
        this.m_21008_(InteractionHand.MAIN_HAND, sword);
        this.m_21409_(EquipmentSlot.MAINHAND, cfg.nuaos.swordDropChance);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42393_));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void increaseChargedDamage(float amount) {
        ChargeState prevState = this.getChargeState();
        this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(this.getStoredChargeDamage() + amount));
        if (prevState != this.getChargeState()) {
            this.m_5496_(SoundEvents.f_12350_, 2.0f, 1.0f);
        }
    }

    public void resetStoredChargeDamage() {
        this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void resetLastDamageTakenTicks() {
        this.ticksLastDamageTaken = 0;
    }

    public float getStoredChargeDamage() {
        return ((Float)this.f_19804_.m_135370_(STORED_CHARGE_DAMAGE)).floatValue();
    }

    public float getMaxChargeDamage() {
        return this.isInDifficultRaid() ? this.getRaidDifficulty().config().nuaos.maxChargeDamage : 50.0f;
    }

    public ChargeState getChargeState() {
        double percentCharged = this.getStoredChargeDamage() / this.getMaxChargeDamage();
        if (percentCharged < (double)0.05f) {
            return ChargeState.NO_CHARGE;
        }
        if (percentCharged < (double)0.3f) {
            return ChargeState.LOW_CHARGE;
        }
        if (percentCharged < (double)0.8f) {
            return ChargeState.HIGH_CHARGE;
        }
        return ChargeState.MAX_CHARGE;
    }

    public void m_8119_() {
        ChargeState charge;
        super.m_8119_();
        if (this.f_19797_ % 8 == 0 && ((charge = this.getChargeState()) == ChargeState.HIGH_CHARGE || charge == ChargeState.MAX_CHARGE)) {
            for (int i = 0; i < 3; ++i) {
                BlockPos particlePos = new BlockPos(this.m_146892_()).m_7637_(0.65 - (double)this.f_19796_.m_188501_() * 0.8, 0.25 + (double)this.f_19796_.m_188501_() * 0.1, 0.65 - (double)this.f_19796_.m_188501_() * 0.8);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)particlePos.m_123341_(), (double)particlePos.m_123342_(), (double)particlePos.m_123343_(), 0.05, 0.2, 0.05);
            }
        }
    }

    protected void m_8024_() {
        RaidDifficulty rd;
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
        RaidDifficulty raidDifficulty = rd = this.isInDifficultRaid() ? this.getRaidDifficulty() : RaidDifficulty.DEFAULT;
        if (this.config().nuaos.chargeDecay && this.ticksLastDamageTaken++ > 200) {
            float decayPercent = this.f_19796_.m_188501_() * 0.1f + 0.005f;
            float stored = this.getStoredChargeDamage() - this.getMaxChargeDamage() * decayPercent;
            if (stored <= 0.0f) {
                this.resetStoredChargeDamage();
            } else {
                this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(stored));
            }
        }
        if (this.getStoredChargeDamage() >= this.getMaxChargeDamage()) {
            this.resetStoredChargeDamage();
            this.m_5496_(SoundEvents.f_11913_, 1.2f, 0.8f);
            ArrayList<EntityType> canReceiveDamage = new ArrayList<EntityType>(List.of(EntityType.f_20492_, EntityType.f_20532_, EntityType.f_20460_));
            if (Compat.GUARD_VILLAGERS.isLoaded()) {
                canReceiveDamage.add((EntityType)GuardEntityType.GUARD.get());
            }
            double shockwaveRadius = rd.config().nuaos.shockwaveRadius;
            AABB shockwaveAABB = new AABB(this.m_20183_()).m_82400_(shockwaveRadius);
            List targets = this.f_19853_.m_6443_(LivingEntity.class, shockwaveAABB, entity -> canReceiveDamage.stream().anyMatch(type -> entity.m_6095_().equals(type)));
            if (!targets.isEmpty()) {
                float minDamage = this.getMaxChargeDamage() * 0.25f;
                float falloffStartDistance = 0.05f;
                for (LivingEntity t : targets) {
                    float damage;
                    double distance = this.m_20270_((Entity)t);
                    if (distance <= (double)falloffStartDistance) {
                        damage = this.getMaxChargeDamage();
                    } else {
                        float falloffDamage = (float)((1.0 - (distance - (double)falloffStartDistance) / shockwaveRadius) * (double)this.getMaxChargeDamage());
                        damage = Math.max(falloffDamage, minDamage);
                    }
                    t.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
                }
            }
        }
        if (this.f_19797_ % 80 == 0) {
            AABB auraRadius = new AABB(this.m_20183_()).m_82400_((double)rd.config().nuaos.buffAuraRadius);
            int strengthAmplifier = rd.config().nuaos.buffAuraStrengthLevel;
            this.f_19853_.m_6443_(Raider.class, auraRadius, r -> DifficultRaidsUtil.STANDARD_RAIDERS.contains(r.m_6095_())).forEach(raider -> {
                if (!raider.m_21023_(MobEffects.f_19600_)) {
                    raider.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, strengthAmplifier, false, true));
                }
            });
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12436_, SoundSource.HOSTILE, 3.0f, 1.0f, false);
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)DifficultRaidsConfig.BOSS_BARS.get()).booleanValue()) {
            this.ELITE_EVENT.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : super.m_6768_();
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12579_;
    }

    class NuaosMeleeAttackGoal
    extends MeleeAttackGoal {
        private NuaosMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            AttributeModifier damageBoost = new AttributeModifier("NUAOS_CHARGED_DAMAGE_BOOST", NuaosEliteEntity.this.config().nuaos.chargedDamageBoost.get(NuaosEliteEntity.this.getChargeState().ordinal()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeInstance attackDamageInstance = NuaosEliteEntity.this.m_21051_(Attributes.f_22281_);
            if (attackDamageInstance != null) {
                attackDamageInstance.m_22118_(damageBoost);
            }
            super.m_6739_(pEnemy, pDistToEnemySqr);
            if (attackDamageInstance != null) {
                attackDamageInstance.m_22130_(damageBoost);
            }
        }
    }

    public static enum ChargeState {
        NO_CHARGE,
        LOW_CHARGE,
        HIGH_CHARGE,
        MAX_CHARGE;

    }
}

