/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.data.raiderentries;

import com.calculusmaster.difficultraids.data.raiderentries.RaiderEntry;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;

public class DifficultyRaiderEntries {
    public static Codec<DifficultyRaiderEntries> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.comapFlatMap(DifficultyRaiderEntries::parseRaidDifficulty, Enum::toString).fieldOf("difficulty").forGetter(o -> o.raidDifficulty), (App)RaiderEntry.CODEC.listOf().fieldOf("values").forGetter(o -> o.values)).apply((Applicative)instance, DifficultyRaiderEntries::new));
    private final RaidDifficulty raidDifficulty;
    private final List<RaiderEntry> values;

    private static DataResult<RaidDifficulty> parseRaidDifficulty(String difficultyString) {
        try {
            return DataResult.success((Object)((Object)RaidDifficulty.valueOf(difficultyString.toUpperCase())));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)("Invalid Raid Difficulty: " + difficultyString));
        }
    }

    public RaidDifficulty getRaidDifficulty() {
        return this.raidDifficulty;
    }

    public List<RaiderEntry> getValues() {
        return this.values;
    }

    public DifficultyRaiderEntries(RaidDifficulty raidDifficulty, List<RaiderEntry> values) {
        this.raidDifficulty = raidDifficulty;
        this.values = values;
    }
}

