/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.IMessage;
import com.brutalbosses.network.VanillaParticleMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class Network {
    private static final String PROTOCOL_VERSION = "1";
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("brutalbosses", "main"), () -> "1", e -> true, e -> true);
    public static final Network instance = new Network();

    private Network() {
    }

    public void registerMessages() {
        this.channel.registerMessage(1, BossCapMessage.class, BossCapMessage::write, p -> {
            BossCapMessage msg = new BossCapMessage();
            msg.read((FriendlyByteBuf)p);
            return msg;
        }, (p, c) -> this.catchErrorsFor(() -> Network.lambda$registerMessages$4(p, (Supplier)c)));
        this.channel.registerMessage(2, BossOverlayMessage.class, BossOverlayMessage::write, p -> {
            BossOverlayMessage msg = new BossOverlayMessage();
            msg.read((FriendlyByteBuf)p);
            return msg;
        }, (p, c) -> this.catchErrorsFor(() -> Network.lambda$registerMessages$7(p, (Supplier)c)));
        this.channel.registerMessage(3, VanillaParticleMessage.class, VanillaParticleMessage::write, p -> {
            VanillaParticleMessage msg = new VanillaParticleMessage();
            msg.read((FriendlyByteBuf)p);
            return msg;
        }, (p, c) -> this.catchErrorsFor(() -> Network.lambda$registerMessages$10(p, (Supplier)c)));
        this.channel.registerMessage(4, BossTypeSyncMessage.class, BossTypeSyncMessage::write, p -> {
            BossTypeSyncMessage msg = new BossTypeSyncMessage();
            msg.read((FriendlyByteBuf)p);
            return msg;
        }, (p, c) -> this.catchErrorsFor(() -> Network.lambda$registerMessages$13(p, (Supplier)c)));
    }

    private void catchErrorsFor(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            BrutalBosses.LOGGER.warn("error during packet:", (Throwable)e);
        }
    }

    public void sendPacket(ServerPlayer Player2, IMessage msg) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> Player2), (Object)msg);
    }

    private static /* synthetic */ void lambda$registerMessages$13(BossTypeSyncMessage p, Supplier c) {
        p.handle(c);
    }

    private static /* synthetic */ void lambda$registerMessages$10(VanillaParticleMessage p, Supplier c) {
        p.handle(c);
    }

    private static /* synthetic */ void lambda$registerMessages$7(BossOverlayMessage p, Supplier c) {
        p.handle(c);
    }

    private static /* synthetic */ void lambda$registerMessages$4(BossCapMessage p, Supplier c) {
        p.handle(c);
    }
}

