/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class GameStageCommand {
    static final IParameter<String> GAME_STAGE = Command.string().named("name").suggests(() -> GameStageHelper.getGameStages().stream().map(GameStage::getId).toList());
    static final IParameter<List<? extends Entity>> ENTITIES = Command.entities();

    private static int set(CommandData data) throws CommandSyntaxException {
        String name = (String)data.get(GAME_STAGE);
        GameStage gameStage = GameStageHelper.getGameStages().stream().filter(stage -> stage.is(name)).findFirst().orElseThrow();
        Optional entities = data.getOptional(ENTITIES);
        if (GameStageCommand.isInvalid(data, entities.isPresent())) {
            return -1;
        }
        entities.map(GameStageCommand::toPlayers).orElse(GameStageCommand.getNullList()).forEach(player -> {
            boolean hasGameStageChanged = player != null ? GameStageHelper.setGameStage(gameStage, player) : GameStageHelper.setGlobalGameStage(gameStage);
            GameStageCommand.send(data, hasGameStageChanged ? "changed" : "cannot_change", player);
        });
        return 0;
    }

    private static int get(CommandData data) throws CommandSyntaxException {
        Optional entities = data.getOptional(ENTITIES);
        if (GameStageCommand.isInvalid(data, entities.isPresent())) {
            return -1;
        }
        entities.map(GameStageCommand::toPlayers).orElse(GameStageCommand.getNullList()).forEach(player -> GameStageCommand.send(data, "current", player));
        return 0;
    }

    private static void send(CommandData data, String id, @Nullable Player player) {
        String messageId = "commands.gamestage.%s.%s".formatted(player != null ? "player" : "global", id);
        MutableComponent component = player != null ? TextHelper.translatable((String)messageId, (Object[])new Object[]{GameStageHelper.getGameStage(player).getComponent(), player.m_5446_()}) : TextHelper.translatable((String)messageId, (Object[])new Object[]{GameStageHelper.getGlobalGameStage().getComponent()});
        data.source.m_81354_((Component)component, true);
    }

    private static boolean isInvalid(CommandData data, boolean arePlayersDefined) {
        if (!GameStageHelper.isPerPlayerDifficultyEnabled() && arePlayersDefined) {
            data.source.m_81352_((Component)TextHelper.translatable((String)"commands.gamestage.player.disabled", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static List<Player> toPlayers(List<? extends Entity> entities) {
        return entities.stream().filter(entity -> entity instanceof Player).map(Player.class::cast).toList();
    }

    private static List<Player> getNullList() {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(null);
        return players;
    }

    static {
        Command.create().literal(new String[]{"gamestage", "gamestate"}).hasPermission(4).parameter(GAME_STAGE).execute(GameStageCommand::set).parameter(ENTITIES).execute(GameStageCommand::set).register();
        Command.create().literal(new String[]{"gamestage", "gamestate"}).hasPermission(4).execute(GameStageCommand::get).parameter(ENTITIES).execute(GameStageCommand::get).register();
    }
}

