/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.modhelper.Resource;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Tank
extends Monster
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("tank_animations", AnimationsDef.class);
    private final Animations animations = Animations.create();

    public static EntityType<Tank> createEntityType() {
        return EntityType.Builder.m_20704_(Tank::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.99f, 2.7f).m_20712_("tank");
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 140.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22282_, 3.5).m_22268_(Attributes.f_22278_, 0.75).m_22265_();
    }

    public Tank(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.6f;
    }

    public int m_213860_() {
        return Random.nextInt((int)10, (int)17);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (!this.m_20067_()) {
            SoundEmitter.of((SoundEvent)sound).volume(SoundEmitter.randomized((float)(volume * 1.25f))).pitch(SoundEmitter.randomized((float)(pitch * 0.75f))).source(this.m_5720_()).position(this.m_20182_()).emit(this.m_9236_());
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.35f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TankMeleeAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private static class TankMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Tank tank;

        public TankMeleeAttackGoal(Tank tank) {
            super((PathfinderMob)tank, 1.0, true);
            this.tank = tank;
        }

        public void m_8037_() {
            super.m_8037_();
            this.tank.m_21561_(!this.tank.animations.isEmpty());
        }

        protected void m_6739_(LivingEntity target, double distanceSqr) {
            if (distanceSqr > this.m_6639_(target) || !this.tank.animations.isEmpty()) {
                return;
            }
            this.m_25563_();
            if (Random.check((float)0.25f)) {
                this.useHeavyAttack(target);
            } else {
                this.useNormalAttack(target);
            }
        }

        private void useHeavyAttack(LivingEntity target) {
            this.tank.playAnimation("heavy_attack").addCallback(11, () -> {
                Level patt5672$temp = target.m_9236_();
                if (!(patt5672$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel level = (ServerLevel)patt5672$temp;
                Vec3 position = this.getHeavyAttackPosition();
                this.spawnGroundParticles(level, position);
                this.hitAllNearbyEntities(level, position);
                this.playHitSound(1.5f);
            });
        }

        private void useNormalAttack(LivingEntity target) {
            this.tank.playAnimation((String)Random.next((Object[])new String[]{"normal_attack_left", "normal_attack_right"})).addCallback(9, () -> {
                if (this.tryToHitEntity(target)) {
                    this.playHitSound(0.8f);
                }
            });
        }

        private void hitAllNearbyEntities(ServerLevel level, Vec3 position) {
            for (LivingEntity entity : EntityHelper.getEntitiesNearby(LivingEntity.class, (ServerLevel)level, (Vec3)position, (double)2.5)) {
                ServerPlayer player;
                if (entity.equals((Object)this.tank) || !this.tryToHitEntity(entity) || !(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).m_21254_()) continue;
                player.m_36384_(true);
            }
        }

        private boolean tryToHitEntity(LivingEntity entity) {
            if (this.tank.m_21040_(entity, TargetingConditions.f_26872_)) {
                return this.tank.m_7327_((Entity)entity);
            }
            return false;
        }

        private Vec3 getHeavyAttackPosition() {
            return AnyPos.from((Vec3)this.tank.m_20182_()).add(EntityHelper.getDirection2d((Entity)this.tank).mul((Number)2.0)).vec3();
        }

        private void spawnGroundParticles(ServerLevel level, Vec3 position) {
            BlockState blockState = LevelHelper.findBlockPosOnGround((Level)level, (Vec3)position, (Number)5).map(blockPos -> level.m_8055_(blockPos.m_7495_())).orElse(Blocks.f_50493_.m_49966_());
            ParticleEmitter.of((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState)).position(AnyPos.from((Vec3)position).add((Number)0.0, (Number)0.25, (Number)0.0).vec3()).offset(() -> new Vec3(1.0, 0.25, 1.0)).count(120).speed(0.5f).emit((Level)level);
        }

        private void playHitSound(float factor) {
            this.f_25540_.m_5496_(SoundEvents.f_12381_, 0.75f * factor, 0.8f / factor);
        }
    }
}

