/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.bloodmoon;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.bloodmoon.BloodMoon;
import com.majruszsdifficulty.bloodmoon.BloodMoonClient;
import com.majruszsdifficulty.bloodmoon.BloodMoonConfig;
import com.majruszsdifficulty.data.WorldData;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BloodMoonHelper {
    private static BloodMoon BLOOD_MOON = new BloodMoon();

    public static boolean start() {
        if (BLOOD_MOON.start()) {
            MajruszsDifficulty.WORLD_DATA.setDirty();
            return true;
        }
        return false;
    }

    public static boolean stop() {
        if (BLOOD_MOON.finish()) {
            MajruszsDifficulty.WORLD_DATA.setDirty();
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getColorRatio() {
        return BloodMoonClient.COLOR_RATIO;
    }

    public static long getRelativeDayTime() {
        return Optional.ofNullable(Side.getServer()).map(server -> server.m_129783_().m_46468_() % 24000L).orElse(0L);
    }

    public static boolean isActive() {
        return BLOOD_MOON.isActive();
    }

    public static boolean isValidDayTime() {
        return BloodMoonConfig.TIME.within((Number)BloodMoonHelper.getRelativeDayTime());
    }

    static {
        Serializables.getStatic(WorldData.class).define("blood_moon", Reader.custom(BloodMoon::new), () -> BLOOD_MOON, v -> {
            BLOOD_MOON = v;
        });
        Serializables.getStatic(WorldData.Client.class).define("blood_moon", Reader.bool(), () -> BLOOD_MOON.isActive(), v -> {
            BloodMoonHelper.BLOOD_MOON.isActive = v;
        });
    }
}

