/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.events.type.IEntityEvent;
import java.util.function.Consumer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class OnEntityPreDamaged
implements ICancellableEvent,
IEntityEvent {
    public final DamageSource source;
    @Nullable
    public final LivingEntity attacker;
    public final LivingEntity target;
    public final float original;
    public float damage;
    public boolean spawnCriticalParticles = false;
    public boolean spawnMagicParticles = false;
    private boolean isCancelled = false;

    public static Event<OnEntityPreDamaged> listen(Consumer<OnEntityPreDamaged> consumer) {
        return Events.get(OnEntityPreDamaged.class).add(consumer);
    }

    public OnEntityPreDamaged(DamageSource source, LivingEntity target, float damage) {
        LivingEntity entity;
        this.source = source;
        Entity entity2 = this.source.m_7639_();
        this.attacker = entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
        this.target = target;
        this.original = damage;
        this.damage = damage;
    }

    @Override
    public boolean isExecutionStopped() {
        return this.isDamageCancelled();
    }

    @Override
    public Entity getEntity() {
        return this.target;
    }

    public void cancelDamage() {
        this.isCancelled = true;
    }

    public boolean isDamageCancelled() {
        return this.isCancelled || this.damage <= 0.0f;
    }

    public boolean isDirect() {
        return this.source.m_7640_() == this.source.m_7639_();
    }

    public boolean willTakeFullDamage() {
        return this.target.f_19802_ <= 10;
    }
}

