/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszlibrary.data.IReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

class ReaderMap<Type>
implements IReader<Map<String, Type>> {
    private final IReader<Type> reader;

    public ReaderMap(IReader<Type> reader) {
        this.reader = reader;
    }

    @Override
    public JsonElement writeJson(Map<String, Type> values) {
        JsonObject jsonObject = new JsonObject();
        for (String key : new TreeSet<String>(values.keySet())) {
            jsonObject.add(key, this.reader.writeJson(values.get(key)));
        }
        return jsonObject;
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer, Map<String, Type> values) {
        buffer.m_130130_(values.size());
        for (String key : new TreeSet<String>(values.keySet())) {
            buffer.m_130070_(key);
            this.reader.writeBuffer(buffer, values.get(key));
        }
    }

    @Override
    public Tag writeTag(Map<String, Type> values) {
        CompoundTag compoundTag = new CompoundTag();
        for (String key : new TreeSet<String>(values.keySet())) {
            compoundTag.m_128365_(key, this.reader.writeTag(values.get(key)));
        }
        return compoundTag;
    }

    @Override
    public Map<String, Type> readJson(JsonElement json) {
        HashMap<String, Type> values = new HashMap<String, Type>();
        for (String key : json.getAsJsonObject().keySet()) {
            values.put(key, this.reader.readJson(json.getAsJsonObject().get(key)));
        }
        return values;
    }

    @Override
    public Map<String, Type> readBuffer(FriendlyByteBuf buffer) {
        HashMap<String, Type> values = new HashMap<String, Type>();
        int size = buffer.m_130242_();
        for (int idx = 0; idx < size; ++idx) {
            String key = buffer.m_130277_();
            values.put(key, this.reader.readBuffer(buffer));
        }
        return values;
    }

    @Override
    public Map<String, Type> readTag(Tag tag) {
        HashMap<String, Type> values = new HashMap<String, Type>();
        for (String key : ((CompoundTag)tag).m_128431_()) {
            values.put(key, this.reader.readTag(((CompoundTag)tag).m_128423_(key)));
        }
        return values;
    }
}

