/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.animations;

import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.ModelParts;
import com.majruszlibrary.time.TimeHelper;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Animation {
    public static Animation INVALID = new Animation(null);
    private final AnimationsDef.AnimationDef def;
    private final Map<Integer, List<Runnable>> callbacks = new HashMap<Integer, List<Runnable>>();
    private int ticksLeft;

    public static Vector3f to3d(List<Float> values) {
        return new Vector3f(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue());
    }

    public static List<Float> to3d(Vector3f vector) {
        return List.of(Float.valueOf(vector.m_122239_()), Float.valueOf(vector.m_122260_()), Float.valueOf(vector.m_122269_()));
    }

    public static Vec2 to2d(List<Integer> values) {
        return new Vec2((float)values.get(0).intValue(), (float)values.get(1).intValue());
    }

    public static List<Integer> to2d(Vec2 vector) {
        return List.of(Integer.valueOf((int)vector.f_82470_), Integer.valueOf((int)vector.f_82471_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void apply(ModelParts modelParts, float ageInTicks) {
        float duration = (float)TimeHelper.toSeconds(Mth.m_14045_((int)(this.def.ticks - this.ticksLeft), (int)0, (int)this.def.ticks));
        this.def.bones.forEach((name, bone) -> {
            ModelPart modelPart = modelParts.get((String)name);
            float toRadiansScale = (float)Math.PI / 180;
            Vector3f rotation = this.lerp(bone.rotations, duration, ageInTicks).orElseGet(() -> new Vector3f(0.0f, 0.0f, 0.0f));
            modelPart.f_104203_ += rotation.m_122239_() * toRadiansScale;
            modelPart.f_104204_ += rotation.m_122260_() * toRadiansScale;
            modelPart.f_104205_ += rotation.m_122269_() * toRadiansScale;
            Vector3f position = this.lerp(bone.positions, duration, ageInTicks).orElseGet(() -> new Vector3f(0.0f, 0.0f, 0.0f));
            modelPart.f_104200_ += position.m_122239_();
            modelPart.f_104201_ -= position.m_122260_();
            modelPart.f_104202_ += position.m_122269_();
            Vector3f scale = this.lerp(bone.scales, duration, ageInTicks).orElseGet(() -> new Vector3f(1.0f, 1.0f, 1.0f));
            modelPart.f_233553_ *= scale.m_122239_();
            modelPart.f_233554_ *= scale.m_122260_();
            modelPart.f_233555_ *= scale.m_122269_();
        });
    }

    public Animation addCallback(int tick, Runnable callback) {
        this.callbacks.computeIfAbsent(tick, ArrayList::new).add(callback);
        return this;
    }

    public void tick() {
        --this.ticksLeft;
        int tickIdx = this.def.ticks - this.ticksLeft;
        if (this.callbacks.containsKey(tickIdx)) {
            this.callbacks.get(tickIdx).forEach(Runnable::run);
        }
        if (this.isFinished() && this.def.isLooped) {
            this.ticksLeft = this.def.ticks;
        }
    }

    public boolean isFinished() {
        return this.ticksLeft <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private Optional<Vector3f> lerp(TreeMap<Float, ? extends AnimationsDef.VectorDef> vectors, float duration, float ageInTicks) {
        if (vectors.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry<Float, ? extends AnimationsDef.VectorDef> current = vectors.floorEntry(Float.valueOf(duration));
        Map.Entry<Float, ? extends AnimationsDef.VectorDef> next = vectors.ceilingEntry(Float.valueOf(duration));
        if (current == null) {
            current = next;
        } else if (next == null) {
            next = current;
        }
        if (current.getValue() != next.getValue()) {
            float ratio = (float)((double)duration + (double)(ageInTicks % 1.0f) * TimeHelper.toSeconds(1) - (double)current.getKey().floatValue()) / (next.getKey().floatValue() - current.getKey().floatValue());
            ratio = next.getValue().easing.apply(ratio);
            return Optional.of(new Vector3f(Mth.m_14179_((float)ratio, (float)current.getValue().vector.m_122239_(), (float)next.getValue().vector.m_122239_()), Mth.m_14179_((float)ratio, (float)current.getValue().vector.m_122260_(), (float)next.getValue().vector.m_122260_()), Mth.m_14179_((float)ratio, (float)current.getValue().vector.m_122269_(), (float)next.getValue().vector.m_122269_())));
        }
        return Optional.of(new Vector3f(current.getValue().vector.m_122239_(), current.getValue().vector.m_122260_(), current.getValue().vector.m_122269_()));
    }

    Animation(AnimationsDef.AnimationDef def) {
        this.def = def;
        this.ticksLeft = def != null ? def.ticks : 1;
    }
}

