/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.lich;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntity;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityStats;
import com.cerbon.bosses_of_mass_destruction.util.BMDColors;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LichUtils {
    public static final List<Float> hpPercentRageModes = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f));
    public static final Function<Float, Vec3> blueColorFade = f -> MathUtils.lerpVec(f.floatValue(), BMDColors.COMET_BLUE, BMDColors.FADED_COMET_BLUE);
    public static final int textureSize = 256;

    public static long timeToNighttime(long currentTime) {
        long dayLength = 24000L;
        long midnight = 16000L;
        return currentTime - currentTime % dayLength + midnight;
    }

    public static void cappedHeal(IEntity iEntity, IEntityStats stats, List<Float> hpPercentRageModes, float healingStrength, Consumer<Float> heal) {
        float targetHealthRatio;
        float healAmt;
        if (iEntity.isAlive() && (healAmt = Mth.m_14036_((float)((targetHealthRatio = MathUtils.roundedStep(stats.getHealth() / stats.getMaxHealth(), hpPercentRageModes, false)) * stats.getMaxHealth() - stats.getHealth() - 1.0f), (float)0.0f, (float)healingStrength)) > 0.0f) {
            heal.accept(Float.valueOf(healAmt));
        }
    }
}

