/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AquaFishingRodItem
extends FishingRodItem {
    private final Tier tier;
    private final int enchantability;

    public AquaFishingRodItem(Tier tier, Item.Properties properties) {
        super(properties);
        this.enchantability = tier == Tiers.WOOD ? 10 : tier.m_6601_();
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return this.getDamage(stack) < this.getMaxDamage(stack) && super.m_142522_(stack);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && this.tier == AquacultureAPI.MATS.NEPTUNIUM;
        int damage = this.getDamage(heldStack);
        if (damage >= this.getMaxDamage(heldStack)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
        }
        Hook hook = AquaFishingRodItem.getHookType(heldStack);
        if (player.f_36083_ != null) {
            if (!level.f_46443_) {
                int currentDamage;
                int lureSpeed = player.f_36083_.m_37156_(heldStack);
                if (lureSpeed >= (currentDamage = this.getMaxDamage(heldStack) - damage)) {
                    lureSpeed = currentDamage;
                }
                if (!isAdminRod) {
                    if (hook != Hooks.EMPTY && hook.getDurabilityChance() > 0.0) {
                        if (level.f_46441_.m_188500_() >= hook.getDurabilityChance()) {
                            heldStack.m_220157_(lureSpeed, level.f_46441_, null);
                        }
                    } else {
                        heldStack.m_220157_(lureSpeed, level.f_46441_, null);
                    }
                }
            }
            player.m_6674_(hand);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
            player.m_146850_(GameEvent.f_223697_);
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                int lureSpeed = EnchantmentHelper.m_44916_((ItemStack)heldStack);
                if (this.tier == AquacultureAPI.MATS.NEPTUNIUM) {
                    ++lureSpeed;
                }
                ItemStack bait = AquaFishingRodItem.getBait(heldStack);
                if (!isAdminRod && !bait.m_41619_()) {
                    lureSpeed += ((BaitItem)bait.m_41720_()).getLureSpeedModifier();
                }
                lureSpeed = Math.min(5, lureSpeed);
                int luck = EnchantmentHelper.m_44904_((ItemStack)heldStack);
                if (hook != Hooks.EMPTY && hook.getLuckModifier() > 0) {
                    luck += hook.getLuckModifier();
                }
                level.m_7967_((Entity)new AquaFishingBobberEntity(player, level, luck, lureSpeed, hook, AquaFishingRodItem.getFishingLine(heldStack), AquaFishingRodItem.getBobber(heldStack), heldStack));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.m_146850_(GameEvent.f_223698_);
        }
        return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)level.m_5776_());
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.tier.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    @Nonnull
    public static Hook getHookType(@Nonnull ItemStack fishingRod) {
        ItemStack hookStack;
        Hook hook = Hooks.EMPTY;
        ItemStackHandler rodHandler = (ItemStackHandler)fishingRod.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)FishingRodEquipmentHandler.EMPTY.getItems());
        if (!fishingRod.m_41619_() && fishingRod.m_41782_() && fishingRod.m_41783_() != null && fishingRod.m_41783_().m_128441_("Inventory")) {
            rodHandler.deserializeNBT(fishingRod.m_41783_().m_128469_("Inventory"));
        }
        if ((hookStack = rodHandler.getStackInSlot(0)).m_41720_() instanceof HookItem) {
            hook = ((HookItem)hookStack.m_41720_()).getHookType();
        }
        return hook;
    }

    @Nonnull
    public static ItemStack getBait(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(1);
    }

    @Nonnull
    public static ItemStack getFishingLine(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(2);
    }

    @Nonnull
    public static ItemStack getBobber(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(3);
    }

    public static ItemStackHandler getHandler(@Nonnull ItemStack fishingRod) {
        ItemStackHandler rodHandler = (ItemStackHandler)fishingRod.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)FishingRodEquipmentHandler.EMPTY.getItems());
        if (!fishingRod.m_41619_() && fishingRod.m_41782_() && fishingRod.m_41783_() != null && fishingRod.m_41783_().m_128441_("Inventory")) {
            rodHandler.deserializeNBT(fishingRod.m_41783_().m_128469_("Inventory"));
        }
        return rodHandler;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new FishingRodEquipmentHandler(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag tooltipFlag) {
        Hook hook;
        if (this.getDamage(stack) >= this.getMaxDamage(stack)) {
            MutableComponent broken = Component.m_237115_((String)"aquaculture.fishing_rod.broken");
            tooltips.add((Component)broken.m_130948_(broken.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
        }
        if ((hook = AquaFishingRodItem.getHookType(stack)) != Hooks.EMPTY) {
            MutableComponent hookColor = Component.m_237115_((String)hook.getItem().m_5524_());
            tooltips.add((Component)hookColor.m_130948_(hookColor.m_7383_().m_131140_(hook.getColor())));
        }
        super.m_7373_(stack, level, tooltips, tooltipFlag);
    }

    public static class FishingRodEquipmentHandler
    implements ICapabilityProvider {
        public static final FishingRodEquipmentHandler EMPTY = new FishingRodEquipmentHandler(ItemStack.f_41583_);
        private final LazyOptional<IItemHandler> holder = LazyOptional.of(this::getItems);
        private final ItemStack stack;
        private final ItemStackHandler items = new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> stack.m_41720_() instanceof HookItem;
                    case 1 -> stack.m_41720_() instanceof BaitItem;
                    case 2 -> {
                        if (stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && stack.m_41720_() instanceof DyeableLeatherItem) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (stack.m_204117_(AquacultureAPI.Tags.BOBBER) && stack.m_41720_() instanceof DyeableLeatherItem) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            protected void onContentsChanged(int slot) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_("Inventory", (Tag)this.serializeNBT());
                stack.m_41751_(tag);
            }
        };

        FishingRodEquipmentHandler(@Nonnull ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            return capability == ForgeCapabilities.ITEM_HANDLER ? this.holder.cast() : LazyOptional.empty();
        }

        @Nonnull
        public ItemStackHandler getItems() {
            return this.items;
        }
    }
}

