/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class TackleBoxBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape NORTH_SOUTH = Block.m_49796_((double)0.8, (double)0.0, (double)3.9, (double)15.2, (double)9.0, (double)12.2);
    private static final VoxelShape EAST_WEST = Block.m_49796_((double)3.9, (double)0.0, (double)0.8, (double)12.2, (double)9.0, (double)15.2);

    public TackleBoxBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TackleBoxBlockEntity(pos, state);
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return NORTH_SOUTH;
            }
            case EAST: 
            case WEST: {
                return EAST_WEST;
            }
        }
        return super.m_5940_(state, blockReader, pos, context);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = this.m_7246_(state, world, pos);
        if (container != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_6144_()) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (tileEntity != null) {
                    ItemStack giveStack = new ItemStack((ItemLike)this);
                    tileEntity.m_187476_(giveStack);
                    StackHelper.giveItem((Player)serverPlayer, giveStack);
                    world.m_7471_(pos, false);
                    world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.6f, 0.8f);
                }
            } else {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)container, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placerFacing = context.m_8125_().m_122424_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placerFacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = world.m_7702_(pos)) instanceof TackleBoxBlockEntity) {
            ((TackleBoxBlockEntity)tileentity).setCustomName(stack.m_41786_());
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TackleBoxBlockEntity) {
            Optional redstone = tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(ItemHandlerHelper::calcRedstoneFromInventory);
            return redstone.orElse(0);
        }
        return 0;
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            level.m_46717_(pos, (Block)this);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6240_(@Nonnull Level level, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity tileEntity, @Nonnull ItemStack stack) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TackleBoxBlockEntity) {
            ItemStack tackleBox = new ItemStack((ItemLike)this);
            blockEntity.m_187476_(tackleBox);
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tackleBox);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack cloneItemStack = super.getCloneItemStack(state, target, level, pos, player);
        level.m_141902_(pos, (BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()).ifPresent(blockEntity -> blockEntity.m_187476_(cloneItemStack));
        return cloneItemStack;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            this.dropInventory(level, pos);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    private void dropInventory(Level level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity != null) {
            tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> StackHelper.dropInventory(level, pos, handler));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? TackleBoxBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()), TackleBoxBlockEntity::lidAnimateTick) : null;
    }

    public void m_213897_(@Nonnull BlockState state, ServerLevel serverLevel, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntity blockEntity = serverLevel.m_7702_(pos);
        if (blockEntity instanceof TackleBoxBlockEntity) {
            ((TackleBoxBlockEntity)blockEntity).recheckOpen();
        }
    }
}

