/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomePlacementRndSpread
extends RandomSpreadStructurePlacement {
    protected final int f_204973_;
    protected final int f_204974_;
    protected final int f_227025_;
    protected final RandomSpreadType f_204975_;
    protected final Vec3i f_227022_;
    protected final String uniqueIdentifier;
    protected final boolean useValueFromConfiguration;
    protected final Optional<SuperExclusionZone> superExclusionZone;

    public static <T extends AwesomePlacementRndSpread> Codec<T> createCodec(Function8<Integer, Integer, RandomSpreadType, Integer, Vec3i, String, Boolean, Optional<SuperExclusionZone>, T> awsRandomSpread) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(AwesomePlacementRndSpread::m_205003_), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(AwesomePlacementRndSpread::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(AwesomePlacementRndSpread::m_205005_), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(AwesomePlacementRndSpread::m_227075_), (App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(AwesomePlacementRndSpread::m_227072_), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomePlacementRndSpread::uniqueIdentifier), (App)Codec.BOOL.optionalFieldOf("use_value_from_config_file", (Object)false).forGetter(AwesomePlacementRndSpread::useValueFromConfiguration), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AwesomePlacementRndSpread::superExclusionZone)).apply((Applicative)i, i.stable((Object)awsRandomSpread))).flatXmap(r -> r.f_204973_ <= r.f_204974_ ? DataResult.error((String)"Spacing has to be larger than separation") : (r.useValueFromConfiguration && r.uniqueIdentifier.length() <= 1 ? DataResult.error((String)"Require String field `unique_identifier` if use value from configuration") : DataResult.success((Object)r)), DataResult::success).codec();
    }

    public AwesomePlacementRndSpread(int spacing, int separation, RandomSpreadType spreadType, int salt, Vec3i locateOffset, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        this(locateOffset, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, salt, Optional.empty(), spacing, separation, spreadType, uniqueIdentifier, useValueFromConfiguration, superExclusionZone);
    }

    public AwesomePlacementRndSpread(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType spreadType, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.useValueFromConfiguration = useValueFromConfiguration;
        this.uniqueIdentifier = uniqueIdentifier;
        this.f_204973_ = this.useValueFromConfiguration ? this.bindSpacingFromConfiguration() : spacing;
        this.f_204974_ = this.useValueFromConfiguration ? this.bindSeparationFromConfiguration() : separation;
        this.f_227025_ = this.useValueFromConfiguration ? this.bindSaltFromConfiguration() : salt;
        this.f_204975_ = spreadType;
        this.f_227022_ = locateOffset;
        this.superExclusionZone = superExclusionZone;
        LibraryFerret.LOGGER.info(this.toString());
    }

    public ChunkPos getStartChunk(long seed, int x, int z) {
        int i = this.m_205003_();
        int j = this.m_205004_();
        int k = Math.floorDiv(x, i);
        int l = Math.floorDiv(z, i);
        WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        chunkRandom.m_190058_(seed, k, l, this.m_227075_());
        int m = i - j;
        int n = this.m_205005_().m_227018_((RandomSource)chunkRandom, m);
        int o = this.m_205005_().m_227018_((RandomSource)chunkRandom, m);
        return new ChunkPos(k * i + n, l * i + o);
    }

    protected boolean m_214090_(@NotNull ChunkGenerator ignoredChunkGenerator, @NotNull RandomState ignoredRandomState, long seed, int x, int z) {
        ChunkPos chunkPos = this.getStartChunk(seed, x, z);
        return chunkPos.f_45578_ == x && chunkPos.f_45579_ == z;
    }

    public boolean m_227054_(@NotNull ChunkGenerator chunkGenerator, @NotNull RandomState randomState, long l, int i, int j) {
        if (!super.m_227054_(chunkGenerator, randomState, l, i, j)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(chunkGenerator, randomState, l, i, j);
    }

    public String toString() {
        return "Structure placement for `" + this.uniqueIdentifier + "`: { spacing: " + this.f_204973_ + ", separation: " + this.f_204974_ + ", salt: " + this.f_227025_ + ", useValueFromConfiguration: " + this.useValueFromConfiguration + "}";
    }

    public abstract int bindSpacingFromConfiguration();

    public abstract int bindSeparationFromConfiguration();

    public abstract int bindSaltFromConfiguration();

    public int m_205003_() {
        return this.f_204973_;
    }

    public int m_205004_() {
        return this.f_204974_;
    }

    public int m_227075_() {
        return this.f_227025_;
    }

    @NotNull
    public RandomSpreadType m_205005_() {
        return this.f_204975_;
    }

    @NotNull
    public Vec3i m_227072_() {
        return this.f_227022_;
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public boolean useValueFromConfiguration() {
        return this.useValueFromConfiguration;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public record SuperExclusionZone(HolderSet<StructureSet> otherSet, int chunkCount) {
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.m_206279_((ResourceKey)Registry.f_211073_, (Codec)StructureSet.f_210001_).fieldOf("other_set").forGetter(SuperExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(SuperExclusionZone::chunkCount)).apply((Applicative)builder, SuperExclusionZone::new));

        public boolean isPlacementForbidden(ChunkGenerator chunkGenerator, RandomState randomState, long l, int i, int j) {
            for (Holder holder : this.otherSet) {
                if (!chunkGenerator.m_223141_(holder, randomState, l, i, j, this.chunkCount)) continue;
                return true;
            }
            return false;
        }
    }
}

