/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfyu.vinery.recipe.FermentationBarrelRecipe;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.util.VineryTags;

@OnlyIn(value=Dist.CLIENT)
public enum FermentationBarrelRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    WINE(new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get())),
    MISC(new ItemStack((ItemLike)ObjectRegistry.APPLE_JUICE.get()));

    public static final List<IRecipeBookGroup> FERMENTATION_GROUPS;
    private final List<ItemStack> icons;

    private FermentationBarrelRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe) {
        if (recipe instanceof FermentationBarrelRecipe) {
            FermentationBarrelRecipe fermentationBarrelRecipe = (FermentationBarrelRecipe)recipe;
            switch (this) {
                case SEARCH: {
                    return true;
                }
                case WINE: {
                    if (!fermentationBarrelRecipe.m_8043_().m_204117_(VineryTags.WINE)) break;
                    return true;
                }
                case MISC: {
                    if (fermentationBarrelRecipe.m_8043_().m_204117_(VineryTags.WINE)) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        FERMENTATION_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)WINE), (Object)((Object)MISC));
    }
}

