/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.recipes.cooking;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfyu.meadow.registry.RecipeRegistry;
import net.satisfyu.meadow.util.GeneralUtil;

public class CookingCauldronRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public CookingCauldronRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 0, 6);
    }

    public ItemStack m_5874_(Container inventory) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.COOKING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.COOKING.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Type
    implements RecipeType<CookingCauldronRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "cooking";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CookingCauldronRecipe> {
        public CookingCauldronRecipe read(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingCauldron Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingPot Recipe");
            }
            return new CookingCauldronRecipe(id, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")));
        }

        public CookingCauldronRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            return new CookingCauldronRecipe(id, (NonNullList<Ingredient>)ingredients, buf.m_130267_());
        }

        public void write(FriendlyByteBuf buf, CookingCauldronRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.m_8043_());
        }
    }
}

