/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfyu.meadow.client.screen.handler.FondueGuiHandler;
import net.satisfyu.meadow.registry.BlockEntityRegistry;
import net.satisfyu.meadow.registry.ObjectRegistry;
import net.satisfyu.meadow.registry.TagRegistry;
import net.satisfyu.meadow.util.ImplementedInventory;
import org.jetbrains.annotations.Nullable;

public class FondueBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> FondueBlockEntity.this.progress;
                case 1 -> FondueBlockEntity.this.MAX_PROGRESS;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FondueBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FondueBlockEntity.this.MAX_PROGRESS = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    public int MAX_PROGRESS = 72;
    private int fuelAmount = 0;

    public FondueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.FONDUE.get(), pos, state);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_130674_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new FondueGuiHandler(syncId, inv, this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("fondue.progress", this.progress);
        nbt.m_128405_("fondue.fuelAmount", this.fuelAmount);
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress = nbt.m_128451_("fondue.progress");
        this.fuelAmount = nbt.m_128451_("fondue.fuelAmount");
        super.m_142466_(nbt);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, FondueBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (FondueBlockEntity.hasRecipe(entity) && FondueBlockEntity.hasFuel(entity)) {
            ++entity.progress;
            FondueBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
            if (entity.progress >= entity.MAX_PROGRESS) {
                FondueBlockEntity.craftItem(entity);
            }
        } else {
            entity.resetProgress();
            FondueBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static boolean hasFuel(FondueBlockEntity entity) {
        if (entity.fuelAmount > 0) {
            return true;
        }
        ItemStack stack = (ItemStack)entity.inventory.get(2);
        if (stack.m_204117_(TagRegistry.CHEESE)) {
            entity.fuelAmount = 10;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    private static void craftItem(FondueBlockEntity entity) {
        entity.m_7407_(0, 1);
        entity.m_6836_(1, new ItemStack((ItemLike)ObjectRegistry.CHEESE_STICK.get(), entity.m_8020_(1).m_41613_() + 1));
        entity.resetProgress();
        --entity.fuelAmount;
    }

    private static boolean hasRecipe(FondueBlockEntity entity) {
        boolean hasBreadInFirstSlot = entity.m_8020_(0).m_41720_() == Items.f_42406_;
        return hasBreadInFirstSlot && FondueBlockEntity.canInsertAmountIntoOutputSlot(entity.inventory) && FondueBlockEntity.canInsertItemIntoOutputSlot(entity.inventory, (Item)ObjectRegistry.CHEESE_STICK.get());
    }

    private static boolean canInsertItemIntoOutputSlot(NonNullList<ItemStack> inventory, Item output) {
        return ((ItemStack)inventory.get(1)).m_41720_() == output || ((ItemStack)inventory.get(1)).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(NonNullList<ItemStack> inventory) {
        return ((ItemStack)inventory.get(1)).m_41741_() > ((ItemStack)inventory.get(1)).m_41613_();
    }
}

