/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfyu.meadow.client.screen.handler.WoodcutterGuiHandler;
import net.satisfyu.meadow.recipes.woodcutting.WoodcuttingRecipe;

public class WoodcutterGui
extends AbstractContainerScreen<WoodcutterGuiHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("meadow", "textures/gui/woodcutter.png");
    private final int recipeIconPosX = 58;
    private final int recipeIconPosY = 15;
    private final int maxRecipeIcons = 16;
    private final int recipeIconWidth = 16;
    private final int recipeIconHeight = 18;
    private final int recipeIconPerLine = 4;
    private boolean canCraft;

    public WoodcutterGui(WoodcutterGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        this.m_7333_(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int posX = this.f_97735_;
        int posY = this.f_97736_;
        this.m_93228_(matrices, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
        int recipeX = posX + 58;
        int recipeY = posY + 15;
        this.renderRecipeBackground(matrices, mouseX, mouseY, recipeX, recipeY);
        this.renderRecipeIcons(recipeX, recipeY);
    }

    private void renderRecipeBackground(PoseStack matrices, int mouseX, int mouseY, int x, int y) {
        for (int i = 0; i < 16 && i < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++i) {
            int posX = x + 16 * (i % 4);
            int l = i / 4;
            int posY = y + 18 * l;
            int offsetY = this.f_97727_;
            if (i == ((WoodcutterGuiHandler)this.f_97732_).getSelectedRecipe()) {
                offsetY += 18;
            } else if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 18) {
                offsetY += 36;
            }
            this.m_93228_(matrices, posX, posY, 0, offsetY, 16, 18);
        }
    }

    private void renderRecipeIcons(int x, int y) {
        List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipes();
        for (int i = 0; i < 16 && i < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++i) {
            int k = x + 16 * (i % 4);
            int l = i / 4;
            int m = y + 18 * l + 1;
            this.f_96541_.m_91291_().m_115203_(list.get(i).m_8043_(), k, m);
        }
    }

    protected void m_7025_(PoseStack matrices, int x, int y) {
        super.m_7025_(matrices, x, y);
        if (this.canCraft) {
            int i = this.f_97735_ + 58;
            int j = this.f_97736_ + 15;
            List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipes();
            for (int l = 0; l < 16 && l < ((WoodcutterGuiHandler)this.f_97732_).getAvailableRecipeCount(); ++l) {
                int n = i + l % 4 * 16;
                int o = j + l / 4 * 18;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                this.m_6057_(matrices, list.get(l).m_8043_(), x, y);
            }
        }
    }

    private void onInventoryChange() {
        this.canCraft = ((WoodcutterGuiHandler)this.f_97732_).canCraft();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.canCraft) {
            int i = this.f_97735_ + 58;
            int j = this.f_97736_ + 15;
            for (int l = 0; l < 16; ++l) {
                double d = mouseX - (double)(i + l % 4 * 16);
                double e = mouseY - (double)(j + l / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WoodcutterGuiHandler)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l))) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WoodcutterGuiHandler)this.f_97732_).f_38840_, l);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }
}

