/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfyu.meadow.block.CheeseBlock;
import net.satisfyu.meadow.recipes.cheese.CheeseFormRecipe;
import net.satisfyu.meadow.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum CheeseFormRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    CHEESE(new ItemStack((ItemLike)ObjectRegistry.PIECE_OF_CHEESE.get())),
    MISC(new ItemStack((ItemLike)ObjectRegistry.RENNET.get()));

    public static final List<IRecipeBookGroup> CHEESE_GROUPS;
    private final List<ItemStack> icons;

    private CheeseFormRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe) {
        if (recipe instanceof CheeseFormRecipe) {
            CheeseFormRecipe cheeseFormRecipe = (CheeseFormRecipe)recipe;
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SEARCH -> true;
                case CHEESE -> {
                    BlockItem blockItem;
                    Item var4_3 = recipe.m_8043_().m_41720_();
                    if (var4_3 instanceof BlockItem && (blockItem = (BlockItem)var4_3).m_40614_() instanceof CheeseBlock) {
                        yield true;
                    }
                    yield false;
                }
                case MISC -> {
                    BlockItem blockItem;
                    Item var4_4 = recipe.m_8043_().m_41720_();
                    yield var4_4 instanceof BlockItem && !((blockItem = (BlockItem)var4_4).m_40614_() instanceof CheeseBlock);
                }
            };
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        CHEESE_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)CHEESE), (Object)((Object)MISC));
    }
}

